/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.realm;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.IntrospectionUtils;
import com.bes.enterprise.web.util.digester.Digester;
import com.bes.enterprise.webtier.CredentialHandler;
import com.bes.enterprise.webtier.realm.GenericPrincipal;
import com.bes.enterprise.webtier.realm.MemoryRealm;
import com.bes.enterprise.webtier.realm.MemoryRuleSet;
import com.bes.enterprise.webtier.realm.MessageDigestCredentialHandler;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class JAASMemoryLoginModule
extends MemoryRealm
implements LoginModule {
    private static final Log log = LogFactory.getLog(JAASMemoryLoginModule.class);
    protected CallbackHandler callbackHandler = null;
    protected boolean committed = false;
    protected Map<String, ?> options = null;
    protected String pathname = "conf/appServer-users.xml";
    protected Principal principal = null;
    protected Map<String, ?> sharedState = null;
    protected Subject subject = null;

    public JAASMemoryLoginModule() {
        if (log.isDebugEnabled()) {
            log.debug("MEMORY LOGIN MODULE");
        }
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.principal == null) {
            return false;
        }
        if (this.committed) {
            this.logout();
        } else {
            this.committed = false;
            this.principal = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Abort");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (log.isDebugEnabled()) {
            log.debug("commit " + this.principal);
        }
        if (this.principal == null) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
            if (this.principal instanceof GenericPrincipal) {
                String[] roles = ((GenericPrincipal)this.principal).getRoles();
                for (int i2 = 0; i2 < roles.length; ++i2) {
                    this.subject.getPrincipals().add(new GenericPrincipal(roles[i2], null, null));
                }
            }
        }
        this.committed = true;
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (log.isDebugEnabled()) {
            log.debug("Init");
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        Object option = options.get("pathname");
        if (option instanceof String) {
            this.pathname = (String)option;
        }
        CredentialHandler credentialHandler = null;
        option = options.get("credentialHandlerClassName");
        if (option instanceof String) {
            try {
                Class<?> clazz = Class.forName((String)option);
                credentialHandler = (CredentialHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e2) {
                throw new IllegalArgumentException(e2);
            }
        }
        if (credentialHandler == null) {
            credentialHandler = new MessageDigestCredentialHandler();
        }
        for (Map.Entry<String, ?> entry : options.entrySet()) {
            if ("pathname".equals(entry.getKey()) || "credentialHandlerClassName".equals(entry.getKey()) || !(entry.getValue() instanceof String)) continue;
            IntrospectionUtils.setProperty(credentialHandler, entry.getKey(), (String)entry.getValue());
        }
        this.setCredentialHandler(credentialHandler);
        this.load();
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler specified");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new TextInputCallback("nonce"), new TextInputCallback("nc"), new TextInputCallback("cnonce"), new TextInputCallback("qop"), new TextInputCallback("realmName"), new TextInputCallback("md5a2"), new TextInputCallback("authMethod")};
        String username = null;
        String password = null;
        String nonce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String realmName = null;
        String md5a2 = null;
        String authMethod = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = ((NameCallback)callbacks[0]).getName();
            password = new String(((PasswordCallback)callbacks[1]).getPassword());
            nonce = ((TextInputCallback)callbacks[2]).getText();
            nc = ((TextInputCallback)callbacks[3]).getText();
            cnonce = ((TextInputCallback)callbacks[4]).getText();
            qop = ((TextInputCallback)callbacks[5]).getText();
            realmName = ((TextInputCallback)callbacks[6]).getText();
            md5a2 = ((TextInputCallback)callbacks[7]).getText();
            authMethod = ((TextInputCallback)callbacks[8]).getText();
        }
        catch (IOException | UnsupportedCallbackException e2) {
            throw new LoginException(e2.toString());
        }
        if (authMethod == null) {
            this.principal = super.authenticate(username, password);
        } else if (authMethod.equals("DIGEST")) {
            this.principal = super.authenticate(username, password, nonce, nc, cnonce, qop, realmName, md5a2);
        } else if (authMethod.equals("CLIENT_CERT")) {
            this.principal = super.getPrincipal(username);
        } else {
            throw new LoginException("Unknown authentication method");
        }
        if (log.isDebugEnabled()) {
            log.debug("login " + username + " " + this.principal);
        }
        if (this.principal != null) {
            return true;
        }
        throw new FailedLoginException("Username or password is incorrect");
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.committed = false;
        this.principal = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            String heavenBase = this.getHeavenBase();
            if (heavenBase == null) {
                log.warn("Unable to determine Heaven base to load file " + this.pathname);
                return;
            }
            file = new File(heavenBase, this.pathname);
        }
        if (!file.canRead()) {
            log.warn("Cannot load configuration file " + file.getAbsolutePath());
            return;
        }
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addRuleSet(new MemoryRuleSet());
        try {
            digester.push(this);
            digester.parse(file);
        }
        catch (Exception e2) {
            log.warn("Error processing configuration file " + file.getAbsolutePath(), e2);
            return;
        }
        finally {
            digester.reset();
        }
    }

    private String getHeavenBase() {
        if (this.callbackHandler == null) {
            return null;
        }
        Callback[] callbacks = new Callback[]{new TextInputCallback("heavenBase")};
        String result = null;
        try {
            this.callbackHandler.handle(callbacks);
            result = ((TextInputCallback)callbacks[0]).getText();
        }
        catch (IOException | UnsupportedCallbackException e2) {
            return null;
        }
        return result;
    }
}

