/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.realm;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.digester.Digester;
import com.bes.enterprise.web.util.file.ConfigFileLoader;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.realm.GenericPrincipal;
import com.bes.enterprise.webtier.realm.MemoryRuleSet;
import com.bes.enterprise.webtier.realm.RealmBase;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MemoryRealm
extends RealmBase {
    private static final Log log = LogFactory.getLog(MemoryRealm.class);
    private static Digester digester = null;
    @Deprecated
    protected static final String name = "MemoryRealm";
    private String pathname = "conf/appServer-users.xml";
    private final Map<String, GenericPrincipal> principals = new HashMap<String, GenericPrincipal>();

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
    }

    @Override
    public Principal authenticate(String username, String credentials) {
        if (username == null || credentials == null) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("memoryRealm.authenticateFailure", username));
            }
            return null;
        }
        GenericPrincipal principal = this.principals.get(username);
        if (principal == null || principal.getPassword() == null) {
            this.getCredentialHandler().mutate(credentials);
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("memoryRealm.authenticateFailure", username));
            }
            return null;
        }
        boolean validated = this.getCredentialHandler().matches(credentials, principal.getPassword());
        if (validated) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("memoryRealm.authenticateSuccess", username));
            }
            return principal;
        }
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("memoryRealm.authenticateFailure", username));
        }
        return null;
    }

    void addUser(String username, String password, String roles) {
        int comma;
        ArrayList<String> list = new ArrayList<String>();
        roles = roles + ",";
        while ((comma = roles.indexOf(44)) >= 0) {
            String role = roles.substring(0, comma).trim();
            list.add(role);
            roles = roles.substring(comma + 1);
        }
        GenericPrincipal principal = new GenericPrincipal(username, password, list);
        this.principals.put(username, principal);
    }

    protected synchronized Digester getDigester() {
        if (digester == null) {
            digester = new Digester();
            digester.setValidating(false);
            try {
                digester.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            }
            catch (Exception e2) {
                log.warn(sm.getString("memoryRealm.xmlFeatureEncoding"), e2);
            }
            digester.addRuleSet(new MemoryRuleSet());
        }
        return digester;
    }

    @Override
    @Deprecated
    protected String getName() {
        return name;
    }

    @Override
    protected String getPassword(String username) {
        GenericPrincipal principal = this.principals.get(username);
        if (principal != null) {
            return principal.getPassword();
        }
        return null;
    }

    @Override
    protected Principal getPrincipal(String username) {
        return this.principals.get(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        String pathName = this.getPathname();
        try (InputStream is = ConfigFileLoader.getInputStream(pathName);){
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("memoryRealm.loadPath", pathName));
            }
            Digester digester = this.getDigester();
            try {
                Digester digester2 = digester;
                synchronized (digester2) {
                    digester.push(this);
                    digester.parse(is);
                }
            }
            catch (Exception e2) {
                throw new LifecycleException(sm.getString("memoryRealm.readXml"), e2);
            }
            finally {
                digester.reset();
            }
        }
        catch (IOException ioe) {
            throw new LifecycleException(sm.getString("memoryRealm.loadExist", pathName), ioe);
        }
        super.startInternal();
    }
}

