/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.realm;

import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.codec.binary.Base64;
import com.bes.enterprise.web.util.security.MD5Encoder;
import com.bes.enterprise.webtier.Group;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.Role;
import com.bes.enterprise.webtier.User;
import com.bes.enterprise.webtier.UserDatabase;
import com.bes.enterprise.webtier.Wrapper;
import com.bes.enterprise.webtier.realm.GenericPrincipal;
import com.bes.enterprise.webtier.realm.RealmBase;
import com.bes.enterprise.webtier.users.MemoryUserDatabase;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;

public class UserDatabaseRealm
extends RealmBase {
    protected UserDatabase database = null;
    @Deprecated
    protected static final String name = "UserDatabaseRealm";
    protected String resourceName = "UserDatabase";
    protected String pathname = null;
    protected String readOnly = null;

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
    }

    public String getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(String readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean hasRole(Wrapper wrapper, Principal principal, String role) {
        GenericPrincipal gp;
        String realRole;
        Principal rawPrincipal = principal;
        if (wrapper != null && (realRole = wrapper.findSecurityReference(role)) != null) {
            role = realRole;
        }
        if (principal instanceof GenericPrincipal && (gp = (GenericPrincipal)principal).getUserPrincipal() instanceof User) {
            principal = gp.getUserPrincipal();
        }
        if (!(principal instanceof User)) {
            return super.hasRole(null, principal, role);
        }
        if ("*".equals(role)) {
            return true;
        }
        if (role == null) {
            return false;
        }
        User user = (User)principal;
        Role dbrole = this.database.findRole(role);
        if (dbrole != null) {
            if (user.isInRole(dbrole)) {
                return true;
            }
            Iterator<Group> groups = user.getGroups();
            while (groups.hasNext()) {
                Group group = groups.next();
                if (!group.isInRole(dbrole)) continue;
                return true;
            }
        } else if (wrapper != null && this.checkRoleMapping(wrapper.getParent().getName(), role, rawPrincipal)) {
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    protected String getName() {
        return name;
    }

    @Override
    public void backgroundProcess() {
        if (this.database instanceof MemoryUserDatabase) {
            ((MemoryUserDatabase)this.database).backgroundProcess();
        }
    }

    @Override
    protected String getPassword(String username) {
        User user = this.database.findUser(username);
        if (user == null) {
            return null;
        }
        return user.getPassword();
    }

    @Override
    public String getDigest(String username, String realmName) {
        String password = this.getPassword(username);
        if (password == null) {
            return null;
        }
        byte[] passwordBytes = Base64.decodeBase64(password);
        if (passwordBytes == null) {
            return null;
        }
        String encodedPassword = MD5Encoder.encode(passwordBytes, passwordBytes.length);
        return encodedPassword;
    }

    @Override
    protected Principal getPrincipal(String username) {
        User user = this.database.findUser(username);
        if (user == null) {
            return null;
        }
        ArrayList<String> roles = new ArrayList<String>();
        Iterator<Role> uroles = user.getRoles();
        while (uroles.hasNext()) {
            Role role = uroles.next();
            roles.add(role.getName());
        }
        Iterator<Group> groups = user.getGroups();
        while (groups.hasNext()) {
            Group group = groups.next();
            uroles = group.getRoles();
            while (uroles.hasNext()) {
                Role role = uroles.next();
                roles.add(role.getName());
            }
        }
        return new GenericPrincipal(username, user.getPassword(), roles, user);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        MemoryUserDatabase memoryUserDatabase = null;
        try {
            memoryUserDatabase = new MemoryUserDatabase(name);
            if (this.pathname != null) {
                memoryUserDatabase.setPathname(this.pathname);
            }
            if (this.readOnly != null) {
                memoryUserDatabase.setReadonly(Boolean.parseBoolean(this.readOnly));
            }
            memoryUserDatabase.open();
            if (!memoryUserDatabase.getReadonly()) {
                memoryUserDatabase.save();
            }
            this.database = memoryUserDatabase;
        }
        catch (Throwable e2) {
            ExceptionUtils.handleThrowable(e2);
            this.containerLog.error(sm.getString("userDatabaseRealm.lookup", name), e2);
            this.database = null;
        }
        if (this.database == null) {
            throw new LifecycleException(sm.getString("userDatabaseRealm.noDatabase", name));
        }
        super.startInternal();
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.database = null;
    }

    protected String getPassword(String username, String credentials) {
        return this.database.authenticate(username, credentials) ? credentials : null;
    }
}

