/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.session;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.webtier.Lifecycle;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.Session;
import com.bes.enterprise.webtier.Store;
import com.bes.enterprise.webtier.StoreManager;
import com.bes.enterprise.webtier.security.SecurityUtil;
import com.bes.enterprise.webtier.session.DefaultSession;
import com.bes.enterprise.webtier.session.ManagerBase;
import com.bes.enterprise.webtier.session.StoreBase;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class PersistentManagerBase
extends ManagerBase
implements StoreManager {
    private final Log log = LogFactory.getLog(PersistentManagerBase.class);
    private static final String name = "PersistentManagerBase";
    private static final String PERSISTED_LAST_ACCESSED_TIME = "com.bes.enterprise.webtier.session.PersistentManagerBase.persistedLastAccessedTime";
    protected Store store = null;
    protected boolean saveOnRestart = true;
    protected int maxIdleBackup = -1;
    protected int minIdleSwap = -1;
    protected int maxIdleSwap = -1;
    private final Map<String, Object> sessionSwapInLocks = new HashMap<String, Object>();
    private final ThreadLocal<Session> sessionToSwapIn = new ThreadLocal();

    public int getMaxIdleBackup() {
        return this.maxIdleBackup;
    }

    public void setMaxIdleBackup(int backup) {
        if (backup == this.maxIdleBackup) {
            return;
        }
        int oldBackup = this.maxIdleBackup;
        this.maxIdleBackup = backup;
        this.support.firePropertyChange("maxIdleBackup", (Object)oldBackup, (Object)this.maxIdleBackup);
    }

    public int getMaxIdleSwap() {
        return this.maxIdleSwap;
    }

    public void setMaxIdleSwap(int max) {
        if (max == this.maxIdleSwap) {
            return;
        }
        int oldMaxIdleSwap = this.maxIdleSwap;
        this.maxIdleSwap = max;
        this.support.firePropertyChange("maxIdleSwap", (Object)oldMaxIdleSwap, (Object)this.maxIdleSwap);
    }

    public int getMinIdleSwap() {
        return this.minIdleSwap;
    }

    public void setMinIdleSwap(int min) {
        if (this.minIdleSwap == min) {
            return;
        }
        int oldMinIdleSwap = this.minIdleSwap;
        this.minIdleSwap = min;
        this.support.firePropertyChange("minIdleSwap", (Object)oldMinIdleSwap, (Object)this.minIdleSwap);
    }

    public boolean isLoaded(String id) {
        try {
            if (super.findSession(id) != null) {
                return true;
            }
        }
        catch (IOException e2) {
            this.log.error("checking isLoaded for id, " + id + ", " + e2.getMessage(), e2);
        }
        return false;
    }

    @Override
    public String getName() {
        return name;
    }

    public void setStore(Store store) {
        this.store = store;
        store.setManager(this);
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    public boolean getSaveOnRestart() {
        return this.saveOnRestart;
    }

    public void setSaveOnRestart(boolean saveOnRestart) {
        if (saveOnRestart == this.saveOnRestart) {
            return;
        }
        boolean oldSaveOnRestart = this.saveOnRestart;
        this.saveOnRestart = saveOnRestart;
        this.support.firePropertyChange("saveOnRestart", (Object)oldSaveOnRestart, (Object)this.saveOnRestart);
    }

    public void clearStore() {
        if (this.store == null) {
            return;
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreClear());
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    this.log.error("Exception clearing the Store: " + exception, exception);
                }
            } else {
                this.store.clear();
            }
        }
        catch (IOException e2) {
            this.log.error("Exception clearing the Store: " + e2, e2);
        }
    }

    @Override
    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int expireHere = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start expire sessions " + this.getName() + " at " + timeNow + " sessioncount " + sessions.length);
        }
        for (int i2 = 0; i2 < sessions.length; ++i2) {
            if (sessions[i2].isValid()) continue;
            this.expiredSessions.incrementAndGet();
            ++expireHere;
        }
        this.processPersistenceChecks();
        if (this.getStore() instanceof StoreBase) {
            ((StoreBase)this.getStore()).processExpires();
        }
        long timeEnd = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug("End expire sessions " + this.getName() + " processingTime " + (timeEnd - timeNow) + " expired sessions: " + expireHere);
        }
        this.processingTime += timeEnd - timeNow;
    }

    public void processPersistenceChecks() {
        this.processMaxIdleSwaps();
        this.processMaxActiveSwaps();
        this.processMaxIdleBackups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session findSession(String id) throws IOException {
        Session session = super.findSession(id);
        if (session != null && !session.isValid()) {
            return null;
        }
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                session = super.findSession(session.getIdInternal());
                if (session != null) {
                    session.access();
                    session.endAccess();
                }
            }
        }
        if (session != null) {
            return session;
        }
        session = this.swapIn(id);
        return session;
    }

    @Override
    public void removeSuper(Session session) {
        super.remove(session, false);
    }

    @Override
    public void load() {
        String[] ids;
        block11: {
            this.sessions.clear();
            if (this.store == null) {
                return;
            }
            ids = null;
            try {
                if (SecurityUtil.isPackageProtectionEnabled()) {
                    try {
                        ids = AccessController.doPrivileged(new PrivilegedStoreKeys());
                        break block11;
                    }
                    catch (PrivilegedActionException ex) {
                        Exception exception = ex.getException();
                        this.log.error("Exception in the Store during load: " + exception, exception);
                        return;
                    }
                }
                ids = this.store.keys();
            }
            catch (IOException e2) {
                this.log.error("Can't load sessions from store, " + e2.getMessage(), e2);
                return;
            }
        }
        int n2 = ids.length;
        if (n2 == 0) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("persistentManager.loading", String.valueOf(n2)));
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                this.swapIn(ids[i2]);
                continue;
            }
            catch (IOException e3) {
                this.log.error("Failed load session from store, " + e3.getMessage(), e3);
            }
        }
    }

    @Override
    public void remove(Session session, boolean update) {
        super.remove(session, update);
        if (this.store != null) {
            this.removeSession(session.getIdInternal());
        }
    }

    protected void removeSession(String id) {
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreRemove(id));
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    this.log.error("Exception in the Store during removeSession: " + exception, exception);
                }
            } else {
                this.store.remove(id);
            }
        }
        catch (IOException e2) {
            this.log.error("Exception removing session  " + e2.getMessage(), e2);
        }
    }

    @Override
    public void unload() {
        if (this.store == null) {
            return;
        }
        Session[] sessions = this.findSessions();
        int n2 = sessions.length;
        if (n2 == 0) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("persistentManager.unloading", String.valueOf(n2)));
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                this.swapOut(sessions[i2]);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getActiveSessionsFull() {
        int result = this.getActiveSessions();
        try {
            result += this.getStore().getSize();
        }
        catch (IOException ioe) {
            this.log.warn(sm.getString("persistentManager.storeSizeException"));
        }
        return result;
    }

    @Override
    public Set<String> getSessionIdsFull() {
        HashSet<String> sessionIds = new HashSet<String>();
        sessionIds.addAll(this.sessions.keySet());
        try {
            String[] storeKeys;
            for (String storeKey : storeKeys = this.getStore().keys()) {
                sessionIds.add(storeKey);
            }
        }
        catch (IOException e2) {
            this.log.warn(sm.getString("persistentManager.storeKeysException"));
        }
        return sessionIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session swapIn(String id) throws IOException {
        if (this.store == null) {
            return null;
        }
        Object swapInLock = null;
        PersistentManagerBase persistentManagerBase = this;
        synchronized (persistentManagerBase) {
            swapInLock = this.sessionSwapInLocks.get(id);
            if (swapInLock == null) {
                swapInLock = new Object();
                this.sessionSwapInLocks.put(id, swapInLock);
            }
        }
        Session session = null;
        Object object = swapInLock;
        synchronized (object) {
            session = (Session)this.sessions.get(id);
            if (session == null) {
                Session currentSwapInSession = this.sessionToSwapIn.get();
                try {
                    if (currentSwapInSession == null || !id.equals(currentSwapInSession.getId())) {
                        session = this.loadSessionFromStore(id);
                        this.sessionToSwapIn.set(session);
                        if (session != null && !session.isValid()) {
                            this.log.error(sm.getString("persistentManager.swapInInvalid", id));
                            session.expire();
                            this.removeSession(id);
                            session = null;
                        }
                        if (session != null) {
                            this.reactivateLoadedSession(id, session);
                        }
                    }
                }
                finally {
                    this.sessionToSwapIn.remove();
                }
            }
        }
        object = this;
        synchronized (object) {
            this.sessionSwapInLocks.remove(id);
        }
        return session;
    }

    private void reactivateLoadedSession(String id, Session session) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("persistentManager.swapIn", id));
        }
        session.setManager(this);
        ((DefaultSession)session).tellNew();
        this.add(session);
        ((DefaultSession)session).activate();
        session.access();
        session.endAccess();
    }

    private Session loadSessionFromStore(String id) throws IOException {
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                return this.securedStoreLoad(id);
            }
            return this.store.load(id);
        }
        catch (ClassNotFoundException e2) {
            String msg = sm.getString("persistentManager.deserializeError", id);
            this.log.error(msg, e2);
            throw new IllegalStateException(msg, e2);
        }
    }

    private Session securedStoreLoad(String id) throws IOException, ClassNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedStoreLoad(id));
        }
        catch (PrivilegedActionException ex) {
            Exception e2 = ex.getException();
            this.log.error(sm.getString("persistentManager.swapInException", id), e2);
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            if (e2 instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e2;
            }
            return null;
        }
    }

    protected void swapOut(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        ((DefaultSession)session).passivate();
        this.writeSession(session);
        super.remove(session, true);
        session.recycle();
    }

    protected void writeSession(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreSave(session));
                }
                catch (PrivilegedActionException ex) {
                    Exception exception = ex.getException();
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    this.log.error("Exception in the Store during writeSession: " + exception, exception);
                }
            } else {
                this.store.save(session);
            }
        }
        catch (IOException e2) {
            this.log.error(sm.getString("persistentManager.serializeError", session.getIdInternal(), e2));
            throw e2;
        }
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        if (this.store == null) {
            this.log.error("No Store configured, persistence disabled");
        } else if (this.store instanceof Lifecycle) {
            ((Lifecycle)((Object)this.store)).start();
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping");
        }
        this.setState(LifecycleState.STOPPING);
        if (this.getStore() != null && this.saveOnRestart) {
            this.unload();
        } else {
            Session[] sessions = this.findSessions();
            for (int i2 = 0; i2 < sessions.length; ++i2) {
                DefaultSession session = (DefaultSession)sessions[i2];
                if (!session.isValid()) continue;
                session.expire();
            }
        }
        if (this.getStore() instanceof Lifecycle) {
            ((Lifecycle)((Object)this.getStore())).stop();
        }
        super.stopInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxIdleSwaps() {
        if (!this.getState().isAvailable() || this.maxIdleSwap < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        if (this.maxIdleSwap >= 0) {
            for (int i2 = 0; i2 < sessions.length; ++i2) {
                DefaultSession session;
                DefaultSession defaultSession = session = (DefaultSession)sessions[i2];
                synchronized (defaultSession) {
                    if (!session.isValid()) {
                        continue;
                    }
                    int timeIdle = (int)(session.getIdleTimeInternal() / 1000L);
                    if (timeIdle >= this.maxIdleSwap && timeIdle >= this.minIdleSwap) {
                        if (session.accessCount != null && session.accessCount.get() > 0) {
                            continue;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(sm.getString("persistentManager.swapMaxIdle", session.getIdInternal(), timeIdle));
                        }
                        try {
                            this.swapOut(session);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxActiveSwaps() {
        if (!this.getState().isAvailable() || this.minIdleSwap < 0 || this.getMaxActiveSessions() < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        int limit = (int)((double)this.getMaxActiveSessions() * 0.9);
        if (limit >= sessions.length) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("persistentManager.tooManyActive", sessions.length));
        }
        int toswap = sessions.length - limit;
        for (int i2 = 0; i2 < sessions.length && toswap > 0; ++i2) {
            DefaultSession session;
            DefaultSession defaultSession = session = (DefaultSession)sessions[i2];
            synchronized (defaultSession) {
                int timeIdle = (int)(session.getIdleTimeInternal() / 1000L);
                if (timeIdle >= this.minIdleSwap) {
                    if (session.accessCount != null && session.accessCount.get() > 0) {
                        continue;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(sm.getString("persistentManager.swapTooManyActive", session.getIdInternal(), timeIdle));
                    }
                    try {
                        this.swapOut(session);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    --toswap;
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxIdleBackups() {
        if (!this.getState().isAvailable() || this.maxIdleBackup < 0) {
            return;
        }
        Session[] sessions = this.findSessions();
        if (this.maxIdleBackup >= 0) {
            for (int i2 = 0; i2 < sessions.length; ++i2) {
                DefaultSession session;
                DefaultSession defaultSession = session = (DefaultSession)sessions[i2];
                synchronized (defaultSession) {
                    if (!session.isValid()) {
                        continue;
                    }
                    long lastAccessedTime = session.getLastAccessedTimeInternal();
                    Long persistedLastAccessedTime = (Long)session.getNote(PERSISTED_LAST_ACCESSED_TIME);
                    if (persistedLastAccessedTime != null && lastAccessedTime == persistedLastAccessedTime) {
                        continue;
                    }
                    int timeIdle = (int)(session.getIdleTimeInternal() / 1000L);
                    if (timeIdle >= this.maxIdleBackup) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(sm.getString("persistentManager.backupMaxIdle", session.getIdInternal(), timeIdle));
                        }
                        try {
                            this.writeSession(session);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        session.setNote(PERSISTED_LAST_ACCESSED_TIME, lastAccessedTime);
                    }
                    continue;
                }
            }
        }
    }

    private class PrivilegedStoreKeys
    implements PrivilegedExceptionAction<String[]> {
        PrivilegedStoreKeys() {
        }

        @Override
        public String[] run() throws Exception {
            return PersistentManagerBase.this.store.keys();
        }
    }

    private class PrivilegedStoreSave
    implements PrivilegedExceptionAction<Void> {
        private Session session;

        PrivilegedStoreSave(Session session) {
            this.session = session;
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.save(this.session);
            return null;
        }
    }

    private class PrivilegedStoreLoad
    implements PrivilegedExceptionAction<Session> {
        private String id;

        PrivilegedStoreLoad(String id) {
            this.id = id;
        }

        @Override
        public Session run() throws Exception {
            return PersistentManagerBase.this.store.load(this.id);
        }
    }

    private class PrivilegedStoreRemove
    implements PrivilegedExceptionAction<Void> {
        private String id;

        PrivilegedStoreRemove(String id) {
            this.id = id;
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.remove(this.id);
            return null;
        }
    }

    private class PrivilegedStoreClear
    implements PrivilegedExceptionAction<Void> {
        PrivilegedStoreClear() {
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.clear();
            return null;
        }
    }
}

