/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.ssi;

import com.bes.enterprise.web.util.ExceptionUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ResponseIncludeWrapper
extends HttpServletResponseWrapper {
    private static final String LAST_MODIFIED = "last-modified";
    private static final DateFormat RFC1123_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    protected long lastModified = -1L;
    protected final ServletOutputStream captureServletOutputStream;
    protected ServletOutputStream servletOutputStream;
    protected PrintWriter printWriter;

    public ResponseIncludeWrapper(HttpServletResponse response, ServletOutputStream captureServletOutputStream) {
        super(response);
        this.captureServletOutputStream = captureServletOutputStream;
    }

    public void flushOutputStreamOrWriter() throws IOException {
        if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        }
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.servletOutputStream == null) {
            if (this.printWriter == null) {
                this.setCharacterEncoding(this.getCharacterEncoding());
                this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.captureServletOutputStream, this.getCharacterEncoding()));
            }
            return this.printWriter;
        }
        throw new IllegalStateException();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter == null) {
            if (this.servletOutputStream == null) {
                this.servletOutputStream = this.captureServletOutputStream;
            }
            return this.servletOutputStream;
        }
        throw new IllegalStateException();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void addDateHeader(String name, long value) {
        super.addDateHeader(name, value);
        String lname = name.toLowerCase(Locale.ENGLISH);
        if (lname.equals(LAST_MODIFIED)) {
            this.lastModified = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        String lname = name.toLowerCase(Locale.ENGLISH);
        if (lname.equals(LAST_MODIFIED)) {
            try {
                DateFormat dateFormat = RFC1123_FORMAT;
                synchronized (dateFormat) {
                    this.lastModified = RFC1123_FORMAT.parse(value).getTime();
                }
            }
            catch (Throwable ignore) {
                ExceptionUtils.handleThrowable(ignore);
            }
        }
    }

    @Override
    public void setDateHeader(String name, long value) {
        super.setDateHeader(name, value);
        String lname = name.toLowerCase(Locale.ENGLISH);
        if (lname.equals(LAST_MODIFIED)) {
            this.lastModified = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        String lname = name.toLowerCase(Locale.ENGLISH);
        if (lname.equals(LAST_MODIFIED)) {
            try {
                DateFormat dateFormat = RFC1123_FORMAT;
                synchronized (dateFormat) {
                    this.lastModified = RFC1123_FORMAT.parse(value).getTime();
                }
            }
            catch (Throwable ignore) {
                ExceptionUtils.handleThrowable(ignore);
            }
        }
    }

    static {
        RFC1123_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

