/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.ssi;

import com.bes.enterprise.webtier.ssi.SSICommand;
import com.bes.enterprise.webtier.ssi.SSIMediator;
import java.io.IOException;
import java.io.PrintWriter;

public final class SSIInclude
implements SSICommand {
    @Override
    public long process(SSIMediator ssiMediator, String commandName, String[] paramNames, String[] paramValues, PrintWriter writer) {
        long lastModified = 0L;
        String configErrMsg = ssiMediator.getConfigErrMsg();
        for (int i2 = 0; i2 < paramNames.length; ++i2) {
            String paramName = paramNames[i2];
            String paramValue = paramValues[i2];
            String substitutedValue = ssiMediator.substituteVariables(paramValue);
            try {
                if (paramName.equalsIgnoreCase("file") || paramName.equalsIgnoreCase("virtual")) {
                    boolean virtual = paramName.equalsIgnoreCase("virtual");
                    lastModified = ssiMediator.getFileLastModified(substitutedValue, virtual);
                    String text = ssiMediator.getFileText(substitutedValue, virtual);
                    writer.write(text);
                    continue;
                }
                ssiMediator.log("#include--Invalid attribute: " + paramName);
                writer.write(configErrMsg);
                continue;
            }
            catch (IOException e2) {
                ssiMediator.log("#include--Couldn't include file: " + substitutedValue, e2);
                writer.write(configErrMsg);
            }
        }
        return lastModified;
    }
}

