/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.ssi;

import com.bes.enterprise.webtier.ssi.SSICommand;
import com.bes.enterprise.webtier.ssi.SSIMediator;
import com.bes.enterprise.webtier.ssi.SSIStopProcessingException;
import java.io.PrintWriter;

public class SSISet
implements SSICommand {
    @Override
    public long process(SSIMediator ssiMediator, String commandName, String[] paramNames, String[] paramValues, PrintWriter writer) throws SSIStopProcessingException {
        long lastModified = 0L;
        String errorMessage = ssiMediator.getConfigErrMsg();
        String variableName = null;
        for (int i2 = 0; i2 < paramNames.length; ++i2) {
            String paramName = paramNames[i2];
            String paramValue = paramValues[i2];
            if (paramName.equalsIgnoreCase("var")) {
                variableName = paramValue;
                continue;
            }
            if (paramName.equalsIgnoreCase("value")) {
                if (variableName != null) {
                    String substitutedValue = ssiMediator.substituteVariables(paramValue);
                    ssiMediator.setVariableValue(variableName, substitutedValue);
                    lastModified = System.currentTimeMillis();
                    continue;
                }
                ssiMediator.log("#set--no variable specified");
                writer.write(errorMessage);
                throw new SSIStopProcessingException();
            }
            ssiMediator.log("#set--Invalid attribute: " + paramName);
            writer.write(errorMessage);
            throw new SSIStopProcessingException();
        }
        return lastModified;
    }
}

