/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.startup;

import com.bes.appserv.lic.Auth;
import com.bes.appserv.lic.LicData;
import com.bes.appserv.lic.LicenseHelper;
import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.webtier.security.SecurityClassLoad;
import com.bes.enterprise.webtier.startup.ClassLoaderFactory;
import com.bes.enterprise.webtier.startup.HeavenProperties;
import com.bes.patch.PatchUtils;
import com.bes.patch.api.Constants;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ASMain {
    private static final Log log;
    private static ASMain daemon;
    private static final File besBaseFile;
    private static final File besHomeFile;
    private static final Pattern PATH_PATTERN;
    private static List<File> prefixFiles;
    private static List<File> suffixFiles;
    private static List<File> sharedLoaderSuffixFiles;
    private Object heavenDaemon = null;
    ClassLoader commonLoader = null;
    ClassLoader heavenLoader = null;
    ClassLoader sharedLoader = null;
    ClassLoader bcsLoader = null;

    private void initClassLoaders() {
        try {
            this.commonLoader = this.createClassLoader("common", null);
            if (this.commonLoader == null) {
                this.commonLoader = this.getClass().getClassLoader();
            }
            this.heavenLoader = this.createClassLoader("server", this.commonLoader);
            this.sharedLoader = this.createClassLoader("shared", this.commonLoader);
            this.bcsLoader = this.createClassLoader("bcs", this.commonLoader);
        }
        catch (Throwable t2) {
            ASMain.handleThrowable(t2);
            log.error("Class loader creation threw exception", t2);
            System.exit(1);
        }
    }

    private ClassLoader createClassLoader(String name, ClassLoader parent) throws Exception {
        String[] repositoryPaths;
        String value = HeavenProperties.getProperty(name + ".loader");
        if (value == null || value.equals("")) {
            return parent;
        }
        value = this.replace(value);
        ArrayList<ClassLoaderFactory.Repository> repositories = new ArrayList<ClassLoaderFactory.Repository>();
        for (String string : repositoryPaths = ASMain.getPaths(value)) {
            try {
                URL url = new URL(string);
                repositories.add(new ClassLoaderFactory.Repository(string, ClassLoaderFactory.RepositoryType.URL));
            }
            catch (MalformedURLException url) {
                if (string.endsWith("*.jar")) {
                    String string2 = string.substring(0, string.length() - "*.jar".length());
                    repositories.add(new ClassLoaderFactory.Repository(string2, ClassLoaderFactory.RepositoryType.GLOB));
                    continue;
                }
                if (string.endsWith(".jar")) {
                    repositories.add(new ClassLoaderFactory.Repository(string, ClassLoaderFactory.RepositoryType.JAR));
                    continue;
                }
                repositories.add(new ClassLoaderFactory.Repository(string, ClassLoaderFactory.RepositoryType.DIR));
            }
        }
        if ("common".equals(name)) {
            List<ClassLoaderFactory.Repository> prefixRepos = this.getReposByClasspath(prefixFiles);
            repositories.addAll(0, prefixRepos);
            ArrayList<ClassLoaderFactory.Repository> patchRepos = new ArrayList<ClassLoaderFactory.Repository>();
            ArrayList commonLoaderPatchFiles = new ArrayList();
            commonLoaderPatchFiles.addAll(PatchUtils.getNonLevelPatchFiles((String)Constants.PATCH_PREFIX));
            for (File patchFile : commonLoaderPatchFiles) {
                ClassLoaderFactory.Repository patchRepo = new ClassLoaderFactory.Repository(patchFile.getCanonicalPath(), ClassLoaderFactory.RepositoryType.JAR);
                patchRepos.add(patchRepo);
            }
            repositories.addAll(0, patchRepos);
            List<ClassLoaderFactory.Repository> list = this.getReposByClasspath(suffixFiles);
            repositories.addAll(list);
            return ClassLoaderFactory.createCommonClassLoader(repositories, parent);
        }
        if ("shared".equals(name)) {
            List<ClassLoaderFactory.Repository> suffixRepos = this.getReposByClasspath(sharedLoaderSuffixFiles);
            repositories.addAll(suffixRepos);
            return ClassLoaderFactory.createSharedClassLoader(repositories, parent);
        }
        return ClassLoaderFactory.createClassLoader(repositories, parent);
    }

    private List<ClassLoaderFactory.Repository> getReposByClasspath(List<File> classpaths) throws IOException {
        ArrayList<ClassLoaderFactory.Repository> repositories = new ArrayList<ClassLoaderFactory.Repository>();
        ArrayList<File> cloneClasspaths = new ArrayList<File>();
        cloneClasspaths.addAll(classpaths);
        for (File file : cloneClasspaths) {
            String path = file.getCanonicalPath();
            if (path.endsWith("*.jar")) {
                path = path.substring(0, path.length() - "*.jar".length());
                repositories.add(new ClassLoaderFactory.Repository(path, ClassLoaderFactory.RepositoryType.GLOB));
                continue;
            }
            if (path.endsWith(".jar")) {
                repositories.add(new ClassLoaderFactory.Repository(path, ClassLoaderFactory.RepositoryType.JAR));
                continue;
            }
            repositories.add(new ClassLoaderFactory.Repository(path, ClassLoaderFactory.RepositoryType.DIR));
        }
        return repositories;
    }

    protected String replace(String str) {
        String result = str;
        int pos_start = str.indexOf("${");
        if (pos_start >= 0) {
            StringBuilder builder = new StringBuilder();
            int pos_end = -1;
            while (pos_start >= 0) {
                builder.append(str, pos_end + 1, pos_start);
                pos_end = str.indexOf(125, pos_start + 2);
                if (pos_end < 0) {
                    pos_end = pos_start - 1;
                    break;
                }
                String propName = str.substring(pos_start + 2, pos_end);
                String replacement = propName.length() == 0 ? null : ("bes.home".equals(propName) ? ASMain.getHeavenHome() : ("bes.base".equals(propName) ? ASMain.getHeavenBase() : System.getProperty(propName)));
                if (replacement != null) {
                    builder.append(replacement);
                } else {
                    builder.append(str, pos_start, pos_end + 1);
                }
                pos_start = str.indexOf("${", pos_end + 1);
            }
            builder.append(str, pos_end + 1, str.length());
            result = builder.toString();
        }
        return result;
    }

    public void init() throws Exception {
        this.initClassLoaders();
        Thread.currentThread().setContextClassLoader(this.heavenLoader);
        SecurityClassLoad.securityClassLoad(this.heavenLoader);
        if (log.isDebugEnabled()) {
            log.debug("Loading startup class");
        }
        Class<?> startupClass = this.heavenLoader.loadClass("com.bes.enterprise.server.builder.BesWebModule");
        Object startupInstance = startupClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        if (log.isDebugEnabled()) {
            log.debug("Setting startup class properties");
        }
        String methodName = "setParentClassLoader";
        Class[] paramTypes = new Class[]{Class.forName("java.lang.ClassLoader")};
        Object[] paramValues = new Object[]{this.sharedLoader};
        Method method = startupInstance.getClass().getMethod(methodName, paramTypes);
        method.invoke(startupInstance, paramValues);
        methodName = "setBcsClassLoader";
        paramTypes[0] = Class.forName("java.lang.ClassLoader");
        paramValues[0] = this.bcsLoader;
        method = startupInstance.getClass().getMethod(methodName, paramTypes);
        method.invoke(startupInstance, paramValues);
        this.heavenDaemon = startupInstance;
    }

    private void load(String[] arguments) throws Exception {
        Object[] param;
        Class[] paramTypes;
        String methodName = "load";
        if (arguments == null || arguments.length == 0) {
            paramTypes = null;
            param = null;
        } else {
            paramTypes = new Class[]{arguments.getClass()};
            param = new Object[]{arguments};
        }
        Method method = this.heavenDaemon.getClass().getMethod(methodName, paramTypes);
        if (log.isDebugEnabled()) {
            log.debug("Calling startup class " + method);
        }
        method.invoke(this.heavenDaemon, param);
    }

    private Object getServer() throws Exception {
        String methodName = "getServer";
        Method method = this.heavenDaemon.getClass().getMethod(methodName, new Class[0]);
        return method.invoke(this.heavenDaemon, new Object[0]);
    }

    public void init(String[] arguments) throws Exception {
        this.init();
        this.load(arguments);
    }

    public void start() throws Exception {
        if (this.heavenDaemon == null) {
            this.init();
        }
        Method method = this.heavenDaemon.getClass().getMethod("start", null);
        method.invoke(this.heavenDaemon, (Object[])null);
    }

    public void stop() throws Exception {
        Method method = this.heavenDaemon.getClass().getMethod("stop", null);
        method.invoke(this.heavenDaemon, (Object[])null);
    }

    public void stopServer() throws Exception {
        Method method = this.heavenDaemon.getClass().getMethod("stopServer", null);
        method.invoke(this.heavenDaemon, (Object[])null);
    }

    public void stopServer(String[] arguments) throws Exception {
        Object[] param;
        Class[] paramTypes;
        if (arguments == null || arguments.length == 0) {
            paramTypes = null;
            param = null;
        } else {
            paramTypes = new Class[]{arguments.getClass()};
            param = new Object[]{arguments};
        }
        Method method = this.heavenDaemon.getClass().getMethod("stopServer", paramTypes);
        method.invoke(this.heavenDaemon, param);
    }

    public void setAwait(boolean await) throws Exception {
        Class[] paramTypes = new Class[]{Boolean.TYPE};
        Object[] paramValues = new Object[]{await};
        Method method = this.heavenDaemon.getClass().getMethod("setAwait", paramTypes);
        method.invoke(this.heavenDaemon, paramValues);
    }

    public boolean getAwait() throws Exception {
        Class[] paramTypes = new Class[]{};
        Object[] paramValues = new Object[]{};
        Method method = this.heavenDaemon.getClass().getMethod("getAwait", paramTypes);
        Boolean b2 = (Boolean)method.invoke(this.heavenDaemon, paramValues);
        return b2;
    }

    public void destroy() {
    }

    public static void main(String[] args) {
        String besHome = besHomeFile.getAbsolutePath();
        try {
            Auth.check(besHome, "WEB", "Lite");
        }
        catch (Exception ex) {
            log.error("Error occurred when checking license :" + ex.getMessage());
            System.exit(1);
        }
        try {
            if (log.isInfoEnabled()) {
                ASMain.showLicInfo();
                long remainingDays = Auth.queryExpiry(besHome);
                long expirtionReminderDays = Auth.getShowMsgexpiryDays();
                if (remainingDays <= expirtionReminderDays && remainingDays != -1L) {
                    log.info("BES will expire in " + remainingDays + " days.");
                }
            }
        }
        catch (Exception ex) {
            log.warn(ex.getMessage());
        }
        if (daemon == null) {
            ASMain bootstrap = new ASMain();
            try {
                bootstrap.init();
            }
            catch (Throwable t2) {
                ASMain.handleThrowable(t2);
                t2.printStackTrace();
                return;
            }
            daemon = bootstrap;
        } else {
            Thread.currentThread().setContextClassLoader(ASMain.daemon.heavenLoader);
        }
        try {
            String command = "start";
            if (args.length > 0) {
                command = args[args.length - 1];
            }
            if (command.equals("startd")) {
                args[args.length - 1] = "start";
                daemon.load(args);
                daemon.start();
            } else if (command.equals("stopd")) {
                args[args.length - 1] = "stop";
                daemon.stop();
            } else if (command.equals("start")) {
                daemon.setAwait(true);
                daemon.load(args);
                daemon.start();
            } else if (command.equals("stop")) {
                daemon.stopServer(args);
            } else if (command.equals("configtest")) {
                daemon.load(args);
                if (null == daemon.getServer()) {
                    System.exit(1);
                }
                System.exit(0);
            } else {
                log.warn("ASMain: command \"" + command + "\" does not exist.");
            }
        }
        catch (Throwable t3) {
            if (t3 instanceof InvocationTargetException && t3.getCause() != null) {
                t3 = t3.getCause();
            }
            ASMain.handleThrowable(t3);
            t3.printStackTrace();
            System.exit(1);
        }
    }

    private static void showLicInfo() throws Exception {
        LicData licData = LicenseHelper.readLicData();
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder licInfo = new StringBuilder();
        licInfo.append("Server information :").append(lineSeparator);
        licInfo.append("----------------------------------------------------------------");
        licInfo.append(lineSeparator);
        licInfo.append("Copyright (c) 2018-2022 Beijing Baolande Software Corporation. All Rights Reserved.");
        licInfo.append(lineSeparator);
        licInfo.append(lineSeparator);
        licInfo.append("License information :").append(lineSeparator);
        licInfo.append("   ").append("Custom  Name : ").append(licData.getCustomerName());
        licInfo.append(lineSeparator);
        licInfo.append("   ").append("Project Name : ").append(licData.getProjectName());
        licInfo.append(lineSeparator);
        licInfo.append("   ").append("License Type : ").append(licData.getRegisterType());
        licInfo.append(lineSeparator);
        licInfo.append("   ").append("Expiry  Date : ").append(licData.getExpiryDate());
        licInfo.append(lineSeparator);
        licInfo.append("----------------------------------------------------------------");
        log.info(licInfo.toString());
    }

    public static String getHeavenHome() {
        return besHomeFile.getPath();
    }

    public static String getHeavenBase() {
        return besBaseFile.getPath();
    }

    public static File getHeavenHomeFile() {
        return besHomeFile;
    }

    public static File getHeavenBaseFile() {
        return besBaseFile;
    }

    private static void handleThrowable(Throwable t2) {
        if (t2 instanceof ThreadDeath) {
            throw (ThreadDeath)t2;
        }
        if (t2 instanceof VirtualMachineError) {
            throw (VirtualMachineError)t2;
        }
    }

    public static String[] getPaths(String value) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = PATH_PATTERN.matcher(value);
        while (matcher.find()) {
            String path = value.substring(matcher.start(), matcher.end());
            if ((path = path.trim()).length() == 0) continue;
            char first = path.charAt(0);
            char last = path.charAt(path.length() - 1);
            if (first == '\"' && last == '\"' && path.length() > 1) {
                path = path.substring(1, path.length() - 1);
                if ((path = path.trim()).length() == 0) {
                    continue;
                }
            } else if (path.contains("\"")) {
                throw new IllegalArgumentException("The double quote [\"] character only be used to quote paths. It must not appear in a path. This loader path is not valid: [" + value + "]");
            }
            result.add(path);
        }
        return result.toArray(new String[result.size()]);
    }

    private static List<File> convertLibrarysToFiles(String librarys) {
        ArrayList<File> files = new ArrayList<File>();
        if (StringUtils.ok((String)librarys)) {
            String[] paths;
            for (String path : paths = ASMain.getPaths(librarys)) {
                File file = new File(path);
                if (file.isAbsolute()) {
                    files.add(file);
                    continue;
                }
                files.add(new File(besBaseFile, path));
            }
        }
        return files;
    }

    static {
        File bootstrapJar;
        File f2;
        log = LogFactory.getLog(ASMain.class);
        daemon = null;
        PATH_PATTERN = Pattern.compile("(\".*?\")|(([^,])*)");
        String userDir = System.getProperty("user.dir");
        String home = System.getProperty("bes.home");
        File homeFile = null;
        if (home != null) {
            f2 = new File(home);
            try {
                homeFile = f2.getCanonicalFile();
            }
            catch (IOException ioe) {
                homeFile = f2.getAbsoluteFile();
            }
        }
        if (homeFile == null && (bootstrapJar = new File(userDir, "bootstrap.jar")).exists()) {
            File f3 = new File(userDir, "..");
            try {
                homeFile = f3.getCanonicalFile();
            }
            catch (IOException ioe) {
                homeFile = f3.getAbsoluteFile();
            }
        }
        if (homeFile == null) {
            f2 = new File(userDir);
            try {
                homeFile = f2.getCanonicalFile();
            }
            catch (IOException ioe) {
                homeFile = f2.getAbsoluteFile();
            }
        }
        besHomeFile = homeFile;
        System.setProperty("bes.home", besHomeFile.getPath());
        String base = System.getProperty("bes.base");
        if (base == null) {
            besBaseFile = besHomeFile;
        } else {
            File baseFile = new File(base);
            try {
                baseFile = baseFile.getCanonicalFile();
            }
            catch (IOException ioe) {
                baseFile = baseFile.getAbsoluteFile();
            }
            besBaseFile = baseFile;
        }
        System.setProperty("bes.base", besBaseFile.getPath());
        prefixFiles = ASMain.convertLibrarysToFiles(System.getProperty("com.bes.classpath.prefix"));
        suffixFiles = ASMain.convertLibrarysToFiles(System.getProperty("com.bes.classpath.suffix"));
        sharedLoaderSuffixFiles = ASMain.convertLibrarysToFiles(System.getProperty("com.bes.shared.loader.suffix"));
    }
}

