/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.startup;

import com.bes.enterprise.appserver.common.security.RoleMapper;
import com.bes.enterprise.appserver.common.security.RoleMapperFactory;
import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.context.ContextHolder;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.naming.GlobalResourceLink;
import com.bes.enterprise.web.JarScanFilter;
import com.bes.enterprise.web.JarScanner;
import com.bes.enterprise.web.util.BeanInspectUtils;
import com.bes.enterprise.web.util.IntrospectionUtils;
import com.bes.enterprise.web.util.buf.UriUtil;
import com.bes.enterprise.web.util.descriptor.LocalResolver;
import com.bes.enterprise.web.util.descriptor.XmlErrorHandler;
import com.bes.enterprise.web.util.descriptor.besweb.BesWebRuleSet;
import com.bes.enterprise.web.util.descriptor.besweb.BesWebXml;
import com.bes.enterprise.web.util.descriptor.besweb.Property;
import com.bes.enterprise.web.util.descriptor.besweb.RuntimeResourceEnvRef;
import com.bes.enterprise.web.util.descriptor.besweb.RuntimeResourceRef;
import com.bes.enterprise.web.util.descriptor.besweb.SecurityRoleMapping;
import com.bes.enterprise.web.util.digester.Digester;
import com.bes.enterprise.web.util.http.CookieProcessor;
import com.bes.enterprise.web.util.http.Rfc6265CookieProcessor;
import com.bes.enterprise.web.util.scan.StandardJarScanFilter;
import com.bes.enterprise.web.util.scan.StandardJarScanner;
import com.bes.enterprise.webtier.LifecycleListener;
import com.bes.enterprise.webtier.Loader;
import com.bes.enterprise.webtier.Manager;
import com.bes.enterprise.webtier.SessionIdGenerator;
import com.bes.enterprise.webtier.Store;
import com.bes.enterprise.webtier.WebResourceRoot;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.deploy.NamingResourcesImpl;
import com.bes.enterprise.webtier.session.PersistentManager;
import com.bes.enterprise.webtier.startup.ContextConfig;
import com.bes.enterprise.webtier.util.DeploymentContextUtils;
import com.bes.enterprise.webtier.webresources.StandardRoot;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class BESContextConfig
extends ContextConfig {
    private BesWebXml besWebXml;
    private static final Log log = LogFactory.getLog(ContextConfig.class);
    public static final Map<String, String> BES_WEB_PUBLIC_IDS;
    public static final Map<String, String> BES_WEB_SYSTEM_IDS;
    public static final String PROPERTY_SEPARATE = ".";
    private static final int OBJECT_MAX_SIZE_FACTOR;

    private static void add(Map<String, String> ids, String id, String location) {
        if (location != null) {
            ids.put(id, location);
        }
    }

    private static String locationFor(String name) {
        URL location = BesWebXml.class.getResource(name);
        return location.toExternalForm();
    }

    @Override
    protected Digester createContextDigester() {
        Digester digester = new Digester();
        digester.setValidating(this.context.getXmlValidation());
        digester.setNamespaceAware(this.context.getXmlNamespaceAware());
        LocalResolver resolver = new LocalResolver(BES_WEB_PUBLIC_IDS, BES_WEB_SYSTEM_IDS, this.context.getXmlBlockExternal());
        digester.setEntityResolver(resolver);
        HashMap fakeAttributes = new HashMap();
        ArrayList<String> attrs = new ArrayList<String>();
        attrs.add("class-name");
        fakeAttributes.put(Object.class, attrs);
        digester.setFakeAttributes(fakeAttributes);
        BesWebRuleSet contextRuleSet = new BesWebRuleSet("");
        digester.addRuleSet(contextRuleSet);
        return digester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processContextConfig(Digester digester, URL contextXml) {
        if (log.isDebugEnabled()) {
            log.debug("Processing context [" + this.context.getName() + "] configuration file [" + contextXml + "]");
        }
        BesWebXml besWebXml = new BesWebXml();
        InputSource source = null;
        InputStream stream = null;
        try {
            source = new InputSource(contextXml.toString());
            URLConnection xmlConn = contextXml.openConnection();
            xmlConn.setUseCaches(false);
            stream = xmlConn.getInputStream();
        }
        catch (Exception e2) {
            log.error(sm.getString("contextConfig.contextMissing", contextXml), e2);
        }
        if (source == null) {
            return;
        }
        try {
            source.setByteStream(stream);
            digester.setClassLoader(this.getClass().getClassLoader());
            digester.setUseContextClassLoader(false);
            digester.push(besWebXml);
            XmlErrorHandler errorHandler = new XmlErrorHandler();
            digester.setErrorHandler(errorHandler);
            digester.parse(source);
            if (errorHandler.getWarnings().size() > 0 || errorHandler.getErrors().size() > 0) {
                errorHandler.logFindings(log, contextXml.toString());
                this.ok = false;
            }
            if (log.isDebugEnabled()) {
                log.debug("Successfully processed context [" + this.context.getName() + "] configuration file [" + contextXml + "]");
            }
        }
        catch (SAXParseException e3) {
            log.error(sm.getString("contextConfig.contextParse", this.context.getName()), e3);
            log.error(sm.getString("contextConfig.defaultPosition", "" + e3.getLineNumber(), "" + e3.getColumnNumber()));
            this.ok = false;
        }
        catch (Exception e4) {
            log.error(sm.getString("contextConfig.contextParse", this.context.getName()), e4);
            this.ok = false;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e5) {
                log.error(sm.getString("contextConfig.contextClose"), e5);
            }
        }
        this.effectBesWebXml(besWebXml);
        this.besWebXml = besWebXml;
    }

    public void effectBesWebXml(BesWebXml besWebXml) {
        GlobalResourceLink runtimeResourceLink;
        NamingResourcesImpl namingResources;
        Loader loader = besWebXml.getLoader();
        if (loader != null) {
            this.context.setLoader(loader);
        }
        if (besWebXml.getContextRoot() != null) {
            this.context.setPath(besWebXml.getContextRoot());
        }
        for (LifecycleListener lifecycleListener : besWebXml.lifecycleListeners) {
            this.context.addLifecycleListener(lifecycleListener);
        }
        for (String string : besWebXml.wrapperListeners) {
            this.context.addWrapperListener(string);
        }
        for (String string : besWebXml.wrapperLifecycles) {
            this.context.addWrapperLifecycle(string);
        }
        for (String string : besWebXml.watchedResources) {
            this.context.addWatchedResource(string);
        }
        if (besWebXml.getResources() != null) {
            this.context.setResources(besWebXml.getResources());
        }
        if (besWebXml.getResourceRefs() != null) {
            namingResources = this.context.getNamingResources();
            for (RuntimeResourceRef runtimeResourceRef : besWebXml.getResourceRefs()) {
                runtimeResourceLink = new GlobalResourceLink();
                runtimeResourceLink.setRefName(runtimeResourceRef.getResRefName());
                runtimeResourceLink.setJndiName(runtimeResourceRef.getJndiName());
                namingResources.addRuntimeResourceLink(runtimeResourceLink);
            }
        }
        if (besWebXml.getResourceEnvRefs() != null) {
            namingResources = this.context.getNamingResources();
            for (RuntimeResourceEnvRef runtimeResourceEnvRef : besWebXml.getResourceEnvRefs()) {
                runtimeResourceLink = new GlobalResourceLink();
                runtimeResourceLink.setRefName(runtimeResourceEnvRef.getResourceEnvRefName());
                runtimeResourceLink.setJndiName(runtimeResourceEnvRef.getJndiName());
                namingResources.addRuntimeResourceLink(runtimeResourceLink);
            }
        }
        if (besWebXml.getJarScanner() != null) {
            this.context.setJarScanner(besWebXml.getJarScanner());
        }
        if (besWebXml.getProperties().size() > 0) {
            for (Property property : besWebXml.getProperties()) {
                BeanInspectUtils.transmitProperty(this.context, property.getName(), property.getValue());
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.configSessionManager();
        this.configureSecurityRoleMappings();
        this.configCookieProcessor();
        this.configureResources();
        this.configJarScanner();
        this.configJspConfigure();
        this.configDeployContext();
    }

    @Override
    protected void contextConfig(Digester digester) {
        block20: {
            if (this.context.getConfigFile() != null) {
                super.contextConfig(digester);
                return;
            }
            try {
                File docBase = new File(this.context.getDocBase());
                File besWebXmlFile = new File(docBase, "WEB-INF/bes-web.xml");
                if (docBase.isDirectory() && besWebXmlFile.exists()) {
                    this.context.setConfigFile(besWebXmlFile.toURI().toURL());
                    break block20;
                }
                if (!docBase.isFile()) break block20;
                boolean xmlInWar = false;
                try (JarFile jar = new JarFile(this.context.getDocBase());){
                    JarEntry entry = jar.getJarEntry("WEB-INF/bes-web.xml");
                    if (entry != null) {
                        xmlInWar = true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (xmlInWar) {
                    this.context.setConfigFile(UriUtil.buildJarUrl(docBase, "WEB-INF/bes-web.xml"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.contextConfig(digester);
    }

    private void configDeployContext() {
        DomTemplate hotDeployConfig;
        if (this.context != null && this.context instanceof DefaultContext && (hotDeployConfig = DeploymentContextUtils.getHotDeployConfig()) != null && DeploymentContextUtils.getWebModule(this.context.getName()) == null) {
            ((DefaultContext)this.context).setDelegate(Boolean.parseBoolean(hotDeployConfig.getAttribute("delegate")));
        }
    }

    @Override
    protected void webConfig() {
        super.webConfig();
        boolean foundMaxInactiveInterval = false;
        boolean foundReapInterval = false;
        if (this.besWebXml != null && this.besWebXml.getManagerProperties().size() > 0) {
            for (Property property : this.besWebXml.getManagerProperties()) {
                if ("maxInactiveInterval".equals(property.getName()) && !StringUtils.isBlank((String)property.getValue())) {
                    this.context.setSessionTimeout(Integer.parseInt(property.getValue()));
                    foundMaxInactiveInterval = true;
                }
                if ("reapInterval".equals(property.getName()) && !StringUtils.isBlank((String)property.getValue())) {
                    this.context.setBackgroundProcessorDelay(Integer.parseInt(property.getValue()));
                    foundReapInterval = true;
                }
                if (!foundMaxInactiveInterval || !foundReapInterval) continue;
                break;
            }
        }
    }

    private void configJspConfigure() {
        if (this.besWebXml != null && this.context instanceof DefaultContext) {
            List<Property> jspConfigProperties = this.besWebXml.getJspConfigProperties();
            for (Property property : jspConfigProperties) {
                if (!"encoding".equals(property.getName())) continue;
                ((DefaultContext)this.context).setBesWebJspPageEncoding(property.getValue());
                break;
            }
        }
    }

    private void configureSecurityRoleMappings() {
        if (this.besWebXml == null || this.besWebXml.getSecurityRoleMappings() == null) {
            return;
        }
        List<SecurityRoleMapping> securityRoleMappings = this.besWebXml.getSecurityRoleMappings();
        RoleMapper roleMapper = RoleMapperFactory.getInstance().getRoleMapper(this.context.getName());
        for (SecurityRoleMapping securityRoleMapping : securityRoleMappings) {
            String roleName = securityRoleMapping.getRoleName();
            List<String> principalNames = securityRoleMapping.getPrincipalNames();
            HashSet<String> principals = new HashSet<String>(principalNames);
            roleMapper.addPrincipals(roleName, principals);
            List<String> groupNames = securityRoleMapping.getGroupNames();
            HashSet<String> groups = new HashSet<String>(groupNames);
            roleMapper.addGroups(roleName, groups);
        }
    }

    private void configCookieProcessor() {
        DomTemplate cookieProcessorBean = this.getCookieProcessorBean();
        CookieProcessor cookieProcessor = this.createCookieProcessor(cookieProcessorBean);
        this.context.setCookieProcessor(cookieProcessor);
    }

    private void configureResources() {
        WebResourceRoot webResourceRoot = new StandardRoot();
        if (this.besWebXml != null && this.besWebXml.getResources() != null) {
            webResourceRoot = this.besWebXml.getResources();
        } else {
            DomTemplate serverBean = ContextHolder.currentContext().getConfigBean();
            DomTemplate httpFile = serverBean.getElement("web-container").getElement("http-service").getElement("http-file");
            webResourceRoot.setAllowLinking(Boolean.parseBoolean(httpFile.getAttribute("allow-linking")));
            webResourceRoot.setCacheMaxSize(Long.parseLong(httpFile.getAttribute("cache-max-size")));
            webResourceRoot.setCacheTtl(Long.parseLong(httpFile.getAttribute("cache-ttl")));
            webResourceRoot.setCachingAllowed(Boolean.parseBoolean(httpFile.getAttribute("caching-allowed")));
            webResourceRoot.setCacheObjectMaxSize((int)(Long.parseLong(httpFile.getAttribute("cache-max-size")) / (long)OBJECT_MAX_SIZE_FACTOR));
        }
        this.context.setResources(webResourceRoot);
    }

    private void configJarScanner() {
        JarScanner jarScanner = new StandardJarScanner();
        JarScanFilter jarScanFilter = new StandardJarScanFilter();
        DomTemplate serverBean = ContextHolder.currentContext().getConfigBean();
        DomTemplate jarScannerConfig = serverBean.getElement("web-container").getElement("http-service").getElement("jar-scanner");
        DomTemplate jarScanFilterConfig = null;
        if (this.besWebXml != null && this.besWebXml.getJarScanner() != null) {
            jarScanner = this.besWebXml.getJarScanner();
        } else if (jarScannerConfig != null) {
            jarScanner = (JarScanner)this.createJarScannerOrFilter(jarScannerConfig);
        }
        if (this.besWebXml != null && this.besWebXml.getJarScanner() != null && this.besWebXml.getJarScanner().getJarScanFilter() != null) {
            jarScanFilter = this.besWebXml.getJarScanner().getJarScanFilter();
        } else if (jarScannerConfig != null && jarScannerConfig.getElement("jar-scan-filter") != null) {
            jarScanFilterConfig = jarScannerConfig.getElement("jar-scan-filter");
            jarScanFilter = (JarScanFilter)this.createJarScannerOrFilter(jarScanFilterConfig);
        }
        jarScanner.setJarScanFilter(jarScanFilter);
        this.context.setJarScanner(jarScanner);
    }

    private Object createJarScannerOrFilter(DomTemplate config) {
        String className = config.getAttribute("class-name");
        Object object = null;
        if (className != null && !className.equals("")) {
            try {
                object = Class.forName(className).newInstance();
                BeanInspectUtils.transmitProperties(object, config);
                BeanInspectUtils.transmitProperties(object, config.getElements("property"));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e2) {
                throw new RuntimeException(e2);
            }
        }
        return object;
    }

    private DomTemplate getCookieProcessorBean() {
        DomTemplate serverBean = ContextHolder.currentContext().getConfigBean();
        DomTemplate sessionConfig = serverBean.getElement("web-container").getElement("session-config");
        return sessionConfig == null ? null : sessionConfig.getElement("cookie-processor");
    }

    private CookieProcessor createCookieProcessor(DomTemplate cookieProcessorBean) {
        HashMap<String, String> cookieAttributes = new HashMap<String, String>();
        CookieProcessor cookieProcessor = null;
        String cookieProcessorClassName = null;
        if (this.besWebXml != null && this.besWebXml.getCookieProperties().size() > 0) {
            for (Property cookieProperty : this.besWebXml.getCookieProperties()) {
                cookieAttributes.put(cookieProperty.getName(), cookieProperty.getValue() == null ? "" : cookieProperty.getValue());
                if (!"className".equals(cookieProperty.getName())) continue;
                cookieProcessorClassName = cookieProperty.getName();
            }
        }
        if (StringUtils.isBlank(cookieProcessorClassName) && cookieProcessorBean != null) {
            cookieProcessorClassName = cookieProcessorBean.getAttribute("class-name");
        }
        if (StringUtils.isBlank(cookieProcessorClassName)) {
            cookieProcessor = new Rfc6265CookieProcessor();
        } else {
            try {
                cookieProcessor = (CookieProcessor)Class.forName(cookieProcessorClassName).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e2) {
                log.error(sm.getString("cookieProcessor.notExist", cookieProcessorClassName), e2);
                throw new RuntimeException(e2);
            }
        }
        if (cookieProcessorBean != null) {
            BeanInspectUtils.transmitProperties((Object)cookieProcessor, cookieProcessorBean);
        }
        BeanInspectUtils.transmitProperties((Object)cookieProcessor, cookieAttributes);
        return cookieProcessor;
    }

    private void configSessionManager() {
        Manager besWebXmlManager;
        HashMap<String, String> finalManagerProperties = new HashMap<String, String>();
        HashMap<String, String> finalStoreProperties = new HashMap<String, String>();
        DomTemplate sm = DeploymentContextUtils.getWebModuleSessionManager(this.context.getName());
        if (sm == null) {
            sm = this.getDefaultSessionManager();
        }
        String defaultClassName = sm.getAttribute("class-name");
        boolean needMergeProperties = true;
        Manager finalManager = null;
        if (this.besWebXml != null && (besWebXmlManager = this.besWebXml.getManager()) != null && !besWebXmlManager.getClass().getName().equals(defaultClassName)) {
            finalManager = besWebXmlManager;
            needMergeProperties = false;
        }
        if (needMergeProperties) {
            finalManager = this.createSessionManager(sm);
            if (sm.getElement("manager-properties") != null) {
                for (DomTemplate property : sm.getElement("manager-properties").getElements("property")) {
                    finalManagerProperties.put(property.getAttribute("name"), property.getAttribute("value"));
                }
            }
            if (sm.getElement("property") != null) {
                for (DomTemplate property : sm.getElements("property")) {
                    finalManagerProperties.put(property.getAttribute("name"), property.getAttribute("value"));
                }
            }
            if (sm.getElement("store-properties") != null) {
                for (DomTemplate property : sm.getElement("store-properties").getElements("property")) {
                    finalStoreProperties.put(property.getAttribute("name"), property.getAttribute("value"));
                }
            }
        }
        if (this.besWebXml != null && this.besWebXml.getManagerProperties().size() > 0) {
            for (Property webProp : this.besWebXml.getManagerProperties()) {
                finalManagerProperties.put(webProp.getName(), webProp.getValue());
            }
        }
        if (this.besWebXml != null && this.besWebXml.getStoreProperties().size() > 0) {
            for (Property webProp : this.besWebXml.getStoreProperties()) {
                finalStoreProperties.put(webProp.getName(), webProp.getValue());
            }
        }
        if (this.besWebXml != null && this.besWebXml.getSessionIdGenerator() != null) {
            finalManager.setSessionIdGenerator(this.besWebXml.getSessionIdGenerator());
        }
        this.configManagerProperties(finalManagerProperties, finalManager);
        this.configStoreProperties(finalStoreProperties, finalManager);
        this.context.setManager(finalManager);
    }

    private void configStoreProperties(Map<String, String> finalStoreProperties, Manager manager) {
        if (manager instanceof PersistentManager && ((PersistentManager)manager).getStore() != null) {
            for (Map.Entry<String, String> storeProperty : finalStoreProperties.entrySet()) {
                IntrospectionUtils.setProperty(((PersistentManager)manager).getStore(), storeProperty.getKey(), storeProperty.getValue());
            }
        }
    }

    private void configManagerProperties(Map<String, String> finalManagerProperties, Manager manager) {
        if (finalManagerProperties != null) {
            for (Map.Entry<String, String> managerProperty : finalManagerProperties.entrySet()) {
                try {
                    if (managerProperty.getKey().equals("maxInactiveInterval") && !StringUtils.isBlank((String)managerProperty.getValue())) {
                        this.context.setSessionTimeout(Integer.parseInt(managerProperty.getValue()));
                        continue;
                    }
                    if (managerProperty.getKey().equals("reapInterval") && !StringUtils.isBlank((String)managerProperty.getValue())) {
                        this.context.setBackgroundProcessorDelay(Integer.parseInt(managerProperty.getValue()));
                        continue;
                    }
                    if (managerProperty.getKey().equals("sessionFileName")) {
                        IntrospectionUtils.setProperty(manager, "pathname", managerProperty.getValue() == null ? "" : managerProperty.getValue());
                        continue;
                    }
                    BESContextConfig.setPropertyValue(manager, managerProperty.getKey(), managerProperty.getValue() == null ? "" : managerProperty.getValue());
                }
                catch (Exception e2) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Invalid Property " + managerProperty.getKey() + " for " + manager.getClass().getCanonicalName());
                }
            }
            String managerClassName = manager.getClass().getName();
            if (managerClassName.startsWith("com.bes.web.sm.manager.bcs.")) {
                try {
                    Method method = manager.getClass().getMethod("config", new Class[0]);
                    Object config = method.invoke((Object)manager, new Object[0]);
                    BESContextConfig.setProperties(config, finalManagerProperties);
                }
                catch (Exception e3) {
                    log.warn("Failed to config bes cache server.", e3);
                }
            }
        }
    }

    private static void setProperties(Object obj, Map<String, String> properties) throws Exception {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            IntrospectionUtils.setProperty(obj, entry.getKey(), entry.getValue());
        }
    }

    private static void setPropertyValue(Object bean, String propertyName, String propertyValue) throws Exception {
        if (propertyName.indexOf(PROPERTY_SEPARATE) == -1) {
            if (bean instanceof Map) {
                ((Map)bean).put(propertyName, propertyValue);
            } else if (!IntrospectionUtils.setProperty(bean, propertyName, propertyValue)) {
                throw new Exception("Set property " + propertyName + " with value " + propertyValue + " failed!");
            }
        } else {
            String prePropertyName = propertyName.substring(0, propertyName.indexOf(PROPERTY_SEPARATE));
            Object preOjbect = null;
            if (bean instanceof Map) {
                preOjbect = ((Map)bean).get(prePropertyName);
            } else {
                PropertyDescriptor pd = new PropertyDescriptor(prePropertyName, bean.getClass());
                Method wM = pd.getReadMethod();
                preOjbect = wM.invoke(bean, new Object[0]);
            }
            BESContextConfig.setPropertyValue(preOjbect, propertyName.substring(propertyName.indexOf(PROPERTY_SEPARATE) + 1), propertyValue);
        }
    }

    private void initSessionIdGenerator(DomTemplate defaultSessionManager, Manager manager) {
        if (defaultSessionManager.getElement("session-id-generator") != null) {
            SessionIdGenerator sessionIdGenerator = null;
            String sessionIdGeneratorClassName = defaultSessionManager.getElement("session-id-generator").getAttribute("class-name");
            try {
                sessionIdGenerator = (SessionIdGenerator)Class.forName(sessionIdGeneratorClassName).newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            BeanInspectUtils.transmitProperties((Object)sessionIdGenerator, defaultSessionManager.getElement("session-id-generator"));
            BeanInspectUtils.transmitProperties((Object)sessionIdGenerator, defaultSessionManager.getElement("session-id-generator").getElements("property"));
            manager.setSessionIdGenerator(sessionIdGenerator);
        }
    }

    private void initStore(DomTemplate defaultSessionManager, Manager manager) {
        if (defaultSessionManager.getElement("store") != null) {
            Store store = null;
            String storeClassName = defaultSessionManager.getElement("store").getAttribute("class-name");
            try {
                store = (Store)Class.forName(storeClassName).newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            BeanInspectUtils.transmitProperties((Object)store, defaultSessionManager.getElement("store"));
            BeanInspectUtils.transmitProperties((Object)store, defaultSessionManager.getElement("store").getElements("property"));
            if (manager instanceof PersistentManager && store != null) {
                ((PersistentManager)manager).setStore(store);
            } else if (store != null) {
                try {
                    Method method = manager.getClass().getDeclaredMethod("setStore", Store.class);
                    method.invoke((Object)manager, store);
                }
                catch (Exception e3) {
                    log.warn(sm.getString("sessionManager.store.configFailed", manager.getClass()), e3);
                }
            }
        }
    }

    private Manager createSessionManager(DomTemplate sessionManagerBean) {
        Manager manager = null;
        String managerClassName = sessionManagerBean.getAttribute("class-name");
        try {
            if (managerClassName.startsWith("com.bes.web.sm.manager.bcs.")) {
                ClassLoader cl = ContextHolder.currentContext().getBcsClassLoader();
                manager = (Manager)cl.loadClass(managerClassName).newInstance();
            } else {
                manager = (Manager)Class.forName(managerClassName).newInstance();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e2) {
            log.error(sm.getString("sessionManager.createFailed", managerClassName), e2);
            throw new RuntimeException(e2);
        }
        this.initSessionIdGenerator(sessionManagerBean, manager);
        this.initStore(sessionManagerBean, manager);
        return manager;
    }

    private DomTemplate getDefaultSessionManager() {
        if (ContextHolder.currentContext() == null) {
            throw new IllegalStateException("NO current context in ContextHolder.");
        }
        DomTemplate serverBean = ContextHolder.currentContext().getConfigBean();
        DomTemplate hotDeployConfig = serverBean.getElement("hotdeploy-config");
        DomTemplate defaultSessionManager = null;
        if (hotDeployConfig != null) {
            List<DomTemplate> managers;
            String defaultSessionManagerName = hotDeployConfig.getAttribute("session-manager");
            DomTemplate sessionManagers = serverBean.getElement("web-container").getElement("session-managers");
            if (sessionManagers != null && !StringUtils.isBlank((String)defaultSessionManagerName) && (managers = sessionManagers.getElements("session-manager")) != null) {
                for (DomTemplate manager : managers) {
                    if (!manager.getAttribute("name").equals(defaultSessionManagerName)) continue;
                    defaultSessionManager = manager;
                    break;
                }
            }
            if (defaultSessionManager == null && !StringUtils.isBlank((String)defaultSessionManagerName)) {
                throw new RuntimeException(String.format("Couldn't find session manager config with name %s", defaultSessionManagerName));
            }
        }
        return defaultSessionManager;
    }

    static {
        OBJECT_MAX_SIZE_FACTOR = Integer.getInteger("com.bes.enterprise.resource.cache.objectMaxSizeFactor", 20);
        HashMap<String, String> publicIds = new HashMap<String, String>();
        HashMap<String, String> systemIds = new HashMap<String, String>();
        BESContextConfig.add(publicIds, "-//BES Tech Service(HK) Co., Ltd.//DTD BES Application Server Servlet 2.5//EN", BESContextConfig.locationFor("bes-web-app_3_0-1.dtd"));
        BESContextConfig.add(publicIds, "-//Baolande Software Corporation//DTD BES Application Server Servlet 3.0//EN", BESContextConfig.locationFor("bes-web-app_3_0-1.dtd"));
        BESContextConfig.add(publicIds, "-//Baolande Software Corporation//DTD BES Application Server Servlet 3.1//EN", BESContextConfig.locationFor("bes-web-app_3_0-1.dtd"));
        BESContextConfig.add(systemIds, "http://www.bessystem.com/appserver/dtds/bes-web-app_2_5-0.dtd", BESContextConfig.locationFor("bes-web-app_3_0-1.dtd"));
        BESContextConfig.add(systemIds, "http://www.bessystem.com/appserver/dtds/bes-web-app_3_0-0.dtd", BESContextConfig.locationFor("bes-web-app_3_0-1.dtd"));
        BESContextConfig.add(systemIds, "http://www.bessystem.com/appserver/dtds/bes-web-app_3_0-1.dtd", BESContextConfig.locationFor("bes-web-app_3_0-1.dtd"));
        BES_WEB_PUBLIC_IDS = Collections.unmodifiableMap(publicIds);
        BES_WEB_SYSTEM_IDS = Collections.unmodifiableMap(systemIds);
    }
}

