/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.startup;

import com.bes.appserv.lic.Auth;
import com.bes.appserv.lic.LicData;
import com.bes.appserv.lic.LicenseHelper;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.buf.UriUtil;
import com.bes.enterprise.web.util.descriptor.web.LoginConfig;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.Engine;
import com.bes.enterprise.webtier.Host;
import com.bes.enterprise.webtier.LifecycleEvent;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleListener;
import com.bes.enterprise.webtier.Realm;
import com.bes.enterprise.webtier.Server;
import com.bes.enterprise.webtier.Service;
import com.bes.enterprise.webtier.Wrapper;
import com.bes.enterprise.webtier.authenticator.NonLoginAuthenticator;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.core.ApplicationServer;
import com.bes.enterprise.webtier.core.ContainerBase;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.core.DefaultEngine;
import com.bes.enterprise.webtier.core.DefaultHost;
import com.bes.enterprise.webtier.core.DefaultService;
import com.bes.enterprise.webtier.core.DefaultWrapper;
import com.bes.enterprise.webtier.core.NamingContextListener;
import com.bes.enterprise.webtier.realm.GenericPrincipal;
import com.bes.enterprise.webtier.realm.RealmBase;
import com.bes.enterprise.webtier.startup.ContextConfig;
import com.bes.enterprise.webtier.startup.WebAnnotationSet;
import com.bes.enterprise.webtier.util.ServerInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.annotation.WebServlet;

public class BESCore {
    private final Map<String, Logger> pinnedLoggers = new HashMap<String, Logger>();
    protected Server server;
    protected int port = 8080;
    protected String hostname = "localhost";
    protected String basedir;
    protected boolean defaultConnectorCreated = false;
    private final Map<String, String> userPass = new HashMap<String, String>();
    private final Map<String, List<String>> userRoles = new HashMap<String, List<String>>();
    private final Map<String, Principal> userPrincipals = new HashMap<String, Principal>();
    static final String[] silences = new String[]{"com.bes.enterprise.web.crane.http11.Http11NioProtocol", "com.bes.enterprise.webtier.core.DefaultService", "com.bes.enterprise.webtier.core.DefaultEngine", "com.bes.enterprise.webtier.startup.BESContextConfig", "com.bes.enterprise.webtier.core.ApplicationContext", "com.bes.enterprise.webtier.core.AprLifecycleListener"};
    private boolean silent = false;
    private static final String[] DEFAULT_MIME_MAPPINGS = new String[]{"abs", "audio/x-mpeg", "ai", "application/postscript", "aif", "audio/x-aiff", "aifc", "audio/x-aiff", "aiff", "audio/x-aiff", "aim", "application/x-aim", "art", "image/x-jg", "asf", "video/x-ms-asf", "asx", "video/x-ms-asf", "au", "audio/basic", "avi", "video/x-msvideo", "avx", "video/x-rad-screenplay", "bcpio", "application/x-bcpio", "bin", "application/octet-stream", "bmp", "image/bmp", "body", "text/html", "cdf", "application/x-cdf", "cer", "application/pkix-cert", "class", "application/java", "cpio", "application/x-cpio", "csh", "application/x-csh", "css", "text/css", "dib", "image/bmp", "doc", "application/msword", "dtd", "application/xml-dtd", "dv", "video/x-dv", "dvi", "application/x-dvi", "eps", "application/postscript", "etx", "text/x-setext", "exe", "application/octet-stream", "gif", "image/gif", "gtar", "application/x-gtar", "gz", "application/x-gzip", "hdf", "application/x-hdf", "hqx", "application/mac-binhex40", "htc", "text/x-component", "htm", "text/html", "html", "text/html", "ief", "image/ief", "jad", "text/vnd.sun.j2me.app-descriptor", "jar", "application/java-archive", "java", "text/x-java-source", "jnlp", "application/x-java-jnlp-file", "jpe", "image/jpeg", "jpeg", "image/jpeg", "jpg", "image/jpeg", "js", "application/javascript", "jsf", "text/plain", "jspf", "text/plain", "kar", "audio/midi", "latex", "application/x-latex", "m3u", "audio/x-mpegurl", "mac", "image/x-macpaint", "man", "text/troff", "mathml", "application/mathml+xml", "me", "text/troff", "mid", "audio/midi", "midi", "audio/midi", "mif", "application/x-mif", "mov", "video/quicktime", "movie", "video/x-sgi-movie", "mp1", "audio/mpeg", "mp2", "audio/mpeg", "mp3", "audio/mpeg", "mp4", "video/mp4", "mpa", "audio/mpeg", "mpe", "video/mpeg", "mpeg", "video/mpeg", "mpega", "audio/x-mpeg", "mpg", "video/mpeg", "mpv2", "video/mpeg2", "nc", "application/x-netcdf", "oda", "application/oda", "odb", "application/vnd.oasis.opendocument.database", "odc", "application/vnd.oasis.opendocument.chart", "odf", "application/vnd.oasis.opendocument.formula", "odg", "application/vnd.oasis.opendocument.graphics", "odi", "application/vnd.oasis.opendocument.image", "odm", "application/vnd.oasis.opendocument.text-master", "odp", "application/vnd.oasis.opendocument.presentation", "ods", "application/vnd.oasis.opendocument.spreadsheet", "odt", "application/vnd.oasis.opendocument.text", "otg", "application/vnd.oasis.opendocument.graphics-template", "oth", "application/vnd.oasis.opendocument.text-web", "otp", "application/vnd.oasis.opendocument.presentation-template", "ots", "application/vnd.oasis.opendocument.spreadsheet-template ", "ott", "application/vnd.oasis.opendocument.text-template", "ogx", "application/ogg", "ogv", "video/ogg", "oga", "audio/ogg", "ogg", "audio/ogg", "spx", "audio/ogg", "flac", "audio/flac", "anx", "application/annodex", "axa", "audio/annodex", "axv", "video/annodex", "xspf", "application/xspf+xml", "pbm", "image/x-portable-bitmap", "pct", "image/pict", "pdf", "application/pdf", "pgm", "image/x-portable-graymap", "pic", "image/pict", "pict", "image/pict", "pls", "audio/x-scpls", "png", "image/png", "pnm", "image/x-portable-anymap", "pnt", "image/x-macpaint", "ppm", "image/x-portable-pixmap", "ppt", "application/vnd.ms-powerpoint", "pps", "application/vnd.ms-powerpoint", "ps", "application/postscript", "psd", "image/vnd.adobe.photoshop", "qt", "video/quicktime", "qti", "image/x-quicktime", "qtif", "image/x-quicktime", "ras", "image/x-cmu-raster", "rdf", "application/rdf+xml", "rgb", "image/x-rgb", "rm", "application/vnd.rn-realmedia", "roff", "text/troff", "rtf", "application/rtf", "rtx", "text/richtext", "sh", "application/x-sh", "shar", "application/x-shar", "sit", "application/x-stuffit", "snd", "audio/basic", "src", "application/x-wais-source", "sv4cpio", "application/x-sv4cpio", "sv4crc", "application/x-sv4crc", "svg", "image/svg+xml", "svgz", "image/svg+xml", "swf", "application/x-shockwave-flash", "t", "text/troff", "tar", "application/x-tar", "tcl", "application/x-tcl", "tex", "application/x-tex", "texi", "application/x-texinfo", "texinfo", "application/x-texinfo", "tif", "image/tiff", "tiff", "image/tiff", "tr", "text/troff", "tsv", "text/tab-separated-values", "txt", "text/plain", "ulw", "audio/basic", "ustar", "application/x-ustar", "vxml", "application/voicexml+xml", "xbm", "image/x-xbitmap", "xht", "application/xhtml+xml", "xhtml", "application/xhtml+xml", "xls", "application/vnd.ms-excel", "xml", "application/xml", "xpm", "image/x-xpixmap", "xsl", "application/xml", "xslt", "application/xslt+xml", "xul", "application/vnd.mozilla.xul+xml", "xwd", "image/x-xwindowdump", "vsd", "application/vnd.visio", "wav", "audio/x-wav", "wbmp", "image/vnd.wap.wbmp", "wml", "text/vnd.wap.wml", "wmlc", "application/vnd.wap.wmlc", "wmls", "text/vnd.wap.wmlsc", "wmlscriptc", "application/vnd.wap.wmlscriptc", "wmv", "video/x-ms-wmv", "wrl", "model/vrml", "wspolicy", "application/wspolicy+xml", "Z", "application/x-compress", "z", "application/x-compress", "zip", "application/zip"};

    public BESCore() {
        if ("BESCore".equals(this.getClass().getSimpleName())) {
            System.setProperty("com.bes.enterprise.webtier.default.configclass", "com.bes.enterprise.webtier.startup.ContextConfig");
        }
        ExceptionUtils.preload();
    }

    public void setBaseDir(String basedir) {
        this.basedir = basedir;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHostname(String s2) {
        this.hostname = s2;
    }

    public Context addWebapp(String contextPath, String docBase) throws ServletException {
        return this.addWebapp(this.getHost(), contextPath, docBase);
    }

    public Context addContext(String contextPath, String docBase) {
        return this.addContext(this.getHost(), contextPath, docBase);
    }

    public Wrapper addServlet(String contextPath, String servletName, String servletClass) {
        Container ctx = this.getHost().findChild(contextPath);
        return BESCore.addServlet((Context)ctx, servletName, servletClass);
    }

    public static Wrapper addServlet(Context ctx, String servletName, String servletClass) {
        Wrapper sw = ctx.createWrapper();
        sw.setServletClass(servletClass);
        sw.setName(servletName);
        ctx.addChild(sw);
        return sw;
    }

    public Wrapper addServlet(String contextPath, String servletName, Servlet servlet) {
        Container ctx = this.getHost().findChild(contextPath);
        return BESCore.addServlet((Context)ctx, servletName, servlet);
    }

    public static Wrapper addServlet(Context ctx, String servletName, Servlet servlet) {
        ExistingCloudServletWrapper sw = new ExistingCloudServletWrapper(servlet);
        sw.setName(servletName);
        ctx.addChild(sw);
        return sw;
    }

    public void init() throws LifecycleException {
        this.getServer();
        this.getConnector();
        this.server.init();
    }

    public void start() throws LifecycleException {
        this.getServer();
        this.getConnector();
        this.server.start();
    }

    public void stop() throws LifecycleException {
        this.getServer();
        this.server.stop();
    }

    public void destroy() throws LifecycleException {
        this.getServer();
        this.server.destroy();
    }

    public void addUser(String user, String pass) {
        this.userPass.put(user, pass);
    }

    public void addRole(String user, String role) {
        List<String> roles = this.userRoles.get(user);
        if (roles == null) {
            roles = new ArrayList<String>();
            this.userRoles.put(user, roles);
        }
        roles.add(role);
    }

    public Connector getConnector() {
        Service service = this.getService();
        if (service.findConnectors().length > 0) {
            return service.findConnectors()[0];
        }
        if (this.defaultConnectorCreated) {
            return null;
        }
        Connector connector = new Connector("HTTP/1.1");
        connector.setPort(this.port);
        service.addConnector(connector);
        this.defaultConnectorCreated = true;
        return connector;
    }

    public void setConnector(Connector connector) {
        this.defaultConnectorCreated = true;
        Service service = this.getService();
        boolean found = false;
        for (Connector serviceConnector : service.findConnectors()) {
            if (connector != serviceConnector) continue;
            found = true;
        }
        if (!found) {
            service.addConnector(connector);
        }
    }

    public Service getService() {
        return this.getServer().findServices()[0];
    }

    public void setHost(Host host) {
        Engine engine = this.getEngine();
        boolean found = false;
        for (Container engineHost : engine.findChildren()) {
            if (engineHost != host) continue;
            found = true;
        }
        if (!found) {
            engine.addChild(host);
        }
    }

    public Host getHost() {
        Engine engine = this.getEngine();
        if (engine.findChildren().length > 0) {
            return (Host)engine.findChildren()[0];
        }
        DefaultHost host = new DefaultHost();
        host.setName(this.hostname);
        this.getEngine().addChild(host);
        return host;
    }

    public Engine getEngine() {
        Service service = this.getServer().findServices()[0];
        if (service.getContainer() != null) {
            return service.getContainer();
        }
        DefaultEngine engine = new DefaultEngine();
        engine.setName("com.bes.appserv");
        engine.setDefaultHost(this.hostname);
        engine.setRealm(this.createDefaultRealm());
        service.setContainer(engine);
        return engine;
    }

    public Server getServer() {
        if (this.server != null) {
            return this.server;
        }
        System.setProperty("bes.useNaming", "false");
        this.server = new ApplicationServer();
        this.initBaseDir();
        try {
            Auth.check(this.basedir, "WEB", "SpringBoot");
            this.showLicInfo();
            long remainingDays = Auth.queryExpiry(this.basedir);
            long expirtionReminderDays = Auth.getShowMsgexpiryDays();
            if (remainingDays <= expirtionReminderDays && remainingDays != -1L) {
                System.out.println("BES will expire in " + remainingDays + " days.");
            }
        }
        catch (Exception ex) {
            System.out.println("Error occurred when checking license :" + ex.getMessage());
            System.exit(1);
        }
        this.server.setPort(-1);
        DefaultService service = new DefaultService();
        service.setName("com.bes.Service");
        this.server.addService(service);
        return this.server;
    }

    private void showLicInfo() throws Exception {
        LicData licData = LicenseHelper.readLicData();
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder licInfo = new StringBuilder();
        licInfo.append("Server information :").append(lineSeparator);
        licInfo.append("----------------------------------------------------------------");
        licInfo.append(lineSeparator);
        licInfo.append(ServerInfo.getServerInfo()).append(lineSeparator);
        licInfo.append(ServerInfo.getServerBuilt()).append(lineSeparator);
        licInfo.append("Copyright (c) 2018-2022 Beijing Baolande Software Corporation. All Rights Reserved.");
        licInfo.append(lineSeparator);
        licInfo.append(lineSeparator);
        licInfo.append("License information :").append(lineSeparator);
        licInfo.append("   ").append("Custom  Name : ").append(licData.getCustomerName());
        licInfo.append(lineSeparator);
        licInfo.append("   ").append("Project Name : ").append(licData.getProjectName());
        licInfo.append(lineSeparator);
        licInfo.append("   ").append("License Type : ").append(licData.getRegisterType());
        licInfo.append(lineSeparator);
        licInfo.append("   ").append("Expiry  Date : ").append(licData.getExpiryDate());
        licInfo.append(lineSeparator);
        licInfo.append("----------------------------------------------------------------");
        System.out.println(licInfo.toString());
    }

    public Context addContext(Host host, String contextPath, String dir) {
        return this.addContext(host, contextPath, contextPath, dir);
    }

    public Context addContext(Host host, String contextPath, String contextName, String dir) {
        this.silence(host, contextName);
        Context ctx = this.createContext(host, contextPath);
        ctx.setName(contextName);
        ctx.setPath(contextPath);
        ctx.setDocBase(dir);
        ctx.addLifecycleListener(new FixContextListener());
        if (host == null) {
            this.getHost().addChild(ctx);
        } else {
            host.addChild(ctx);
        }
        return ctx;
    }

    public Context addWebapp(Host host, String contextPath, String docBase) {
        LifecycleListener listener = null;
        try {
            Class<?> clazz = Class.forName(this.getHost().getConfigClass());
            listener = (LifecycleListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e2) {
            throw new IllegalArgumentException(e2);
        }
        return this.addWebapp(host, contextPath, docBase, listener);
    }

    @Deprecated
    public Context addWebapp(Host host, String contextPath, String docBase, ContextConfig config) {
        return this.addWebapp(host, contextPath, docBase, (LifecycleListener)config);
    }

    public Context addWebapp(Host host, String contextPath, String docBase, LifecycleListener config) {
        this.silence(host, contextPath);
        Context ctx = this.createContext(host, contextPath);
        ctx.setPath(contextPath);
        ctx.setDocBase(docBase);
        ctx.addLifecycleListener(this.getDefaultWebXmlListener());
        ctx.setConfigFile(this.getWebappConfigFile(docBase, contextPath));
        ctx.addLifecycleListener(config);
        if (config instanceof ContextConfig) {
            ((ContextConfig)config).setDefaultWebXml(this.noDefaultWebXmlPath());
        }
        if (host == null) {
            this.getHost().addChild(ctx);
        } else {
            host.addChild(ctx);
        }
        return ctx;
    }

    public LifecycleListener getDefaultWebXmlListener() {
        return new DefaultWebXmlListener();
    }

    public String noDefaultWebXmlPath() {
        return "com/bes/enterprise/webtier/startup/NO_DEFAULT_XML";
    }

    protected Realm createDefaultRealm() {
        return new RealmBase(){

            @Override
            @Deprecated
            protected String getName() {
                return "Simple";
            }

            @Override
            protected String getPassword(String username) {
                return (String)BESCore.this.userPass.get(username);
            }

            @Override
            protected Principal getPrincipal(String username) {
                String pass;
                Principal p2 = (Principal)BESCore.this.userPrincipals.get(username);
                if (p2 == null && (pass = (String)BESCore.this.userPass.get(username)) != null) {
                    p2 = new GenericPrincipal(username, pass, (List)BESCore.this.userRoles.get(username));
                    BESCore.this.userPrincipals.put(username, p2);
                }
                return p2;
            }
        };
    }

    protected void initBaseDir() {
        String heavenHome = System.getProperty("com.bes.installRoot");
        if (this.basedir == null) {
            this.basedir = System.getProperty("com.bes.instanceRoot");
        }
        if (this.basedir == null) {
            this.basedir = heavenHome;
        }
        if (this.basedir == null) {
            this.basedir = System.getProperty("user.dir") + "/bes." + this.port;
        }
        File baseFile = new File(this.basedir);
        baseFile.mkdirs();
        try {
            baseFile = baseFile.getCanonicalFile();
        }
        catch (IOException e2) {
            baseFile = baseFile.getAbsoluteFile();
        }
        this.server.setHeavenBase(baseFile);
        System.setProperty("com.bes.instanceRoot", baseFile.getPath());
        this.basedir = baseFile.getPath();
        if (heavenHome == null) {
            this.server.setHeavenHome(baseFile);
        } else {
            File homeFile = new File(heavenHome);
            homeFile.mkdirs();
            try {
                homeFile = homeFile.getCanonicalFile();
            }
            catch (IOException e3) {
                homeFile = homeFile.getAbsoluteFile();
            }
            this.server.setHeavenHome(homeFile);
        }
        System.setProperty("com.bes.installRoot", this.server.getHeavenHome().getPath());
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
        for (String s2 : silences) {
            Logger logger = Logger.getLogger(s2);
            this.pinnedLoggers.put(s2, logger);
            if (silent) {
                logger.setLevel(Level.WARNING);
                continue;
            }
            logger.setLevel(Level.INFO);
        }
    }

    private void silence(Host host, String contextPath) {
        String loggerName = this.getLoggerName(host, contextPath);
        Logger logger = Logger.getLogger(loggerName);
        this.pinnedLoggers.put(loggerName, logger);
        if (this.silent) {
            logger.setLevel(Level.WARNING);
        } else {
            logger.setLevel(Level.INFO);
        }
    }

    private String getLoggerName(Host host, String contextName) {
        if (host == null) {
            host = this.getHost();
        }
        StringBuilder loggerName = new StringBuilder();
        loggerName.append(ContainerBase.class.getName());
        loggerName.append(".[");
        loggerName.append(host.getParent().getName());
        loggerName.append("].[");
        loggerName.append(host.getName());
        loggerName.append("].[");
        if (contextName == null || contextName.equals("")) {
            loggerName.append("/");
        } else if (contextName.startsWith("##")) {
            loggerName.append("/");
            loggerName.append(contextName);
        }
        loggerName.append(']');
        return loggerName.toString();
    }

    private Context createContext(Host host, String url) {
        String contextClass = DefaultContext.class.getName();
        if (host == null) {
            host = this.getHost();
        }
        if (host instanceof DefaultHost) {
            contextClass = ((DefaultHost)host).getContextClass();
        }
        try {
            return (Context)Class.forName(contextClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
            throw new IllegalArgumentException("Can't instantiate context-class " + contextClass + " for host " + host + " and url " + url, e2);
        }
    }

    public void enableNaming() {
        this.getServer();
        this.server.addLifecycleListener(new NamingContextListener());
        System.setProperty("bes.useNaming", "true");
        String value = "com.bes.enterprise.naming";
        String oldValue = System.getProperty("java.naming.factory.url.pkgs");
        if (oldValue != null) {
            value = oldValue.contains(value) ? oldValue : value + ":" + oldValue;
        }
        System.setProperty("java.naming.factory.url.pkgs", value);
        value = System.getProperty("java.naming.factory.initial");
        if (value == null) {
            System.setProperty("java.naming.factory.initial", "com.bes.enterprise.naming.java.javaURLContextFactory");
        }
    }

    public void initWebappDefaults(String contextPath) {
        Container ctx = this.getHost().findChild(contextPath);
        BESCore.initWebappDefaults((Context)ctx);
    }

    public static void initWebappDefaults(Context ctx) {
        Wrapper servlet = BESCore.addServlet(ctx, "default", "com.bes.enterprise.webtier.servlets.DefaultServlet");
        servlet.setLoadOnStartup(1);
        servlet.setOverridable(true);
        servlet = BESCore.addServlet(ctx, "jsp", "com.bes.enterprise.web.jasper.servlet.JspServlet");
        servlet.addInitParameter("fork", "false");
        servlet.setLoadOnStartup(3);
        servlet.setOverridable(true);
        ctx.addServletMappingDecoded("/", "default");
        ctx.addServletMappingDecoded("*.jsp", "jsp");
        ctx.addServletMappingDecoded("*.jspx", "jsp");
        ctx.setSessionTimeout(30);
        int i2 = 0;
        while (i2 < DEFAULT_MIME_MAPPINGS.length) {
            ctx.addMimeMapping(DEFAULT_MIME_MAPPINGS[i2++], DEFAULT_MIME_MAPPINGS[i2++]);
        }
        ctx.addWelcomeFile("index.html");
        ctx.addWelcomeFile("index.htm");
        ctx.addWelcomeFile("index.jsp");
    }

    protected URL getWebappConfigFile(String path, String contextName) {
        File docBase = new File(path);
        if (docBase.isDirectory()) {
            return this.getWebappConfigFileFromDirectory(docBase, contextName);
        }
        return this.getWebappConfigFileFromJar(docBase, contextName);
    }

    private URL getWebappConfigFileFromDirectory(File docBase, String contextName) {
        URL result = null;
        File webAppContextXml = new File(docBase, "WEB-INF/bes-web.xml");
        if (webAppContextXml.exists()) {
            try {
                result = webAppContextXml.toURI().toURL();
            }
            catch (MalformedURLException e2) {
                Logger.getLogger(this.getLoggerName(this.getHost(), contextName)).log(Level.WARNING, "Unable to determine web application context.xml " + docBase, e2);
            }
        }
        return result;
    }

    private URL getWebappConfigFileFromJar(File docBase, String contextName) {
        URL result = null;
        try (JarFile jar = new JarFile(docBase);){
            JarEntry entry = jar.getJarEntry("WEB-INF/bes-web.xml");
            if (entry != null) {
                result = UriUtil.buildJarUrl(docBase, "WEB-INF/bes-web.xml");
            }
        }
        catch (IOException e2) {
            Logger.getLogger(this.getLoggerName(this.getHost(), contextName)).log(Level.WARNING, "Unable to determine web application context.xml " + docBase, e2);
        }
        return result;
    }

    public static class ExistingCloudServletWrapper
    extends DefaultWrapper {
        private final Servlet existing;

        public ExistingCloudServletWrapper(Servlet existing) {
            this.existing = existing;
            if (existing instanceof SingleThreadModel) {
                this.singleThreadModel = true;
                this.instancePool = new Stack();
            }
            this.asyncSupported = ExistingCloudServletWrapper.hasAsync(existing);
        }

        private static boolean hasAsync(Servlet existing) {
            boolean result = false;
            Class<?> clazz = existing.getClass();
            WebServlet ws = clazz.getAnnotation(WebServlet.class);
            if (ws != null) {
                result = ws.asyncSupported();
            }
            return result;
        }

        @Override
        public synchronized Servlet loadServlet() throws ServletException {
            if (this.singleThreadModel) {
                Servlet instance;
                try {
                    instance = (Servlet)this.existing.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e2) {
                    throw new ServletException(e2);
                }
                instance.init(this.facade);
                return instance;
            }
            if (!this.instanceInitialized) {
                this.existing.init(this.facade);
                this.instanceInitialized = true;
            }
            return this.existing;
        }

        @Override
        public long getAvailable() {
            return 0L;
        }

        @Override
        public boolean isUnavailable() {
            return false;
        }

        @Override
        public Servlet getServlet() {
            return this.existing;
        }

        @Override
        public String getServletClass() {
            return this.existing.getClass().getName();
        }
    }

    public static class DefaultWebXmlListener
    implements LifecycleListener {
        @Override
        public void lifecycleEvent(LifecycleEvent event) {
            if ("before_start".equals(event.getType())) {
                BESCore.initWebappDefaults((Context)event.getLifecycle());
            }
        }
    }

    public static class FixContextListener
    implements LifecycleListener {
        @Override
        public void lifecycleEvent(LifecycleEvent event) {
            try {
                Context context = (Context)event.getLifecycle();
                if (event.getType().equals("configure_start")) {
                    context.setConfigured(true);
                    WebAnnotationSet.loadApplicationAnnotations(context);
                    if (context.getLoginConfig() == null) {
                        context.setLoginConfig(new LoginConfig("NONE", null, null, null));
                        context.getPipeline().addValve(new NonLoginAuthenticator());
                    }
                }
            }
            catch (ClassCastException e2) {
                return;
            }
        }
    }
}

