/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.startup;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Engine;
import com.bes.enterprise.webtier.LifecycleEvent;
import com.bes.enterprise.webtier.LifecycleListener;

public class EngineConfig
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(EngineConfig.class);
    protected Engine engine = null;
    protected static final StringManager sm = StringManager.getManager("com.bes.enterprise.webtier.startup");

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.engine = (Engine)event.getLifecycle();
        }
        catch (ClassCastException e2) {
            log.error(sm.getString("engineConfig.cce", event.getLifecycle()), e2);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    protected void start() {
        if (this.engine.getLogger().isDebugEnabled()) {
            this.engine.getLogger().debug(sm.getString("engineConfig.start"));
        }
    }

    protected void stop() {
        if (this.engine.getLogger().isDebugEnabled()) {
            this.engine.getLogger().debug(sm.getString("engineConfig.stop"));
        }
    }
}

