/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.startup;

import com.bes.appserv.lic.Auth;
import com.bes.appserv.lic.client.handler.LicenseHandler;
import com.bes.enterprise.logging.ClassLoaderLogManager;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.digester.Digester;
import com.bes.enterprise.web.util.digester.RuleSet;
import com.bes.enterprise.web.util.log.SystemLogHandler;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.Server;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.security.SecurityConfig;
import com.bes.enterprise.webtier.startup.ASMain;
import com.bes.enterprise.webtier.startup.CertificateCreateRule;
import com.bes.enterprise.webtier.startup.ConnectorCreateRule;
import com.bes.enterprise.webtier.startup.ContextRuleSet;
import com.bes.enterprise.webtier.startup.EngineRuleSet;
import com.bes.enterprise.webtier.startup.HostRuleSet;
import com.bes.enterprise.webtier.startup.NamingRuleSet;
import com.bes.enterprise.webtier.startup.SetAllPropertiesRule;
import com.bes.enterprise.webtier.startup.SetParentClassLoaderRule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.LogManager;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class Heaven {
    protected static final StringManager sm = StringManager.getManager("com.bes.enterprise.webtier.startup");
    protected static boolean enableWebtierSystemLogHandler = Boolean.getBoolean("com.bes.enterprise.web.enableWebtierSystemLogHandler");
    protected boolean await = false;
    protected String configFile = "conf/server.xml";
    protected ClassLoader parentClassLoader = Heaven.class.getClassLoader();
    protected ClassLoader bcsClassLoader = Heaven.class.getClassLoader();
    protected ClassLoader jGroupsClassLoader = Heaven.class.getClassLoader();
    protected Server server = null;
    protected boolean useShutdownHook = true;
    protected Thread shutdownHook = null;
    protected boolean useNaming = true;
    protected boolean loaded = false;
    private static final Log log = LogFactory.getLog(Heaven.class);

    public Heaven() {
        this.setSecurityProtection();
        ExceptionUtils.preload();
    }

    public void setConfigFile(String file) {
        this.configFile = file;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    public boolean getUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    public ClassLoader getBcsClassLoader() {
        if (this.bcsClassLoader != null) {
            return this.bcsClassLoader;
        }
        return this.getParentClassLoader();
    }

    public void setBcsClassLoader(ClassLoader bcsClassLoader) {
        this.bcsClassLoader = bcsClassLoader;
    }

    public ClassLoader getJGroupsClassLoader() {
        if (this.jGroupsClassLoader != null) {
            return this.jGroupsClassLoader;
        }
        return this.getParentClassLoader();
    }

    public void setJGroupsClassLoader(ClassLoader jGroupsClassLoader) {
        this.jGroupsClassLoader = jGroupsClassLoader;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    public void setAwait(boolean b2) {
        this.await = b2;
    }

    public boolean isAwait() {
        return this.await;
    }

    protected boolean arguments(String[] args) {
        boolean isConfig = false;
        if (args.length < 1) {
            this.usage();
            return false;
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (isConfig) {
                this.configFile = args[i2];
                isConfig = false;
                continue;
            }
            if (args[i2].equals("-config")) {
                isConfig = true;
                continue;
            }
            if (args[i2].equals("-nonaming")) {
                this.setUseNaming(false);
                continue;
            }
            if (args[i2].equals("-help")) {
                this.usage();
                return false;
            }
            if (args[i2].equals("start") || args[i2].equals("configtest") || args[i2].equals("stop")) continue;
            this.usage();
            return false;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(ASMain.getHeavenBase(), this.configFile);
        }
        return file;
    }

    protected Digester createStartDigester() {
        long t1 = System.currentTimeMillis();
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(true);
        HashMap fakeAttributes = new HashMap();
        ArrayList<String> objectAttrs = new ArrayList<String>();
        objectAttrs.add("className");
        fakeAttributes.put(Object.class, objectAttrs);
        ArrayList<String> contextAttrs = new ArrayList<String>();
        contextAttrs.add("source");
        fakeAttributes.put(DefaultContext.class, contextAttrs);
        digester.setFakeAttributes(fakeAttributes);
        digester.setUseContextClassLoader(true);
        digester.addObjectCreate("Server", "com.bes.enterprise.webtier.core.ApplicationServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "com.bes.enterprise.webtier.Server");
        digester.addObjectCreate("Server/GlobalNamingResources", "com.bes.enterprise.webtier.deploy.NamingResourcesImpl");
        digester.addSetProperties("Server/GlobalNamingResources");
        digester.addSetNext("Server/GlobalNamingResources", "setGlobalNamingResources", "com.bes.enterprise.webtier.deploy.NamingResourcesImpl");
        digester.addObjectCreate("Server/Listener", null, "className");
        digester.addSetProperties("Server/Listener");
        digester.addSetNext("Server/Listener", "addLifecycleListener", "com.bes.enterprise.webtier.LifecycleListener");
        digester.addObjectCreate("Server/Service", "com.bes.enterprise.webtier.core.DefaultService", "className");
        digester.addSetProperties("Server/Service");
        digester.addSetNext("Server/Service", "addService", "com.bes.enterprise.webtier.Service");
        digester.addObjectCreate("Server/Service/Listener", null, "className");
        digester.addSetProperties("Server/Service/Listener");
        digester.addSetNext("Server/Service/Listener", "addLifecycleListener", "com.bes.enterprise.webtier.LifecycleListener");
        digester.addObjectCreate("Server/Service/Executor", "com.bes.enterprise.webtier.core.WorkThreadExecutor", "className");
        digester.addSetProperties("Server/Service/Executor");
        digester.addSetNext("Server/Service/Executor", "addExecutor", "com.bes.enterprise.webtier.Executor");
        digester.addRule("Server/Service/Connector", new ConnectorCreateRule());
        digester.addRule("Server/Service/Connector", new SetAllPropertiesRule(new String[]{"executor", "sslImplementationName"}));
        digester.addSetNext("Server/Service/Connector", "addConnector", "com.bes.enterprise.webtier.connector.Connector");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig", "com.bes.enterprise.web.util.net.SSLHostConfig");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig", "addSslHostConfig", "com.bes.enterprise.web.util.net.SSLHostConfig");
        digester.addRule("Server/Service/Connector/SSLHostConfig/Certificate", new CertificateCreateRule());
        digester.addRule("Server/Service/Connector/SSLHostConfig/Certificate", new SetAllPropertiesRule(new String[]{"type"}));
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/Certificate", "addCertificate", "com.bes.enterprise.web.util.net.SSLHostConfigCertificate");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig/OpenSSLConf", "com.bes.enterprise.web.util.net.openssl.OpenSSLConf");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/OpenSSLConf");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/OpenSSLConf", "setOpenSslConf", "com.bes.enterprise.web.util.net.openssl.OpenSSLConf");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd", "com.bes.enterprise.web.util.net.openssl.OpenSSLConfCmd");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd", "addCmd", "com.bes.enterprise.web.util.net.openssl.OpenSSLConfCmd");
        digester.addObjectCreate("Server/Service/Connector/Listener", null, "className");
        digester.addSetProperties("Server/Service/Connector/Listener");
        digester.addSetNext("Server/Service/Connector/Listener", "addLifecycleListener", "com.bes.enterprise.webtier.LifecycleListener");
        digester.addObjectCreate("Server/Service/Connector/UpgradeProtocol", null, "className");
        digester.addSetProperties("Server/Service/Connector/UpgradeProtocol");
        digester.addSetNext("Server/Service/Connector/UpgradeProtocol", "addUpgradeProtocol", "com.bes.enterprise.web.crane.UpgradeProtocol");
        digester.addRuleSet(new NamingRuleSet("Server/GlobalNamingResources/"));
        digester.addRuleSet(new EngineRuleSet("Server/Service/"));
        digester.addRuleSet(new HostRuleSet("Server/Service/Engine/"));
        digester.addRuleSet(new ContextRuleSet("Server/Service/Engine/Host/"));
        this.addClusterRuleSet(digester, "Server/Service/Engine/Host/Cluster/");
        digester.addRuleSet(new NamingRuleSet("Server/Service/Engine/Host/Context/"));
        digester.addRule("Server/Service/Engine", new SetParentClassLoaderRule(this.parentClassLoader));
        this.addClusterRuleSet(digester, "Server/Service/Engine/Cluster/");
        long t2 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("Digester for server.xml created " + (t2 - t1));
        }
        return digester;
    }

    private void addClusterRuleSet(Digester digester, String prefix) {
        block3: {
            Class<?> clazz = null;
            Constructor<?> constructor = null;
            try {
                clazz = Class.forName("com.bes.enterprise.webtier.ha.ClusterRuleSet");
                constructor = clazz.getConstructor(String.class);
                RuleSet ruleSet = (RuleSet)constructor.newInstance(prefix);
                digester.addRuleSet(ruleSet);
            }
            catch (Exception e2) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("bes.noCluster", e2.getClass().getName() + ": " + e2.getMessage()), e2);
                }
                if (!log.isInfoEnabled()) break block3;
                log.info(sm.getString("bes.noCluster", e2.getClass().getName() + ": " + e2.getMessage()));
            }
        }
    }

    protected Digester createStopDigester() {
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.addObjectCreate("Server", "com.bes.enterprise.webtier.core.ApplicationServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "com.bes.enterprise.webtier.Server");
        return digester;
    }

    public void stopServer() {
        this.stopServer(null);
    }

    public void stopServer(String[] arguments) {
        Throwable throwable;
        Server s2;
        if (arguments != null) {
            this.arguments(arguments);
        }
        if ((s2 = this.getServer()) == null) {
            Digester digester = this.createStopDigester();
            File file = this.configFile();
            try {
                throwable = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    InputSource is = new InputSource(file.toURI().toURL().toString());
                    is.setByteStream(fis);
                    digester.push(this);
                    digester.parse(is);
                }
                catch (Throwable is) {
                    throwable = is;
                    throw is;
                }
            }
            catch (Exception e2) {
                log.error("Heaven.stop: ", e2);
                System.exit(1);
            }
        } else {
            try {
                s2.stop();
                s2.destroy();
            }
            catch (LifecycleException e3) {
                log.error("Heaven.stop: ", e3);
            }
            return;
        }
        s2 = this.getServer();
        if (s2.getPort() > 0) {
            try (Socket socket = new Socket(s2.getAddress(), s2.getPort());){
                throwable = null;
                try (OutputStream stream = socket.getOutputStream();){
                    String shutdown = s2.getShutdown();
                    for (int i2 = 0; i2 < shutdown.length(); ++i2) {
                        stream.write(shutdown.charAt(i2));
                    }
                    stream.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (ConnectException ce) {
                log.error(sm.getString("bes.stopServer.connectException", s2.getAddress(), String.valueOf(s2.getPort())));
                log.error("Heaven.stop: ", ce);
                System.exit(1);
            }
            catch (IOException e4) {
                log.error("Heaven.stop: ", e4);
                System.exit(1);
            }
        } else {
            log.error(sm.getString("bes.stopServer"));
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        long t1 = System.nanoTime();
        this.initDirs();
        this.initNaming();
        Digester digester = this.createStartDigester();
        InputSource inputSource = null;
        InputStream inputStream = null;
        File file = null;
        try {
            block39: {
                block38: {
                    block37: {
                        try {
                            file = this.configFile();
                            inputStream = new FileInputStream(file);
                            inputSource = new InputSource(file.toURI().toURL().toString());
                        }
                        catch (Exception e2) {
                            if (!log.isDebugEnabled()) break block37;
                            log.debug(sm.getString("bes.configFail", file), e2);
                        }
                    }
                    if (inputStream == null) {
                        try {
                            inputStream = this.getClass().getClassLoader().getResourceAsStream(this.getConfigFile());
                            inputSource = new InputSource(this.getClass().getClassLoader().getResource(this.getConfigFile()).toString());
                        }
                        catch (Exception e3) {
                            if (!log.isDebugEnabled()) break block38;
                            log.debug(sm.getString("bes.configFail", this.getConfigFile()), e3);
                        }
                    }
                }
                if (inputStream == null) {
                    try {
                        inputStream = this.getClass().getClassLoader().getResourceAsStream("server-embed.xml");
                        inputSource = new InputSource(this.getClass().getClassLoader().getResource("server-embed.xml").toString());
                    }
                    catch (Exception e4) {
                        if (!log.isDebugEnabled()) break block39;
                        log.debug(sm.getString("bes.configFail", "server-embed.xml"), e4);
                    }
                }
            }
            if (inputStream == null || inputSource == null) {
                if (file == null) {
                    log.warn(sm.getString("bes.configFail", this.getConfigFile() + "] or [server-embed.xml]"));
                } else {
                    log.warn(sm.getString("bes.configFail", file.getAbsolutePath()));
                    if (file.exists() && !file.canRead()) {
                        log.warn("Permissions incorrect, read permission is not allowed on the file.");
                    }
                }
                return;
            }
            try {
                inputSource.setByteStream(inputStream);
                digester.push(this);
                digester.parse(inputSource);
            }
            catch (SAXParseException spe) {
                log.warn("Heaven.start using " + this.getConfigFile() + ": " + spe.getMessage());
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            catch (Exception e5) {
                block41: {
                    log.warn("Heaven.start using " + this.getConfigFile() + ": ", e5);
                    if (inputStream == null) break block41;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e4) {}
            }
        }
        this.getServer().setHeaven(this);
        this.getServer().setHeavenHome(ASMain.getHeavenHomeFile());
        this.getServer().setHeavenBase(ASMain.getHeavenBaseFile());
        this.initStreams();
        try {
            this.getServer().init();
        }
        catch (LifecycleException e6) {
            if (Boolean.getBoolean("com.bes.enterprise.startup.ExitOnInitFailure")) {
                throw new Error(e6);
            }
            log.error("Heaven.start", e6);
        }
        long t2 = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info("Initialization processed in " + (t2 - t1) / 1000000L + " ms");
        }
    }

    public void load(String[] args) {
        try {
            if (this.arguments(args)) {
                this.load();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
    }

    public void start() {
        if (this.getServer() == null) {
            this.load();
        }
        if (this.getServer() == null) {
            log.fatal("Cannot start server. Server instance is not configured.");
            return;
        }
        long t1 = System.nanoTime();
        try {
            this.getServer().start();
        }
        catch (LifecycleException e2) {
            log.fatal(sm.getString("bes.serverStartFail"), e2);
            try {
                this.getServer().destroy();
            }
            catch (LifecycleException e1) {
                log.debug("destroy() failed for failed Server ", e1);
            }
            return;
        }
        long t2 = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info("Server startup in " + (t2 - t1) / 1000000L + " ms");
        }
        if (this.useShutdownHook) {
            if (this.shutdownHook == null) {
                this.shutdownHook = new HeavenShutdownHook();
            }
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            LogManager logManager = LogManager.getLogManager();
            if (logManager instanceof ClassLoaderLogManager) {
                ((ClassLoaderLogManager)logManager).setUseShutdownHook(false);
            }
        }
        if (Auth.isLicManager()) {
            LicenseHandler handler = LicenseHandler.getInstance();
            Thread shutdownHookThread = handler.getShutdownHookThread();
            Runtime.getRuntime().addShutdownHook(shutdownHookThread);
        }
        if (this.await) {
            this.await();
            this.stop();
        }
    }

    public void stop() {
        try {
            if (this.useShutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                LogManager logManager = LogManager.getLogManager();
                if (logManager instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)logManager).setUseShutdownHook(true);
                }
            }
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
        }
        try {
            Server s2 = this.getServer();
            LifecycleState state = s2.getState();
            if (LifecycleState.STOPPING_PREP.compareTo(state) > 0 || LifecycleState.DESTROYED.compareTo(state) < 0) {
                s2.stop();
                s2.destroy();
            }
        }
        catch (LifecycleException e2) {
            log.error("Heaven.stop", e2);
        }
    }

    public void await() {
        this.getServer().await();
    }

    protected void usage() {
        System.out.println("usage: java com.bes.enterprise.webtier.startup.Heaven [ -config {pathname} ] [ -nonaming ]  { -help | start | stop }");
    }

    protected void initDirs() {
        String temp = System.getProperty("java.io.tmpdir");
        if (temp == null || !new File(temp).isDirectory()) {
            log.error(sm.getString("embedded.notmp", temp));
        }
    }

    protected void initStreams() {
        if (enableWebtierSystemLogHandler) {
            System.setOut(new SystemLogHandler(System.out));
            System.setErr(new SystemLogHandler(System.err));
        }
    }

    protected void initNaming() {
        if (!this.useNaming) {
            log.info("Heaven naming disabled");
            System.setProperty("bes.useNaming", "false");
        } else {
            System.setProperty("bes.useNaming", "true");
            String value = "com.bes.enterprise.naming";
            String oldValue = System.getProperty("java.naming.factory.url.pkgs");
            if (oldValue != null) {
                value = value + ":" + oldValue;
            }
            System.setProperty("java.naming.factory.url.pkgs", value);
            if (log.isDebugEnabled()) {
                log.debug("Setting naming prefix=" + value);
            }
            if ((value = System.getProperty("java.naming.factory.initial")) == null) {
                System.setProperty("java.naming.factory.initial", "com.bes.enterprise.naming.java.javaURLContextFactory");
            } else {
                log.debug("INITIAL_CONTEXT_FACTORY already set " + value);
            }
        }
    }

    protected void setSecurityProtection() {
        SecurityConfig securityConfig = SecurityConfig.newInstance();
        securityConfig.setPackageDefinition();
        securityConfig.setPackageAccess();
    }

    protected class HeavenShutdownHook
    extends Thread {
        protected HeavenShutdownHook() {
        }

        @Override
        public void run() {
            try {
                if (Heaven.this.getServer() != null) {
                    Heaven.this.stop();
                }
            }
            catch (Throwable ex) {
                ExceptionUtils.handleThrowable(ex);
                log.error(sm.getString("bes.shutdownHookFail"), ex);
            }
            finally {
                LogManager logManager = LogManager.getLogManager();
                if (logManager instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)logManager).shutdown();
                }
            }
        }
    }
}

