/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.startup;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.webtier.startup.ASMain;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class HeavenProperties {
    private static final Log log = LogFactory.getLog(HeavenProperties.class);
    private static Properties properties = null;

    public static String getProperty(String name) {
        return System.getProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        InputStream is = null;
        try {
            String configUrl = System.getProperty("bes.config");
            if (configUrl != null) {
                is = new URL(configUrl).openStream();
            }
        }
        catch (Throwable t2) {
            HeavenProperties.handleThrowable(t2);
        }
        if (is == null) {
            try {
                File home = new File(ASMain.getHeavenBase());
                File conf = new File(home, "conf");
                File propsFile = new File(conf, "server.properties");
                is = new FileInputStream(propsFile);
            }
            catch (Throwable t3) {
                HeavenProperties.handleThrowable(t3);
            }
        }
        if (is == null) {
            try {
                is = HeavenProperties.class.getResourceAsStream("/com/bes/enterprise/webtier/startup/server.properties");
            }
            catch (Throwable t4) {
                HeavenProperties.handleThrowable(t4);
            }
        }
        if (is != null) {
            try {
                properties = new Properties();
                properties.load(is);
            }
            catch (Throwable t5) {
                HeavenProperties.handleThrowable(t5);
                log.warn(t5);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    log.warn("Could not close server.properties", ioe);
                }
            }
        }
        if (is == null) {
            log.warn("Failed to load server.properties");
            properties = new Properties();
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = properties.getProperty(name);
            if (value == null || System.getProperty(name) != null) continue;
            System.setProperty(name, value);
        }
    }

    private static void handleThrowable(Throwable t2) {
        if (t2 instanceof ThreadDeath) {
            throw (ThreadDeath)t2;
        }
        if (t2 instanceof VirtualMachineError) {
            throw (VirtualMachineError)t2;
        }
    }

    static {
        HeavenProperties.loadProperties();
    }
}

