/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.startup;

import com.bes.enterprise.appserver.common.util.FileUtils;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.buf.UriUtil;
import com.bes.enterprise.web.util.descriptor.LocalResolver;
import com.bes.enterprise.web.util.descriptor.besweb.BesWebXml;
import com.bes.enterprise.web.util.digester.Digester;
import com.bes.enterprise.web.util.modeler.Registry;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.web.util.threads.ThreadPoolExecutor;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.DistributedManager;
import com.bes.enterprise.webtier.Globals;
import com.bes.enterprise.webtier.Host;
import com.bes.enterprise.webtier.LifecycleEvent;
import com.bes.enterprise.webtier.LifecycleListener;
import com.bes.enterprise.webtier.Manager;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.core.DefaultHost;
import com.bes.enterprise.webtier.security.DeployXmlPermission;
import com.bes.enterprise.webtier.startup.BesContextRuleSet;
import com.bes.enterprise.webtier.startup.ExpandWar;
import com.bes.enterprise.webtier.startup.FailedContext;
import com.bes.enterprise.webtier.util.ContextName;
import com.bes.enterprise.webtier.util.DeploymentContextUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;

public class HostConfig
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(HostConfig.class);
    protected static final StringManager sm = StringManager.getManager(HostConfig.class);
    protected static final long FILE_MODIFICATION_RESOLUTION_MS = 1000L;
    protected String contextClass = "com.bes.enterprise.webtier.core.DefaultContext";
    protected Host host = null;
    protected ObjectName oname = null;
    protected boolean deployXML = false;
    protected boolean copyXML = false;
    protected boolean unpackWARs = false;
    protected boolean statusFileCreatable = false;
    protected final Map<String, DeployedApplication> deployed = new ConcurrentHashMap<String, DeployedApplication>();
    protected final ArrayList<String> serviced = new ArrayList();
    protected Digester digester = HostConfig.createDigester(this.contextClass);
    private final Object digesterLock = new Object();
    protected final Set<String> invalidWars = new HashSet<String>();
    public static final Map<String, String> BES_WEB_PUBLIC_IDS;
    public static final Map<String, String> BES_WEB_SYSTEM_IDS;

    public String getContextClass() {
        return this.contextClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContextClass(String contextClass) {
        String oldContextClass = this.contextClass;
        this.contextClass = contextClass;
        if (!oldContextClass.equals(contextClass)) {
            Object object = this.digesterLock;
            synchronized (object) {
                this.digester = HostConfig.createDigester(this.getContextClass());
            }
        }
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    private boolean isDeployThisXML(File docBase, ContextName cn) {
        Policy currentPolicy;
        boolean deployThisXML = this.isDeployXML();
        if (Globals.IS_SECURITY_ENABLED && !deployThisXML && (currentPolicy = Policy.getPolicy()) != null) {
            try {
                URL contextRootUrl = docBase.toURI().toURL();
                CodeSource cs = new CodeSource(contextRootUrl, (Certificate[])null);
                PermissionCollection pc = currentPolicy.getPermissions(cs);
                DeployXmlPermission p2 = new DeployXmlPermission(cn.getBaseName());
                if (pc.implies(p2)) {
                    deployThisXML = true;
                }
            }
            catch (MalformedURLException e2) {
                log.warn("hostConfig.docBaseUrlInvalid", e2);
            }
        }
        return deployThisXML;
    }

    public boolean isCopyXML() {
        return this.copyXML;
    }

    public void setCopyXML(boolean copyXML) {
        this.copyXML = copyXML;
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public boolean isStatusFileCreatable() {
        return this.statusFileCreatable;
    }

    public void setStatusFileCreatable(boolean statusFileCreatable) {
        this.statusFileCreatable = statusFileCreatable;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.host = (Host)event.getLifecycle();
            if (this.host instanceof DefaultHost) {
                this.setCopyXML(((DefaultHost)this.host).isCopyXML());
                this.setDeployXML(((DefaultHost)this.host).isDeployXML());
                this.setUnpackWARs(((DefaultHost)this.host).isUnpackWARs());
                this.setContextClass(((DefaultHost)this.host).getContextClass());
            }
        }
        catch (ClassCastException e2) {
            log.error(sm.getString("hostConfig.cce", event.getLifecycle()), e2);
            return;
        }
        if (event.getType().equals("periodic")) {
            this.check();
        } else if (event.getType().equals("before_start")) {
            this.beforeStart();
        } else if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    public synchronized void addServiced(String name) {
        this.serviced.add(name);
    }

    public synchronized boolean isServiced(String name) {
        return this.serviced.contains(name);
    }

    public synchronized void removeServiced(String name) {
        this.serviced.remove(name);
    }

    public long getDeploymentTime(String name) {
        DeployedApplication app = this.deployed.get(name);
        if (app == null) {
            return 0L;
        }
        return app.timestamp;
    }

    public boolean isDeployed(String name) {
        return this.deployed.containsKey(name);
    }

    protected static Digester createDigester(String contextClassName) {
        Digester digester = new Digester();
        digester.setValidating(false);
        LocalResolver resolver = new LocalResolver(BES_WEB_PUBLIC_IDS, BES_WEB_SYSTEM_IDS, true);
        digester.setEntityResolver(resolver);
        digester.addObjectCreate("bes-web-app", contextClassName, "className");
        HashMap fakeAttributes = new HashMap();
        ArrayList<String> attrs = new ArrayList<String>();
        attrs.add("class-name");
        fakeAttributes.put(Object.class, attrs);
        digester.setFakeAttributes(fakeAttributes);
        BesContextRuleSet contextRuleSet = new BesContextRuleSet("");
        digester.addRuleSet(contextRuleSet);
        return digester;
    }

    private static void add(Map<String, String> ids, String id, String location) {
        if (location != null) {
            ids.put(id, location);
        }
    }

    private static String locationFor(String name) {
        URL location = BesWebXml.class.getResource(name);
        return location.toExternalForm();
    }

    protected File returnCanonicalPath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.host.getHeavenBase(), path);
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e2) {
            return file;
        }
    }

    public String getConfigBaseName() {
        return this.host.getConfigBaseFile().getAbsolutePath();
    }

    protected void deployApps() {
        File appBase = this.host.getAppBaseFile();
        File configBase = this.host.getConfigBaseFile();
        String[] filteredAppPaths = this.filterAppPaths(appBase.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.equalsIgnoreCase(".hotdeploystatus");
            }
        }));
        this.deployDescriptors(configBase, configBase.list());
        this.deployWARs(appBase, filteredAppPaths);
        this.deployDirectories(appBase, filteredAppPaths);
    }

    protected String[] filterAppPaths(String[] unfilteredAppPaths) {
        Pattern filter = this.host.getDeployIgnorePattern();
        if (filter == null || unfilteredAppPaths == null) {
            return unfilteredAppPaths;
        }
        ArrayList<String> filteredList = new ArrayList<String>();
        Matcher matcher = null;
        for (String appPath : unfilteredAppPaths) {
            if (matcher == null) {
                matcher = filter.matcher(appPath);
            } else {
                matcher.reset(appPath);
            }
            if (matcher.matches()) {
                if (!log.isDebugEnabled()) continue;
                log.debug(sm.getString("hostConfig.ignorePath", appPath));
                continue;
            }
            filteredList.add(appPath);
        }
        return filteredList.toArray(new String[filteredList.size()]);
    }

    protected void deployApps(String name) {
        File appBase = this.host.getAppBaseFile();
        File configBase = this.host.getConfigBaseFile();
        ContextName cn = new ContextName(name, false);
        String baseName = cn.getBaseName();
        if (this.deploymentExists(cn.getName())) {
            return;
        }
        File xml = new File(configBase, baseName + ".xml");
        if (xml.exists()) {
            this.deployDescriptor(cn, xml);
            return;
        }
        File war = new File(appBase, baseName + ".war");
        if (war.exists()) {
            this.deployWAR(cn, war);
            return;
        }
        File dir = new File(appBase, baseName);
        if (dir.exists()) {
            this.deployDirectory(cn, dir);
        }
    }

    protected void deployDescriptors(File configBase, String[] files) {
        if (files == null) {
            return;
        }
        ExecutorService es = this.host.getStartStopExecutor();
        ArrayList results = new ArrayList();
        for (int i2 = 0; i2 < files.length; ++i2) {
            ContextName cn;
            File file = new File(configBase, files[i2]);
            if (!files[i2].toLowerCase(Locale.ENGLISH).endsWith(".xml") || this.isServiced((cn = new ContextName(files[i2], true)).getName()) || this.deploymentExists(cn.getName())) continue;
            results.add(es.submit(new DeployDescriptor(this, cn, file)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (Exception e2) {
                log.error(sm.getString("hostConfig.deployDescriptor.threaded.error"), e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployDescriptor(ContextName cn, File contextXml) {
        DeployedApplication deployedApp = new DeployedApplication(cn.getName(), true, this.isStatusFileCreatable());
        long startTime = 0L;
        if (log.isInfoEnabled()) {
            startTime = System.currentTimeMillis();
            log.info(sm.getString("hostConfig.deployDescriptor", contextXml.getAbsolutePath()));
        }
        Context context = null;
        boolean isExternalWar = false;
        boolean isExternal = false;
        File expandedDocBase = null;
        try (FileInputStream fis = new FileInputStream(contextXml);){
            Object object = this.digesterLock;
            synchronized (object) {
                try {
                    context = (Context)this.digester.parse(fis);
                }
                catch (Exception e2) {
                    log.error(sm.getString("hostConfig.deployDescriptor.error", contextXml.getAbsolutePath()), e2);
                }
                finally {
                    this.digester.reset();
                    if (context == null) {
                        context = new FailedContext();
                    }
                }
            }
            Class<?> clazz = Class.forName(this.host.getConfigClass());
            LifecycleListener listener = (LifecycleListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            context.addLifecycleListener(listener);
            context.setConfigFile(contextXml.toURI().toURL());
            context.setName(cn.getName());
            context.setPath(cn.getPath());
            context.setWebappVersion(cn.getVersion());
            if (context.getDocBase() != null) {
                File docBase = new File(context.getDocBase());
                if (!docBase.isAbsolute()) {
                    docBase = new File(this.host.getAppBaseFile(), context.getDocBase());
                }
                if (!docBase.getCanonicalFile().toPath().startsWith(this.host.getAppBaseFile().toPath())) {
                    isExternal = true;
                    deployedApp.addRedeployResource(contextXml.getAbsolutePath(), contextXml.lastModified());
                    deployedApp.addRedeployResource(docBase.getAbsolutePath(), docBase.lastModified());
                    if (docBase.getAbsolutePath().toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                        isExternalWar = true;
                    }
                } else {
                    log.warn(sm.getString("hostConfig.deployDescriptor.localDocBaseSpecified", docBase));
                    context.setDocBase(null);
                }
            }
            this.host.addChild(context);
            this.setAppStatusFileResource(deployedApp, contextXml);
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            log.error(sm.getString("hostConfig.deployDescriptor.error", contextXml.getAbsolutePath()), t2);
        }
        finally {
            boolean unpackWAR;
            expandedDocBase = new File(this.host.getAppBaseFile(), cn.getBaseName());
            if (context.getDocBase() != null && !context.getDocBase().toLowerCase(Locale.ENGLISH).endsWith(".war") && !(expandedDocBase = new File(context.getDocBase())).isAbsolute()) {
                expandedDocBase = new File(this.host.getAppBaseFile(), context.getDocBase());
            }
            if ((unpackWAR = this.unpackWARs) && context instanceof DefaultContext) {
                unpackWAR = ((DefaultContext)context).getUnpackWAR();
            }
            if (isExternalWar) {
                if (unpackWAR) {
                    deployedApp.addRedeployResource(expandedDocBase.getAbsolutePath(), expandedDocBase.lastModified());
                    this.addWatchedResources(deployedApp, expandedDocBase.getAbsolutePath(), context);
                } else {
                    this.addWatchedResources(deployedApp, null, context);
                }
            } else {
                if (!isExternal) {
                    File warDocBase = new File(expandedDocBase.getAbsolutePath() + ".war");
                    if (warDocBase.exists()) {
                        deployedApp.addRedeployResource(warDocBase.getAbsolutePath(), warDocBase.lastModified());
                    } else {
                        deployedApp.addRedeployResource(warDocBase.getAbsolutePath(), 0L);
                    }
                }
                if (unpackWAR) {
                    deployedApp.addRedeployResource(expandedDocBase.getAbsolutePath(), expandedDocBase.lastModified());
                    this.addWatchedResources(deployedApp, expandedDocBase.getAbsolutePath(), context);
                } else {
                    this.addWatchedResources(deployedApp, null, context);
                }
                if (!isExternal) {
                    deployedApp.addRedeployResource(contextXml.getAbsolutePath(), contextXml.lastModified());
                }
            }
            this.addGlobalRedeployResources(deployedApp);
        }
        if (this.host.findChild(context.getName()) != null) {
            this.deployed.put(context.getName(), deployedApp);
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("hostConfig.deployDescriptor.finished", contextXml.getAbsolutePath(), System.currentTimeMillis() - startTime));
        }
    }

    protected void deployWARs(File appBase, String[] files) {
        if (files == null) {
            return;
        }
        ExecutorService es = this.host.getStartStopExecutor();
        ArrayList results = new ArrayList();
        for (int i2 = 0; i2 < files.length; ++i2) {
            ContextName cn;
            if (files[i2].equalsIgnoreCase("META-INF") || files[i2].equalsIgnoreCase("WEB-INF")) continue;
            File file = new File(appBase, files[i2]);
            if (!files[i2].toLowerCase(Locale.ENGLISH).endsWith(".war") || !file.isFile() || this.invalidWars.contains(files[i2]) || DeploymentContextUtils.getWebModule(files[i2]) != null || DeploymentContextUtils.getWebModule(FileUtils.getFileName((String)files[i2])) != null || this.isServiced((cn = new ContextName(files[i2], true)).getName())) continue;
            if (this.deploymentExists(cn.getName())) {
                DeployedApplication app = this.deployed.get(cn.getName());
                boolean unpackWAR = this.unpackWARs;
                if (unpackWAR && this.host.findChild(cn.getName()) instanceof DefaultContext) {
                    unpackWAR = ((DefaultContext)this.host.findChild(cn.getName())).getUnpackWAR();
                }
                if (unpackWAR || app == null) continue;
                File dir = new File(appBase, cn.getBaseName());
                if (dir.exists()) {
                    if (app.loggedDirWarning) continue;
                    log.warn(sm.getString("hostConfig.deployWar.hiddenDir", dir.getAbsoluteFile(), file.getAbsoluteFile()));
                    app.loggedDirWarning = true;
                    continue;
                }
                app.loggedDirWarning = false;
                continue;
            }
            if (!this.validateContextPath(appBase, cn.getBaseName())) {
                log.error(sm.getString("hostConfig.illegalWarName", files[i2]));
                this.invalidWars.add(files[i2]);
                continue;
            }
            results.add(es.submit(new DeployWar(this, cn, file)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (Exception e2) {
                log.error(sm.getString("hostConfig.deployWar.threaded.error"), e2);
            }
        }
    }

    private boolean validateContextPath(File appBase, String contextPath) {
        StringBuilder docBase;
        String canonicalDocBase = null;
        try {
            String canonicalAppBase = appBase.getCanonicalPath();
            docBase = new StringBuilder(canonicalAppBase);
            if (canonicalAppBase.endsWith(File.separator)) {
                docBase.append(contextPath.substring(1).replace('/', File.separatorChar));
            } else {
                docBase.append(contextPath.replace('/', File.separatorChar));
            }
            canonicalDocBase = new File(docBase.toString()).getCanonicalPath();
            if (canonicalDocBase.endsWith(File.separator)) {
                docBase.append(File.separator);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return canonicalDocBase.equals(docBase.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployWAR(ContextName cn, File war) {
        Throwable throwable;
        InputStream istream;
        JarEntry entry3;
        Throwable throwable2;
        JarFile jar;
        boolean deployThisXML;
        Context context;
        boolean xmlInWar;
        File xml;
        block138: {
            xml = new File(this.host.getAppBaseFile(), cn.getBaseName() + "/" + "WEB-INF/bes-web.xml");
            File warTracker = new File(this.host.getAppBaseFile(), cn.getBaseName() + "/META-INF/war-tracker");
            xmlInWar = false;
            try (JarFile jar22 = new JarFile(war);){
                JarEntry entry2 = jar22.getJarEntry("WEB-INF/bes-web.xml");
                if (entry2 != null) {
                    xmlInWar = true;
                }
            }
            catch (IOException jar22) {
                // empty catch block
            }
            boolean useXml = false;
            if (xml.exists() && this.unpackWARs && (!warTracker.exists() || warTracker.lastModified() == war.lastModified())) {
                useXml = true;
            }
            context = null;
            deployThisXML = this.isDeployThisXML(war, cn);
            try {
                Object object;
                if (deployThisXML && useXml && !this.copyXML) {
                    object = this.digesterLock;
                    synchronized (object) {
                        try {
                            context = (Context)this.digester.parse(xml);
                        }
                        catch (Exception e2) {
                            log.error(sm.getString("hostConfig.deployDescriptor.error", war.getAbsolutePath()), e2);
                        }
                        finally {
                            this.digester.reset();
                            if (context == null) {
                                context = new FailedContext();
                            }
                        }
                    }
                    context.setConfigFile(xml.toURI().toURL());
                    break block138;
                }
                if (deployThisXML && xmlInWar) {
                    object = this.digesterLock;
                    synchronized (object) {
                        try {
                            jar = new JarFile(war);
                            throwable2 = null;
                            try {
                                entry3 = jar.getJarEntry("WEB-INF/bes-web.xml");
                                istream = jar.getInputStream(entry3);
                                throwable = null;
                                try {
                                    context = (Context)this.digester.parse(istream);
                                }
                                catch (Throwable throwable3) {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (istream != null) {
                                        if (throwable != null) {
                                            try {
                                                istream.close();
                                            }
                                            catch (Throwable throwable4) {
                                                throwable.addSuppressed(throwable4);
                                            }
                                        } else {
                                            istream.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable entry3) {
                                throwable2 = entry3;
                                throw entry3;
                            }
                            finally {
                                if (jar != null) {
                                    if (throwable2 != null) {
                                        try {
                                            jar.close();
                                        }
                                        catch (Throwable entry3) {
                                            throwable2.addSuppressed(entry3);
                                        }
                                    } else {
                                        jar.close();
                                    }
                                }
                            }
                        }
                        catch (Exception e3) {
                            log.error(sm.getString("hostConfig.deployDescriptor.error", war.getAbsolutePath()), e3);
                        }
                        finally {
                            this.digester.reset();
                            if (context == null) {
                                context = new FailedContext();
                            }
                            context.setConfigFile(UriUtil.buildJarUrl(war, "WEB-INF/bes-web.xml"));
                        }
                        break block138;
                    }
                }
                if (!deployThisXML && xmlInWar) {
                    log.error(sm.getString("hostConfig.deployDescriptor.blocked", cn.getPath(), "WEB-INF/bes-web.xml", new File(this.host.getConfigBaseFile(), cn.getBaseName() + ".xml")));
                } else {
                    context = (Context)Class.forName(this.contextClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Throwable t2) {
                ExceptionUtils.handleThrowable(t2);
                log.error(sm.getString("hostConfig.deployWar.error", war.getAbsolutePath()), t2);
            }
            finally {
                if (context == null) {
                    context = new FailedContext();
                }
            }
        }
        boolean copyThisXml = false;
        if (deployThisXML) {
            if (this.host instanceof DefaultHost) {
                copyThisXml = ((DefaultHost)this.host).isCopyXML();
            }
            if (!copyThisXml && context instanceof DefaultContext) {
                copyThisXml = ((DefaultContext)context).getCopyXML();
            }
            if (xmlInWar && copyThisXml) {
                xml = new File(this.host.getConfigBaseFile(), cn.getBaseName() + ".xml");
                try {
                    jar = new JarFile(war);
                    throwable2 = null;
                    try {
                        entry3 = jar.getJarEntry("WEB-INF/bes-web.xml");
                        istream = jar.getInputStream(entry3);
                        throwable = null;
                        try (FileOutputStream fos = new FileOutputStream(xml);
                             BufferedOutputStream ostream = new BufferedOutputStream(fos, 1024);){
                            int n2;
                            byte[] buffer = new byte[1024];
                            while ((n2 = istream.read(buffer)) >= 0) {
                                ostream.write(buffer, 0, n2);
                            }
                            ostream.flush();
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (istream != null) {
                                if (throwable != null) {
                                    try {
                                        istream.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    istream.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable2 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (jar != null) {
                            if (throwable2 != null) {
                                try {
                                    jar.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable2.addSuppressed(throwable8);
                                }
                            } else {
                                jar.close();
                            }
                        }
                    }
                }
                catch (IOException jar3) {
                    // empty catch block
                }
            }
        }
        DeployedApplication deployedApp = new DeployedApplication(cn.getName(), xml.exists() && deployThisXML && copyThisXml, this.isStatusFileCreatable());
        long startTime = 0L;
        if (log.isInfoEnabled()) {
            startTime = System.currentTimeMillis();
            log.info(sm.getString("hostConfig.deployWar", war.getAbsolutePath()));
        }
        try {
            deployedApp.addRedeployResource(war.getAbsolutePath(), war.lastModified());
            if (deployThisXML && xml.exists() && copyThisXml) {
                deployedApp.addRedeployResource(xml.getAbsolutePath(), xml.lastModified());
            } else {
                deployedApp.addRedeployResource(new File(this.host.getConfigBaseFile(), cn.getBaseName() + ".xml").getAbsolutePath(), 0L);
            }
            Class<?> clazz = Class.forName(this.host.getConfigClass());
            LifecycleListener listener = (LifecycleListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            context.addLifecycleListener(listener);
            context.setName(cn.getName());
            context.setPath(cn.getPath());
            context.setWebappVersion(cn.getVersion());
            context.setDocBase(cn.getBaseName() + ".war");
            this.host.addChild(context);
            this.setAppStatusFileResource(deployedApp, war);
        }
        catch (Throwable t3) {
            ExceptionUtils.handleThrowable(t3);
            log.error(sm.getString("hostConfig.deployWar.error", war.getAbsolutePath()), t3);
        }
        finally {
            boolean unpackWAR = this.unpackWARs;
            if (unpackWAR && context instanceof DefaultContext) {
                unpackWAR = ((DefaultContext)context).getUnpackWAR();
            }
            if (unpackWAR && context.getDocBase() != null) {
                File docBase = new File(this.host.getAppBaseFile(), cn.getBaseName());
                deployedApp.addRedeployResource(docBase.getAbsolutePath(), docBase.lastModified());
                this.addWatchedResources(deployedApp, docBase.getAbsolutePath(), context);
                if (deployThisXML && !copyThisXml && (xmlInWar || xml.exists())) {
                    deployedApp.addRedeployResource(xml.getAbsolutePath(), xml.lastModified());
                }
            } else {
                this.addWatchedResources(deployedApp, null, context);
            }
            this.addGlobalRedeployResources(deployedApp);
        }
        this.deployed.put(cn.getName(), deployedApp);
        if (log.isInfoEnabled()) {
            log.info(sm.getString("hostConfig.deployWar.finished", war.getAbsolutePath(), System.currentTimeMillis() - startTime));
        }
    }

    protected void deployDirectories(File appBase, String[] files) {
        if (files == null) {
            return;
        }
        ExecutorService es = this.host.getStartStopExecutor();
        ArrayList results = new ArrayList();
        for (int i2 = 0; i2 < files.length; ++i2) {
            ContextName cn;
            File file;
            if (files[i2].equalsIgnoreCase("META-INF") || files[i2].equalsIgnoreCase("WEB-INF") || !(file = new File(appBase, files[i2])).isDirectory() || DeploymentContextUtils.getWebModule(files[i2]) != null || this.isServiced((cn = new ContextName(files[i2], false)).getName()) || this.deploymentExists(cn.getName())) continue;
            results.add(es.submit(new DeployDirectory(this, cn, file)));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (Exception e2) {
                log.error(sm.getString("hostConfig.deployDir.threaded.error"), e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployDirectory(ContextName cn, File dir) {
        DeployedApplication deployedApp;
        long startTime = 0L;
        if (log.isInfoEnabled()) {
            startTime = System.currentTimeMillis();
            log.info(sm.getString("hostConfig.deployDir", dir.getAbsolutePath()));
        }
        Context context = null;
        File xml = new File(dir, "WEB-INF/bes-web.xml");
        File xmlCopy = new File(this.host.getConfigBaseFile(), cn.getBaseName() + ".xml");
        boolean copyThisXml = this.isCopyXML();
        boolean deployThisXML = this.isDeployThisXML(dir, cn);
        try {
            if (deployThisXML && xml.exists()) {
                Object object = this.digesterLock;
                synchronized (object) {
                    try {
                        context = (Context)this.digester.parse(xml);
                    }
                    catch (Exception e2) {
                        log.error(sm.getString("hostConfig.deployDescriptor.error", xml), e2);
                        context = new FailedContext();
                    }
                    finally {
                        this.digester.reset();
                        if (context == null) {
                            context = new FailedContext();
                        }
                    }
                }
                if (!copyThisXml && context instanceof DefaultContext) {
                    copyThisXml = ((DefaultContext)context).getCopyXML();
                }
                if (copyThisXml) {
                    Files.copy(xml.toPath(), xmlCopy.toPath(), new CopyOption[0]);
                    context.setConfigFile(xmlCopy.toURI().toURL());
                } else {
                    context.setConfigFile(xml.toURI().toURL());
                }
            } else if (!deployThisXML && xml.exists()) {
                log.error(sm.getString("hostConfig.deployDescriptor.blocked", cn.getPath(), xml, xmlCopy));
                context = new FailedContext();
            } else {
                context = (Context)Class.forName(this.contextClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Class<?> clazz = Class.forName(this.host.getConfigClass());
            LifecycleListener listener = (LifecycleListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            context.addLifecycleListener(listener);
            context.setName(cn.getName());
            context.setPath(cn.getPath());
            context.setWebappVersion(cn.getVersion());
            context.setDocBase(cn.getBaseName());
            this.host.addChild(context);
            deployedApp = new DeployedApplication(cn.getName(), xml.exists() && deployThisXML && copyThisXml, this.isStatusFileCreatable());
            deployedApp.addRedeployResource(dir.getAbsolutePath() + ".war", 0L);
            deployedApp.addRedeployResource(dir.getAbsolutePath(), dir.lastModified());
            if (deployThisXML && xml.exists()) {
                if (copyThisXml) {
                    deployedApp.addRedeployResource(xmlCopy.getAbsolutePath(), xmlCopy.lastModified());
                } else {
                    deployedApp.addRedeployResource(xml.getAbsolutePath(), xml.lastModified());
                    deployedApp.addRedeployResource(xmlCopy.getAbsolutePath(), 0L);
                }
            } else {
                deployedApp.addRedeployResource(xmlCopy.getAbsolutePath(), 0L);
                if (!xml.exists()) {
                    deployedApp.addRedeployResource(xml.getAbsolutePath(), 0L);
                }
            }
            this.addWatchedResources(deployedApp, dir.getAbsolutePath(), context);
            this.addGlobalRedeployResources(deployedApp);
        }
        catch (Throwable t2) {
            try {
                ExceptionUtils.handleThrowable(t2);
                log.error(sm.getString("hostConfig.deployDir.error", dir.getAbsolutePath()), t2);
                deployedApp = new DeployedApplication(cn.getName(), xml.exists() && deployThisXML && copyThisXml, this.isStatusFileCreatable());
                deployedApp.addRedeployResource(dir.getAbsolutePath() + ".war", 0L);
                deployedApp.addRedeployResource(dir.getAbsolutePath(), dir.lastModified());
                if (deployThisXML && xml.exists()) {
                    if (copyThisXml) {
                        deployedApp.addRedeployResource(xmlCopy.getAbsolutePath(), xmlCopy.lastModified());
                    } else {
                        deployedApp.addRedeployResource(xml.getAbsolutePath(), xml.lastModified());
                        deployedApp.addRedeployResource(xmlCopy.getAbsolutePath(), 0L);
                    }
                } else {
                    deployedApp.addRedeployResource(xmlCopy.getAbsolutePath(), 0L);
                    if (!xml.exists()) {
                        deployedApp.addRedeployResource(xml.getAbsolutePath(), 0L);
                    }
                }
                this.addWatchedResources(deployedApp, dir.getAbsolutePath(), context);
                this.addGlobalRedeployResources(deployedApp);
            }
            catch (Throwable throwable) {
                DeployedApplication deployedApp2 = new DeployedApplication(cn.getName(), xml.exists() && deployThisXML && copyThisXml, this.isStatusFileCreatable());
                deployedApp2.addRedeployResource(dir.getAbsolutePath() + ".war", 0L);
                deployedApp2.addRedeployResource(dir.getAbsolutePath(), dir.lastModified());
                if (deployThisXML && xml.exists()) {
                    if (copyThisXml) {
                        deployedApp2.addRedeployResource(xmlCopy.getAbsolutePath(), xmlCopy.lastModified());
                    } else {
                        deployedApp2.addRedeployResource(xml.getAbsolutePath(), xml.lastModified());
                        deployedApp2.addRedeployResource(xmlCopy.getAbsolutePath(), 0L);
                    }
                } else {
                    deployedApp2.addRedeployResource(xmlCopy.getAbsolutePath(), 0L);
                    if (!xml.exists()) {
                        deployedApp2.addRedeployResource(xml.getAbsolutePath(), 0L);
                    }
                }
                this.addWatchedResources(deployedApp2, dir.getAbsolutePath(), context);
                this.addGlobalRedeployResources(deployedApp2);
                throw throwable;
            }
        }
        try {
            this.setAppStatusFileResource(deployedApp, dir);
        }
        catch (Throwable t3) {
            ExceptionUtils.handleThrowable(t3);
            log.error(sm.getString("hostConfig.deployDir.error", dir.getAbsolutePath()), t3);
        }
        this.deployed.put(cn.getName(), deployedApp);
        if (log.isInfoEnabled()) {
            log.info(sm.getString("hostConfig.deployDir.finished", dir.getAbsolutePath(), System.currentTimeMillis() - startTime));
        }
    }

    protected boolean deploymentExists(String contextName) {
        return this.deployed.containsKey(contextName) || this.host.findChild(contextName) != null;
    }

    protected void addWatchedResources(DeployedApplication app, String docBase, Context context) {
        DomTemplate hotDeployConfig;
        File docBaseFile = null;
        if (docBase != null && !(docBaseFile = new File(docBase)).isAbsolute()) {
            docBaseFile = new File(this.host.getAppBaseFile(), docBase);
        }
        String[] watchedResources = context.findWatchedResources();
        ArrayList<File> realResourceFiles = new ArrayList<File>();
        if (watchedResources.length == 0 && (hotDeployConfig = DeploymentContextUtils.getHotDeployConfig()) != null) {
            String hotDeployWatchResource = hotDeployConfig.getAttribute("watched-resources");
            watchedResources = new String[]{hotDeployWatchResource};
        }
        for (String watchedResource : watchedResources) {
            File resource = new File(watchedResource);
            if (!resource.isAbsolute()) {
                if (docBase == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Ignoring non-existent WatchedResource '" + resource.getAbsolutePath() + "'");
                    continue;
                }
                resource = new File(docBaseFile, watchedResource);
            }
            if (this.matchWildcard(resource, realResourceFiles)) continue;
            realResourceFiles.add(resource);
        }
        for (File resource : realResourceFiles) {
            if (log.isDebugEnabled()) {
                log.debug("Watching WatchedResource '" + resource.getAbsolutePath() + "'");
            }
            app.addReloadResource(resource.getAbsolutePath(), resource.lastModified());
        }
    }

    private boolean matchWildcard(File resource, List<File> realResourceFiles) {
        String filename = resource.getName();
        int wildcardIndex = filename.indexOf("*");
        if (wildcardIndex > -1) {
            File[] files = resource.getParentFile().listFiles();
            if (files != null) {
                if (filename.length() == 1) {
                    for (File file : files) {
                        this.listAllFiles(file, realResourceFiles);
                    }
                } else {
                    String prefix = filename.substring(0, wildcardIndex);
                    String suffix = filename.substring(wildcardIndex + 1);
                    for (File file : files) {
                        if (!file.getName().startsWith(prefix) || !file.getName().endsWith(suffix)) continue;
                        realResourceFiles.add(file);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void listAllFiles(File currentFile, List<File> results) {
        if (currentFile.isDirectory()) {
            for (File file : currentFile.listFiles()) {
                this.listAllFiles(file, results);
            }
        }
        results.add(currentFile);
    }

    protected void addGlobalRedeployResources(DeployedApplication app) {
        File globalContextXml;
        File hostContextXml = new File(this.getConfigBaseName(), "context.xml.default");
        if (hostContextXml.isFile()) {
            app.redeployResources.put(hostContextXml.getAbsolutePath(), hostContextXml.lastModified());
        }
        if ((globalContextXml = this.returnCanonicalPath("conf/context.xml")).isFile()) {
            app.redeployResources.put(globalContextXml.getAbsolutePath(), globalContextXml.lastModified());
        }
    }

    protected void setAppStatusFileResource(DeployedApplication app, File orignalFile) throws Exception {
        String fileName;
        File appStatusFile;
        if (!this.statusFileCreatable) {
            return;
        }
        File statusDir = new File(this.host.getAppBaseFile(), ".hotdeploystatus");
        if (!statusDir.exists()) {
            statusDir.mkdirs();
        }
        if (!(appStatusFile = new File(statusDir, fileName = orignalFile.getName())).exists()) {
            appStatusFile.createNewFile();
        }
        appStatusFile.setLastModified(orignalFile.lastModified());
        app.addAppStatusFileResource(appStatusFile.getAbsolutePath(), appStatusFile.lastModified());
    }

    protected synchronized void checkResources(DeployedApplication app, boolean skipFileModificationResolutionCheck) {
        String[] resources = app.getRedeployResources().keySet().toArray(new String[0]);
        long currentTimeWithResolutionOffset = System.currentTimeMillis() - 1000L;
        for (int i2 = 0; i2 < resources.length; ++i2) {
            File resource = new File(resources[i2]);
            if (log.isDebugEnabled()) {
                log.debug("Checking context[" + app.name + "] redeploy resource " + resource);
            }
            long lastModified = app.getRedeployResources().get(resources[i2]);
            if (resource.exists() || lastModified == 0L) {
                if (resource.lastModified() == lastModified || this.host.getAutoDeploy() && resource.lastModified() >= currentTimeWithResolutionOffset && !skipFileModificationResolutionCheck) continue;
                if (resource.isDirectory()) {
                    app.getRedeployResources().put(resources[i2], resource.lastModified());
                    continue;
                }
                if (app.hasDescriptor && resource.getName().toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                    Context context = (Context)this.host.findChild(app.name);
                    String docBase = context.getDocBase();
                    if (!docBase.toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                        File docBaseFile = new File(docBase);
                        if (!docBaseFile.isAbsolute()) {
                            docBaseFile = new File(this.host.getAppBaseFile(), docBase);
                        }
                        this.reload(app, docBaseFile, resource.getAbsolutePath());
                    } else {
                        this.reload(app, null, null);
                    }
                    app.getRedeployResources().put(resources[i2], resource.lastModified());
                    app.timestamp = System.currentTimeMillis();
                    boolean unpackWAR = this.unpackWARs;
                    if (unpackWAR && context instanceof DefaultContext) {
                        unpackWAR = ((DefaultContext)context).getUnpackWAR();
                    }
                    if (unpackWAR) {
                        this.addWatchedResources(app, context.getDocBase(), context);
                    } else {
                        this.addWatchedResources(app, null, context);
                    }
                    return;
                }
                this.undeploy(app);
                this.deleteRedeployResources(app, resources, i2, false);
                return;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException context) {
                // empty catch block
            }
            if (resource.exists()) continue;
            this.undeploy(app);
            this.deleteRedeployResources(app, resources, i2, true);
            return;
        }
        resources = app.getReloadResources().keySet().toArray(new String[0]);
        boolean update = false;
        for (String resource : resources) {
            File resourceFile = new File(resource);
            if (log.isDebugEnabled()) {
                log.debug("Checking context[" + app.name + "] reload resource " + resourceFile);
            }
            long lastModified = app.getReloadResources().get(resource);
            if (resourceFile.lastModified() != lastModified && (!this.host.getAutoDeploy() || resourceFile.lastModified() < currentTimeWithResolutionOffset || skipFileModificationResolutionCheck) || update) {
                if (!update) {
                    this.reload(app, null, null);
                    update = true;
                }
                app.addReloadResource(resource, resourceFile.lastModified());
            }
            app.timestamp = System.currentTimeMillis();
        }
    }

    private void reload(DeployedApplication app, File fileToRemove, String newDocBase) {
        Context context;
        if (log.isInfoEnabled()) {
            log.info(sm.getString("hostConfig.reload", app.name));
        }
        if ((context = (Context)this.host.findChild(app.name)).getState().isAvailable()) {
            if (fileToRemove != null && newDocBase != null) {
                context.addLifecycleListener(new ExpandedDirectoryRemovalListener(fileToRemove, newDocBase));
            }
            context.reload();
        } else {
            if (fileToRemove != null && newDocBase != null) {
                ExpandWar.delete(fileToRemove);
                context.setDocBase(newDocBase);
            }
            try {
                context.start();
            }
            catch (Exception e2) {
                log.error(sm.getString("hostConfig.context.restart", app.name), e2);
            }
        }
    }

    private void stopUndeployThreads() {
        ExecutorService startStopExecutor = this.host.getStartStopExecutor();
        if (startStopExecutor instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)startStopExecutor).contextStopping();
        }
    }

    private void undeploy(DeployedApplication app) {
        ExecutorService startStopExecutor = this.host.getStartStopExecutor();
        Future<?> result = startStopExecutor.submit(new UnDeploy(this, app));
        try {
            result.get();
        }
        catch (InterruptedException e2) {
            log.warn(sm.getString("hostConfig.context.remove", app.name), e2);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        this.stopUndeployThreads();
    }

    private void doUndeploy(DeployedApplication app) {
        if (log.isInfoEnabled()) {
            log.info(sm.getString("hostConfig.undeploy", app.name));
        }
        Container context = this.host.findChild(app.name);
        try {
            this.host.removeChild(context);
            if (log.isInfoEnabled()) {
                log.info(sm.getString("hostConfig.undeployed", app.name));
            }
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            log.warn(sm.getString("hostConfig.context.remove", app.name), t2);
        }
        this.deployed.remove(app.name);
    }

    private void deleteRedeployResources(DeployedApplication app, String[] resources, int i2, boolean deleteReloadResources) {
        File current;
        if (app.statusFileCreatable && deleteReloadResources) {
            for (String resourcePath : app.getResourcePath()) {
                current = new File(resourcePath);
                if ("context.xml.default".equals(current.getName()) || !this.isDeletableResource(app, current)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Delete " + current);
                }
                ExpandWar.delete(current);
            }
        }
        for (int j2 = i2 + 1; j2 < resources.length; ++j2) {
            File current2 = new File(resources[j2]);
            if ("context.xml.default".equals(current2.getName()) || !this.isDeletableResource(app, current2)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Delete " + current2);
            }
            ExpandWar.delete(current2);
        }
        if (deleteReloadResources) {
            String[] resources2 = app.getReloadResources().keySet().toArray(new String[0]);
            for (int j3 = 0; j3 < resources2.length; ++j3) {
                current = new File(resources2[j3]);
                if ("context.xml.default".equals(current.getName()) || !this.isDeletableResource(app, current)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Delete " + current);
                }
                ExpandWar.delete(current);
            }
        }
    }

    private boolean isDeletableResource(DeployedApplication app, File resource) {
        String canonicalConfigBase;
        String canonicalAppBase;
        String canonicalLocation;
        if (!resource.isAbsolute()) {
            log.warn(sm.getString("hostConfig.resourceNotAbsolute", app.name, resource));
            return false;
        }
        try {
            canonicalLocation = resource.getParentFile().getCanonicalPath();
        }
        catch (IOException e2) {
            log.warn(sm.getString("hostConfig.canonicalizing", resource.getParentFile(), app.name), e2);
            return false;
        }
        try {
            canonicalAppBase = this.host.getAppBaseFile().getCanonicalPath();
        }
        catch (IOException e3) {
            log.warn(sm.getString("hostConfig.canonicalizing", this.host.getAppBaseFile(), app.name), e3);
            return false;
        }
        if (canonicalLocation.equals(canonicalAppBase)) {
            return true;
        }
        try {
            canonicalConfigBase = this.host.getConfigBaseFile().getCanonicalPath();
        }
        catch (IOException e4) {
            log.warn(sm.getString("hostConfig.canonicalizing", this.host.getConfigBaseFile(), app.name), e4);
            return false;
        }
        return canonicalLocation.equals(canonicalConfigBase) && resource.getName().endsWith(".xml");
    }

    public void beforeStart() {
        if (this.host.getCreateDirs()) {
            File[] dirs = new File[]{this.host.getAppBaseFile(), this.host.getConfigBaseFile()};
            for (int i2 = 0; i2 < dirs.length; ++i2) {
                if (dirs[i2].mkdirs() || dirs[i2].isDirectory()) continue;
                log.error(sm.getString("hostConfig.createDirs", dirs[i2]));
            }
        }
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("hostConfig.start"));
        }
        try {
            ObjectName hostON = this.host.getObjectName();
            this.oname = new ObjectName(hostON.getDomain() + ":type=Deployer,host=" + this.host.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, this.getClass().getName());
        }
        catch (Exception e2) {
            log.warn(sm.getString("hostConfig.jmx.register", this.oname), e2);
        }
        if (!this.host.getAppBaseFile().isDirectory()) {
            log.error(sm.getString("hostConfig.appBase", this.host.getName(), this.host.getAppBaseFile().getPath()));
            this.host.setDeployOnStartup(false);
            this.host.setAutoDeploy(false);
        }
        if (this.host.getDeployOnStartup()) {
            this.deployApps();
        }
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("hostConfig.stop"));
        }
        if (this.oname != null) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
            }
            catch (Exception e2) {
                log.warn(sm.getString("hostConfig.jmx.unregister", this.oname), e2);
            }
        }
        this.oname = null;
    }

    protected void check() {
        if (this.host.getAutoDeploy()) {
            DeployedApplication[] apps = this.deployed.values().toArray(new DeployedApplication[0]);
            for (int i2 = 0; i2 < apps.length; ++i2) {
                if (this.isServiced(apps[i2].name)) continue;
                this.checkResources(apps[i2], false);
            }
            if (this.host.getUndeployOldVersions()) {
                this.checkUndeploy();
            }
            this.deployApps();
        }
    }

    public void check(String name) {
        DeployedApplication app = this.deployed.get(name);
        if (app != null) {
            this.checkResources(app, true);
        }
        this.deployApps(name);
    }

    public synchronized void checkUndeploy() {
        if (this.deployed.size() < 2) {
            return;
        }
        TreeSet<String> sortedAppNames = new TreeSet<String>();
        sortedAppNames.addAll(this.deployed.keySet());
        Iterator iter = sortedAppNames.iterator();
        ContextName previous = new ContextName((String)iter.next(), false);
        do {
            ContextName current;
            if ((current = new ContextName((String)iter.next(), false)).getPath().equals(previous.getPath())) {
                int sessionCount;
                Manager manager;
                Context previousContext = (Context)this.host.findChild(previous.getName());
                Context currentContext = (Context)this.host.findChild(current.getName());
                if (previousContext != null && currentContext != null && currentContext.getState().isAvailable() && !this.isServiced(previous.getName()) && (manager = previousContext.getManager()) != null && (sessionCount = manager instanceof DistributedManager ? ((DistributedManager)((Object)manager)).getActiveSessionsFull() : manager.getActiveSessions()) == 0) {
                    if (log.isInfoEnabled()) {
                        log.info(sm.getString("hostConfig.undeployVersion", previous.getName()));
                    }
                    DeployedApplication app = this.deployed.get(previous.getName());
                    String[] resources = app.getRedeployResources().keySet().toArray(new String[0]);
                    this.undeploy(app);
                    this.deleteRedeployResources(app, resources, -1, true);
                }
            }
            previous = current;
        } while (iter.hasNext());
    }

    public void manageApp(Context context) {
        String contextName = context.getName();
        if (this.deployed.containsKey(contextName)) {
            return;
        }
        DeployedApplication deployedApp = new DeployedApplication(contextName, false, this.isStatusFileCreatable());
        boolean isWar = false;
        if (context.getDocBase() != null) {
            File docBase = new File(context.getDocBase());
            if (!docBase.isAbsolute()) {
                docBase = new File(this.host.getAppBaseFile(), context.getDocBase());
            }
            deployedApp.addRedeployResource(docBase.getAbsolutePath(), docBase.lastModified());
            if (docBase.getAbsolutePath().toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                isWar = true;
            }
        }
        this.host.addChild(context);
        boolean unpackWAR = this.unpackWARs;
        if (unpackWAR && context instanceof DefaultContext) {
            unpackWAR = ((DefaultContext)context).getUnpackWAR();
        }
        if (isWar && unpackWAR) {
            File docBase = new File(this.host.getAppBaseFile(), context.getBaseName());
            deployedApp.addRedeployResource(docBase.getAbsolutePath(), docBase.lastModified());
            this.addWatchedResources(deployedApp, docBase.getAbsolutePath(), context);
        } else {
            this.addWatchedResources(deployedApp, null, context);
        }
        this.deployed.put(contextName, deployedApp);
    }

    public void unmanageApp(String contextName) {
        if (this.isServiced(contextName)) {
            this.deployed.remove(contextName);
            this.host.removeChild(this.host.findChild(contextName));
        }
    }

    static {
        HashMap<String, String> publicIds = new HashMap<String, String>();
        HashMap<String, String> systemIds = new HashMap<String, String>();
        HostConfig.add(publicIds, "-//BES Tech Service(HK) Co., Ltd.//DTD BES Application Server Servlet 2.5//EN", HostConfig.locationFor("bes-web-app_3_0-1.dtd"));
        HostConfig.add(publicIds, "-//Baolande Software Corporation//DTD BES Application Server Servlet 3.0//EN", HostConfig.locationFor("bes-web-app_3_0-1.dtd"));
        HostConfig.add(publicIds, "-//Baolande Software Corporation//DTD BES Application Server Servlet 3.1//EN", HostConfig.locationFor("bes-web-app_3_0-1.dtd"));
        HostConfig.add(systemIds, "http://www.bessystem.com/appserver/dtds/bes-web-app_2_5-0.dtd", HostConfig.locationFor("bes-web-app_3_0-1.dtd"));
        HostConfig.add(systemIds, "http://www.bessystem.com/appserver/dtds/bes-web-app_3_0-0.dtd", HostConfig.locationFor("bes-web-app_3_0-1.dtd"));
        HostConfig.add(systemIds, "http://www.bessystem.com/appserver/dtds/bes-web-app_3_0-1.dtd", HostConfig.locationFor("bes-web-app_3_0-1.dtd"));
        BES_WEB_PUBLIC_IDS = Collections.unmodifiableMap(publicIds);
        BES_WEB_SYSTEM_IDS = Collections.unmodifiableMap(systemIds);
    }

    private static class ExpandedDirectoryRemovalListener
    implements LifecycleListener {
        private final File toDelete;
        private final String newDocBase;

        public ExpandedDirectoryRemovalListener(File toDelete, String newDocBase) {
            this.toDelete = toDelete;
            this.newDocBase = newDocBase;
        }

        @Override
        public void lifecycleEvent(LifecycleEvent event) {
            if ("after_stop".equals(event.getType())) {
                Context context = (Context)event.getLifecycle();
                ExpandWar.delete(this.toDelete);
                context.setDocBase(this.newDocBase);
                context.removeLifecycleListener(this);
            }
        }
    }

    private static class UnDeploy
    implements Runnable {
        private HostConfig config;
        private DeployedApplication app;

        public UnDeploy(HostConfig config, DeployedApplication app) {
            this.config = config;
            this.app = app;
        }

        @Override
        public void run() {
            this.config.doUndeploy(this.app);
        }
    }

    private static class DeployDirectory
    implements Runnable {
        private HostConfig config;
        private ContextName cn;
        private File dir;

        public DeployDirectory(HostConfig config, ContextName cn, File dir) {
            this.config = config;
            this.cn = cn;
            this.dir = dir;
        }

        @Override
        public void run() {
            this.config.deployDirectory(this.cn, this.dir);
        }
    }

    private static class DeployWar
    implements Runnable {
        private HostConfig config;
        private ContextName cn;
        private File war;

        public DeployWar(HostConfig config, ContextName cn, File war) {
            this.config = config;
            this.cn = cn;
            this.war = war;
        }

        @Override
        public void run() {
            this.config.deployWAR(this.cn, this.war);
        }
    }

    private static class DeployDescriptor
    implements Runnable {
        private HostConfig config;
        private ContextName cn;
        private File descriptor;

        public DeployDescriptor(HostConfig config, ContextName cn, File descriptor) {
            this.config = config;
            this.cn = cn;
            this.descriptor = descriptor;
        }

        @Override
        public void run() {
            this.config.deployDescriptor(this.cn, this.descriptor);
        }
    }

    protected static class DeployedApplication {
        public final String name;
        public final boolean hasDescriptor;
        public final LinkedHashMap<String, Long> redeployResources = new LinkedHashMap();
        public final HashMap<String, Long> reloadResources = new HashMap();
        public long timestamp = System.currentTimeMillis();
        public boolean loggedDirWarning = false;
        public final boolean statusFileCreatable;
        public final List<String> resourcePath = new ArrayList<String>();

        public DeployedApplication(String name, boolean hasDescriptor, boolean statusFileCreatable) {
            this.name = name;
            this.hasDescriptor = hasDescriptor;
            this.statusFileCreatable = statusFileCreatable;
        }

        public void addAppStatusFileResource(String resource, Long lastModified) {
            this.redeployResources.put(resource, lastModified);
        }

        public void addRedeployResource(String resource, Long lastModified) {
            if (!this.statusFileCreatable) {
                this.redeployResources.put(resource, lastModified);
            } else {
                this.resourcePath.add(resource);
            }
        }

        public void addReloadResource(String resource, Long lastModified) {
            this.reloadResources.put(resource, lastModified);
        }

        public LinkedHashMap<String, Long> getRedeployResources() {
            return this.redeployResources;
        }

        public Long getRedeployResource(String resource) {
            return this.redeployResources.get(resource);
        }

        public HashMap<String, Long> getReloadResources() {
            return this.reloadResources;
        }

        public Long getReloadResource(String resource) {
            return this.reloadResources.get(resource);
        }

        public List<String> getResourcePath() {
            return this.resourcePath;
        }
    }
}

