/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.startup;

import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.LifecycleEvent;
import com.bes.enterprise.webtier.LifecycleListener;
import com.bes.enterprise.webtier.startup.HeavenProperties;
import com.bes.enterprise.webtier.util.ServerInfo;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class VersionLoggerListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(VersionLoggerListener.class);
    protected static final StringManager sm = StringManager.getManager("com.bes.enterprise.webtier.startup");
    private boolean logArgs = true;
    private boolean logEnv = false;
    private boolean logProps = false;

    public boolean getLogArgs() {
        return this.logArgs;
    }

    public void setLogArgs(boolean logArgs) {
        this.logArgs = logArgs;
    }

    public boolean getLogEnv() {
        return this.logEnv;
    }

    public void setLogEnv(boolean logEnv) {
        this.logEnv = logEnv;
    }

    public boolean getLogProps() {
        return this.logProps;
    }

    public void setLogProps(boolean logProps) {
        this.logProps = logProps;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_init".equals(event.getType())) {
            this.log();
        }
    }

    private void log() {
        TreeMap<String, String> sortedMap;
        log.info(sm.getString("versionLoggerListener.serverInfo.server.version", ServerInfo.getServerInfo()));
        log.info(sm.getString("versionLoggerListener.serverInfo.server.built", ServerInfo.getServerBuilt()));
        log.info(sm.getString("versionLoggerListener.os.name", System.getProperty("os.name")));
        log.info(sm.getString("versionLoggerListener.os.version", System.getProperty("os.version")));
        log.info(sm.getString("versionLoggerListener.os.arch", System.getProperty("os.arch")));
        log.info(sm.getString("versionLoggerListener.java.home", System.getProperty("java.home")));
        log.info(sm.getString("versionLoggerListener.vm.version", System.getProperty("java.runtime.version")));
        log.info(sm.getString("versionLoggerListener.vm.vendor", System.getProperty("java.vm.vendor")));
        log.info(sm.getString("versionLoggerListener.bes.base", System.getProperty("bes.base")));
        log.info(sm.getString("versionLoggerListener.bes.home", System.getProperty("bes.home")));
        if (this.logArgs) {
            List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String string : args) {
                log.info(sm.getString("versionLoggerListener.arg", this.getCommandLineArgument(string)));
            }
        }
        if (this.logEnv) {
            sortedMap = new TreeMap<String, String>(System.getenv());
            for (Map.Entry entry : sortedMap.entrySet()) {
                log.info(sm.getString("versionLoggerListener.env", entry.getKey(), entry.getValue()));
            }
        }
        if (this.logProps) {
            sortedMap = new TreeMap();
            for (Map.Entry entry : System.getProperties().entrySet()) {
                sortedMap.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            for (Map.Entry entry : sortedMap.entrySet()) {
                log.info(sm.getString("versionLoggerListener.prop", entry.getKey(), entry.getValue()));
            }
        }
    }

    private String getCommandLineArgument(String arg) {
        String needEncryptProp = HeavenProperties.getProperty("com.bes.enterprise.needEncrypt.systemProperties");
        if (StringUtils.isNotEmpty((String)needEncryptProp)) {
            String key;
            List<String> needEncrypt = Arrays.asList(needEncryptProp.split(","));
            if (arg.startsWith("-D") && arg.contains("=") && needEncrypt.contains(key = arg.split("=")[0].substring(2))) {
                return key + "=********";
            }
        }
        return arg;
    }
}

