/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.users;

import com.bes.enterprise.web.util.digester.AbstractObjectCreationFactory;
import com.bes.enterprise.webtier.Group;
import com.bes.enterprise.webtier.Role;
import com.bes.enterprise.webtier.users.MemoryUserDatabase;
import org.xml.sax.Attributes;

class MemoryGroupCreationFactory
extends AbstractObjectCreationFactory {
    private final MemoryUserDatabase database;

    public MemoryGroupCreationFactory(MemoryUserDatabase database) {
        this.database = database;
    }

    @Override
    public Object createObject(Attributes attributes) {
        String groupname = attributes.getValue("groupname");
        if (groupname == null) {
            groupname = attributes.getValue("name");
        }
        String description = attributes.getValue("description");
        String roles = attributes.getValue("roles");
        Group group = this.database.createGroup(groupname, description);
        if (roles != null) {
            while (roles.length() > 0) {
                String rolename = null;
                int comma = roles.indexOf(44);
                if (comma >= 0) {
                    rolename = roles.substring(0, comma).trim();
                    roles = roles.substring(comma + 1);
                } else {
                    rolename = roles.trim();
                    roles = "";
                }
                if (rolename.length() <= 0) continue;
                Role role = this.database.findRole(rolename);
                if (role == null) {
                    role = this.database.createRole(rolename, null);
                }
                group.addRole(role);
            }
        }
        return group;
    }
}

