/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.util;

import com.bes.enterprise.web.util.ExceptionUtils;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

public class CharsetMapper {
    public static final String DEFAULT_RESOURCE = "/com/bes/enterprise/webtier/util/CharsetMapperDefault.properties";
    private Properties map = new Properties();

    public CharsetMapper() {
        this(DEFAULT_RESOURCE);
    }

    public CharsetMapper(String name) {
        try (InputStream stream = this.getClass().getResourceAsStream(name);){
            this.map.load(stream);
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            throw new IllegalArgumentException(t2.toString());
        }
    }

    public String getCharset(Locale locale) {
        String charset = this.map.getProperty(locale.toString());
        if (charset == null && (charset = this.map.getProperty(locale.getLanguage() + "_" + locale.getCountry())) == null) {
            charset = this.map.getProperty(locale.getLanguage());
        }
        return charset;
    }

    public void addCharsetMappingFromDeploymentDescriptor(String locale, String charset) {
        this.map.put(locale, charset);
    }
}

