/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.util;

import com.bes.enterprise.appserver.common.util.VersionUtil;
import com.bes.enterprise.web.util.ExceptionUtils;
import java.io.InputStream;
import java.util.Properties;

public class ServerInfo {
    private static final String serverInfo;
    private static final String serverBuilt;
    private static final String serverNumber;

    public static String getServerInfo() {
        return serverInfo;
    }

    public static String getServerBuilt() {
        return serverBuilt;
    }

    public static String getServerNumber() {
        return serverNumber;
    }

    public static void main(String[] args) {
        System.out.println("Server version: " + ServerInfo.getServerInfo() + " " + VersionUtil.getPatchVersion());
        System.out.println("Server built:   " + ServerInfo.getServerBuilt());
        System.out.println("Server number:  " + ServerInfo.getServerNumber());
        System.out.println("OS Name:        " + System.getProperty("os.name"));
        System.out.println("OS Version:     " + System.getProperty("os.version"));
        System.out.println("Architecture:   " + System.getProperty("os.arch"));
        System.out.println("JVM Version:    " + System.getProperty("java.runtime.version"));
        System.out.println("JVM Vendor:     " + System.getProperty("java.vm.vendor"));
    }

    static {
        String info = null;
        String built = null;
        String number = null;
        Properties props = new Properties();
        try (InputStream is = ServerInfo.class.getResourceAsStream("/com/bes/enterprise/webtier/util/ServerInfo.properties");){
            props.load(is);
            info = props.getProperty("server.info");
            built = props.getProperty("server.built");
            number = props.getProperty("server.number");
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
        }
        if (info == null) {
            info = "BES Application Server";
        }
        if (built == null) {
            built = "unknown";
        }
        if (number == null) {
            number = "9.5.x";
        }
        serverInfo = info;
        serverBuilt = built;
        serverNumber = number;
    }
}

