/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.util.jsp;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.jasper.EmbeddedServletOptions;
import com.bes.enterprise.web.jasper.JasperException;
import com.bes.enterprise.web.jasper.JspCompilationContext;
import com.bes.enterprise.web.jasper.Options;
import com.bes.enterprise.web.jasper.compiler.Compiler;
import com.bes.enterprise.web.jasper.compiler.JspConfig;
import com.bes.enterprise.web.jasper.compiler.JspRuntimeContext;
import com.bes.enterprise.web.jasper.compiler.TagPluginManager;
import com.bes.enterprise.web.jasper.compiler.TldCache;
import com.bes.enterprise.web.jasper.runtime.JspFactoryImpl;
import com.bes.enterprise.web.jasper.servlet.JspCServletContext;
import com.bes.enterprise.web.jasper.servlet.JspServlet;
import com.bes.enterprise.web.jasper.servlet.TldScanner;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.Wrapper;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.util.jsp.JspCServletConfig;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.tagext.TagLibraryInfo;

public class BESASJspC
implements Options {
    private static final StringManager sm = StringManager.getManager(BESASJspC.class);
    private static final Log log = LogFactory.getLog(BESASJspC.class);
    public static final String DEFAULT_IE_CLASS_ID = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    protected static final String SWITCH_VERBOSE = "-v";
    protected static final String SWITCH_HELP = "-help";
    protected static final String SWITCH_OUTPUT_DIR = "-d";
    protected static final String SWITCH_PACKAGE_NAME = "-p";
    protected static final String SWITCH_CACHE = "-cache";
    protected static final String SWITCH_CLASS_NAME = "-c";
    protected static final String SWITCH_FULL_STOP = "--";
    protected static final String SWITCH_COMPILE = "-compile";
    protected static final String SWITCH_SOURCE = "-source";
    protected static final String SWITCH_TARGET = "-target";
    protected static final String SWITCH_URI_BASE = "-uribase";
    protected static final String SWITCH_URI_ROOT = "-uriroot";
    protected static final String SWITCH_FILE_WEBAPP = "-webapp";
    protected static final String SWITCH_WEBAPP_INC = "-webinc";
    protected static final String SWITCH_WEBAPP_XML = "-webxml";
    protected static final String SWITCH_WEBAPP_XML_ENCODING = "-webxmlencoding";
    protected static final String SWITCH_ADD_WEBAPP_XML_MAPPINGS = "-addwebxmlmappings";
    protected static final String SWITCH_MAPPED = "-mapped";
    protected static final String SWITCH_XPOWERED_BY = "-xpoweredBy";
    protected static final String SWITCH_TRIM_SPACES = "-trimSpaces";
    protected static final String SWITCH_CLASSPATH = "-classpath";
    protected static final String SWITCH_DIE = "-die";
    protected static final String SWITCH_POOLING = "-poolingEnabled";
    protected static final String SWITCH_ENCODING = "-javaEncoding";
    protected static final String SWITCH_SMAP = "-smap";
    protected static final String SWITCH_DUMP_SMAP = "-dumpsmap";
    protected static final String SWITCH_VALIDATE_TLD = "-validatetld";
    protected static final String SWITCH_VALIDATE_XML = "-validatexml";
    protected static final String SWITCH_NO_BLOCK_EXTERNAL = "-no-blockExternal";
    protected static final String SWITCH_NO_STRICT_QUOTE_ESCAPING = "-no-strictQuoteEscaping";
    protected static final String SWITCH_QUOTE_ATTRIBUTE_EL = "-quoteAttributeEL";
    protected static final String SWITCH_NO_QUOTE_ATTRIBUTE_EL = "-no-quoteAttributeEL";
    protected static final String SHOW_SUCCESS = "-s";
    protected static final String LIST_ERRORS = "-l";
    protected static final int INC_WEBXML = 10;
    protected static final int ALL_WEBXML = 20;
    protected static final int DEFAULT_DIE_LEVEL = 1;
    protected static final int NO_DIE_LEVEL = 0;
    protected static final Set<String> insertBefore;
    protected DefaultContext standardContext;
    protected List<Throwable> compileFailedThrowables = new ArrayList<Throwable>();
    protected Options options;
    protected String classPath = null;
    protected ClassLoader loader = null;
    protected boolean trimSpaces = false;
    protected boolean genStringAsCharArray = false;
    protected boolean validateTld;
    protected boolean validateXml;
    protected boolean blockExternal = true;
    protected boolean strictQuoteEscaping = true;
    protected boolean quoteAttributeEL = true;
    protected boolean xpoweredBy;
    protected boolean mappedFile = false;
    protected boolean poolingEnabled = true;
    protected File scratchDir;
    protected String ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    protected String targetPackage;
    protected String targetClassName;
    protected String uriBase;
    protected String uriRoot;
    protected int dieLevel;
    protected boolean helpNeeded = false;
    protected boolean compile = false;
    protected boolean smapSuppressed = true;
    protected boolean smapDumped = false;
    protected boolean caching = true;
    protected final Map<String, TagLibraryInfo> cache = new HashMap<String, TagLibraryInfo>();
    protected String compiler = null;
    protected String compilerTargetVM = "1.8";
    protected String compilerSourceVM = "1.8";
    protected boolean classDebugInfo = true;
    protected boolean failOnError = true;
    private boolean fork = false;
    protected List<String> extensions;
    protected final List<String> pages = new Vector<String>();
    protected boolean errorOnUseBeanInvalidClassAttribute = true;
    protected String javaEncoding = "UTF-8";
    protected String webxmlFile;
    protected int webxmlLevel;
    protected String webxmlEncoding = "UTF-8";
    protected boolean addWebXmlMappings = false;
    protected Writer mapout;
    protected CharArrayWriter servletout;
    protected CharArrayWriter mappingout;
    protected boolean verbose = false;
    protected boolean listErrors = false;
    protected boolean showSuccess = false;
    protected boolean fullstop = false;
    protected ServletContext context;
    protected JspRuntimeContext rctxt;
    protected int argPos;
    protected String[] args;

    public static void main(String[] arg) {
        block6: {
            if (arg.length == 0) {
                System.out.println(sm.getString("jspc.usage"));
            } else {
                BESASJspC jspc = new BESASJspC();
                try {
                    jspc.setArgs(arg);
                    if (jspc.helpNeeded) {
                        System.out.println(sm.getString("jspc.usage"));
                    } else {
                        jspc.execute();
                    }
                }
                catch (JasperException je) {
                    System.err.println(je);
                    if (jspc.dieLevel == 0) break block6;
                    System.exit(jspc.dieLevel);
                }
            }
        }
    }

    public void setDefaultContext(DefaultContext standardContext) {
        this.standardContext = standardContext;
        this.context = standardContext.getServletContext();
        this.options = new EmbeddedServletOptions(this.findJspServletConfig(), this.context);
        this.rctxt = new JspRuntimeContext(this.context, this);
    }

    private ServletConfig findJspServletConfig() {
        for (Container child : this.standardContext.findChildren()) {
            if (!(child instanceof Wrapper)) continue;
            try {
                Class<?> clazz;
                Wrapper wrapper = (Wrapper)child;
                String className = wrapper.getServletClass();
                if (className == null || className.isEmpty() || !JspServlet.class.isAssignableFrom(clazz = this.standardContext.getLoader().getClassLoader().loadClass(className))) continue;
                return wrapper.getServlet().getServletConfig();
            }
            catch (Exception e2) {
                log.warn(e2.getMessage(), e2);
            }
        }
        log.warn(sm.getString("bESAsJspC.findJspServletConfigFailed"));
        return this.createJspCServletConfig();
    }

    private ServletConfig createJspCServletConfig() {
        JspCServletConfig jspcServletConfig = new JspCServletConfig();
        jspcServletConfig.setServletContext(this.context);
        jspcServletConfig.addInitParameter("keepgenerated", String.valueOf(true));
        jspcServletConfig.addInitParameter("trimSpace", String.valueOf(this.trimSpaces));
        jspcServletConfig.addInitParameter("enablePooling", String.valueOf(this.poolingEnabled));
        jspcServletConfig.addInitParameter("mappedfile", String.valueOf(this.mappedFile));
        jspcServletConfig.addInitParameter("classdebuginfo", String.valueOf(this.classDebugInfo));
        jspcServletConfig.addInitParameter("checkInterval", String.valueOf(0));
        jspcServletConfig.addInitParameter("modificationTestInterval", String.valueOf(0));
        jspcServletConfig.addInitParameter("recompileOnFail", String.valueOf(false));
        jspcServletConfig.addInitParameter("development", String.valueOf(false));
        jspcServletConfig.addInitParameter("suppressSmap", String.valueOf(this.smapSuppressed));
        jspcServletConfig.addInitParameter("dumpSmap", String.valueOf(this.smapDumped));
        jspcServletConfig.addInitParameter("genStringAsCharArray", String.valueOf(this.genStringAsCharArray));
        jspcServletConfig.addInitParameter("errorOnUseBeanInvalidClassAttribute", String.valueOf(this.errorOnUseBeanInvalidClassAttribute));
        jspcServletConfig.addInitParameter("compilerTargetVM", this.compilerTargetVM);
        jspcServletConfig.addInitParameter("compilerSourceVM", this.compilerSourceVM);
        jspcServletConfig.addInitParameter("javaEncoding", this.javaEncoding);
        jspcServletConfig.addInitParameter("fork", String.valueOf(false));
        jspcServletConfig.addInitParameter("xpoweredBy", String.valueOf(this.xpoweredBy));
        jspcServletConfig.addInitParameter("displaySourceFragment", String.valueOf(true));
        jspcServletConfig.addInitParameter("maxLoadedJsps", String.valueOf(-1));
        jspcServletConfig.addInitParameter("jspIdleTimeout", String.valueOf(-1));
        jspcServletConfig.addInitParameter("strictQuoteEscaping", String.valueOf(this.strictQuoteEscaping));
        jspcServletConfig.addInitParameter("quoteAttributeEL", String.valueOf(this.quoteAttributeEL));
        if (this.ieClassId != null) {
            jspcServletConfig.addInitParameter("ieClassId", this.ieClassId);
        }
        if (this.classPath != null) {
            jspcServletConfig.addInitParameter("classpath", this.classPath);
        }
        if (this.scratchDir != null) {
            jspcServletConfig.addInitParameter("scratchdir", this.scratchDir.getAbsolutePath());
        }
        if (this.compiler != null) {
            jspcServletConfig.addInitParameter("compiler", this.compiler);
        }
        return jspcServletConfig;
    }

    @Override
    public boolean getKeepGenerated() {
        return this.options.getKeepGenerated();
    }

    @Override
    public boolean getTrimSpaces() {
        return this.options.getTrimSpaces();
    }

    public void setTrimSpaces(boolean ts) {
        this.trimSpaces = ts;
    }

    @Override
    public boolean isPoolingEnabled() {
        return this.options.isPoolingEnabled();
    }

    public void setPoolingEnabled(boolean poolingEnabled) {
        this.poolingEnabled = poolingEnabled;
    }

    @Override
    public boolean isXpoweredBy() {
        return this.options.isXpoweredBy();
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.xpoweredBy = xpoweredBy;
    }

    @Override
    public boolean getDisplaySourceFragment() {
        return this.options.getDisplaySourceFragment();
    }

    @Override
    public int getMaxLoadedJsps() {
        return this.options.getMaxLoadedJsps();
    }

    @Override
    public int getJspIdleTimeout() {
        return this.options.getJspIdleTimeout();
    }

    @Override
    public boolean getErrorOnUseBeanInvalidClassAttribute() {
        return this.options.getErrorOnUseBeanInvalidClassAttribute();
    }

    public void setErrorOnUseBeanInvalidClassAttribute(boolean b2) {
        this.errorOnUseBeanInvalidClassAttribute = b2;
    }

    @Override
    public boolean getMappedFile() {
        return this.options.getMappedFile();
    }

    public void setMappedFile(boolean b2) {
        this.mappedFile = b2;
    }

    public void setClassDebugInfo(boolean b2) {
        this.classDebugInfo = b2;
    }

    @Override
    public boolean getClassDebugInfo() {
        return this.options.getClassDebugInfo();
    }

    @Override
    public boolean isCaching() {
        return this.options.isCaching();
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    @Override
    public Map<String, TagLibraryInfo> getCache() {
        return this.options.getCache();
    }

    @Override
    public int getCheckInterval() {
        return this.options.getCheckInterval();
    }

    @Override
    public int getModificationTestInterval() {
        return this.options.getModificationTestInterval();
    }

    @Override
    public boolean getRecompileOnFail() {
        return this.options.getRecompileOnFail();
    }

    @Override
    public boolean getDevelopment() {
        return this.options.getDevelopment();
    }

    @Override
    public boolean isSmapSuppressed() {
        return this.options.isSmapSuppressed();
    }

    public void setSmapSuppressed(boolean smapSuppressed) {
        this.smapSuppressed = smapSuppressed;
    }

    @Override
    public boolean isSmapDumped() {
        return this.options.isSmapDumped();
    }

    public void setSmapDumped(boolean smapDumped) {
        this.smapDumped = smapDumped;
    }

    public void setGenStringAsCharArray(boolean genStringAsCharArray) {
        this.genStringAsCharArray = genStringAsCharArray;
    }

    @Override
    public boolean genStringAsCharArray() {
        return this.options.genStringAsCharArray();
    }

    public void setIeClassId(String ieClassId) {
        this.ieClassId = ieClassId;
    }

    @Override
    public String getIeClassId() {
        return this.options.getIeClassId();
    }

    @Override
    public File getScratchDir() {
        return this.options.getScratchDir();
    }

    @Override
    public String getCompiler() {
        return this.options.getCompiler();
    }

    public void setCompiler(String c2) {
        this.compiler = c2;
    }

    @Override
    public String getCompilerClassName() {
        return this.options.getCompilerClassName();
    }

    @Override
    public String getCompilerTargetVM() {
        return this.options.getCompilerTargetVM();
    }

    public void setCompilerTargetVM(String vm) {
        this.compilerTargetVM = vm;
    }

    @Override
    public String getCompilerSourceVM() {
        return this.options.getCompilerSourceVM();
    }

    public void setCompilerSourceVM(String vm) {
        this.compilerSourceVM = vm;
    }

    @Override
    public String getJavaEncoding() {
        return this.options.getJavaEncoding();
    }

    public void setJavaEncoding(String encodingName) {
        this.javaEncoding = encodingName;
    }

    @Override
    public boolean getFork() {
        return this.options.getFork();
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    @Override
    public String getClassPath() {
        if (this.options != null && this.options.getClassPath() != null) {
            return this.options.getClassPath();
        }
        if (this.classPath != null) {
            return this.classPath;
        }
        return System.getProperty("java.class.path");
    }

    public void setClassPath(String s2) {
        this.classPath = s2;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    protected void addExtension(String extension) {
        if (extension != null) {
            if (this.extensions == null) {
                this.extensions = new Vector<String>();
            }
            this.extensions.add(extension);
        }
    }

    public void setUriroot(String s2) {
        if (s2 == null) {
            this.uriRoot = null;
            return;
        }
        try {
            this.uriRoot = this.resolveFile(s2).getCanonicalPath();
        }
        catch (Exception ex) {
            this.uriRoot = s2;
        }
    }

    public void setJspFiles(String jspFiles) {
        if (jspFiles == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(jspFiles, ",");
        while (tok.hasMoreTokens()) {
            this.pages.add(tok.nextToken());
        }
    }

    public void setCompile(boolean b2) {
        this.compile = b2;
    }

    public void setVerbose(int level) {
        if (level > 0) {
            this.verbose = true;
            this.showSuccess = true;
            this.listErrors = true;
        }
    }

    public void setValidateTld(boolean b2) {
        this.validateTld = b2;
    }

    public boolean isValidateTld() {
        return this.validateTld;
    }

    public void setValidateXml(boolean b2) {
        this.validateXml = b2;
    }

    public boolean isValidateXml() {
        return this.validateXml;
    }

    public void setBlockExternal(boolean b2) {
        this.blockExternal = b2;
    }

    public boolean isBlockExternal() {
        return this.blockExternal;
    }

    public void setStrictQuoteEscaping(boolean b2) {
        this.strictQuoteEscaping = b2;
    }

    @Override
    public boolean getStrictQuoteEscaping() {
        return this.options.getStrictQuoteEscaping();
    }

    public void setQuoteAttributeEL(boolean b2) {
        this.quoteAttributeEL = b2;
    }

    @Override
    public boolean getQuoteAttributeEL() {
        return this.options.getQuoteAttributeEL();
    }

    public void setListErrors(boolean b2) {
        this.listErrors = b2;
    }

    public void setOutputDir(String s2) {
        this.scratchDir = s2 != null ? this.resolveFile(s2).getAbsoluteFile() : null;
    }

    public void setPackage(String p2) {
        this.targetPackage = p2;
    }

    public void setClassName(String p2) {
        this.targetClassName = p2;
    }

    public void setWebXmlFragment(String s2) {
        this.webxmlFile = this.resolveFile(s2).getAbsolutePath();
        this.webxmlLevel = 10;
    }

    public void setWebXml(String s2) {
        this.webxmlFile = this.resolveFile(s2).getAbsolutePath();
        this.webxmlLevel = 20;
    }

    public void setWebXmlEncoding(String encoding) {
        this.webxmlEncoding = encoding;
    }

    public void setAddWebXmlMappings(boolean b2) {
        this.addWebXmlMappings = b2;
    }

    public void setFailOnError(boolean b2) {
        this.failOnError = b2;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    @Override
    public TldCache getTldCache() {
        return this.options.getTldCache();
    }

    @Override
    public JspConfig getJspConfig() {
        return this.options.getJspConfig();
    }

    @Override
    public TagPluginManager getTagPluginManager() {
        return this.options.getTagPluginManager();
    }

    public void generateWebMapping(String file, JspCompilationContext clctxt) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Generating web mapping for file " + file + " using compilation context " + clctxt);
        }
        String className = clctxt.getServletClassName();
        String packageName = clctxt.getServletPackageName();
        String thisServletName = "".equals(packageName) ? className : packageName + '.' + className;
        if (this.servletout != null) {
            this.servletout.write("\n    <servlet>\n        <servlet-name>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-name>\n        <servlet-class>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-class>\n    </servlet>\n");
        }
        if (this.mappingout != null) {
            this.mappingout.write("\n    <servlet-mapping>\n        <servlet-name>");
            this.mappingout.write(thisServletName);
            this.mappingout.write("</servlet-name>\n        <url-pattern>");
            this.mappingout.write(file.replace('\\', '/'));
            this.mappingout.write("</url-pattern>\n    </servlet-mapping>\n");
        }
    }

    protected void mergeIntoWebXml() throws IOException {
        Throwable throwable;
        File webappBase = new File(this.uriRoot);
        File webXml = new File(webappBase, "WEB-INF/web.xml");
        File webXml2 = new File(webappBase, "WEB-INF/web2.xml");
        String insertStartMarker = sm.getString("jspc.webinc.insertStart");
        String insertEndMarker = sm.getString("jspc.webinc.insertEnd");
        try (BufferedReader reader = new BufferedReader(this.openWebxmlReader(webXml));){
            throwable = null;
            try (BufferedReader fragmentReader = new BufferedReader(this.openWebxmlReader(new File(this.webxmlFile)));
                 PrintWriter writer2 = new PrintWriter(this.openWebxmlWriter(webXml2));){
                boolean inserted = false;
                int current = reader.read();
                while (current > -1) {
                    if (current == 60) {
                        String element = this.getElement(reader);
                        if (!inserted && insertBefore.contains(element)) {
                            writer2.println(insertStartMarker);
                            while (true) {
                                String line;
                                if ((line = fragmentReader.readLine()) == null) break;
                                writer2.println(line);
                            }
                            writer2.println();
                            writer2.println(insertEndMarker);
                            writer2.println();
                            writer2.write(element);
                            inserted = true;
                        } else {
                            if (element.equals(insertStartMarker)) {
                                do {
                                    if ((current = reader.read()) >= 0) continue;
                                    throw new EOFException();
                                } while (current != 60 || !(element = this.getElement(reader)).equals(insertEndMarker));
                                current = reader.read();
                                while (current == 10 || current == 13) {
                                    current = reader.read();
                                }
                                continue;
                            }
                            writer2.write(element);
                        }
                    } else {
                        writer2.write(current);
                    }
                    current = reader.read();
                }
            }
            catch (Throwable writer2) {
                throwable = writer2;
                throw writer2;
            }
        }
        var7_7 = null;
        try (FileInputStream fis = new FileInputStream(webXml2);){
            throwable = null;
            try (FileOutputStream fos = new FileOutputStream(webXml);){
                int n2;
                byte[] buf = new byte[512];
                while ((n2 = fis.read(buf)) >= 0) {
                    fos.write(buf, 0, n2);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var7_7 = throwable3;
            throw throwable3;
        }
        if (!webXml2.delete() && log.isDebugEnabled()) {
            log.debug(sm.getString("jspc.delete.fail", webXml2.toString()));
        }
        if (!new File(this.webxmlFile).delete() && log.isDebugEnabled()) {
            log.debug(sm.getString("jspc.delete.fail", this.webxmlFile));
        }
    }

    private String getElement(Reader reader) throws IOException {
        StringBuilder result = new StringBuilder();
        result.append('<');
        boolean done = false;
        while (!done) {
            int current = reader.read();
            while (current != 62) {
                if (current < 0) {
                    throw new EOFException();
                }
                result.append((char)current);
                current = reader.read();
            }
            result.append((char)current);
            int len = result.length();
            if (len > 4 && result.substring(0, 4).equals("<!--")) {
                if (len < 7 || !result.substring(len - 3, len).equals("-->")) continue;
                done = true;
                continue;
            }
            done = true;
        }
        return result.toString();
    }

    /*
     * Loose catch block
     */
    protected void processFile(String file) throws JasperException {
        if (log.isDebugEnabled()) {
            log.debug("Processing file: " + file);
        }
        ClassLoader originalClassLoader = null;
        try {
            if (this.scratchDir == null) {
                String temp = System.getProperty("java.io.tmpdir");
                if (temp == null) {
                    temp = "";
                }
                this.scratchDir = new File(temp).getAbsoluteFile();
            }
            String jspUri = file.replace('\\', '/');
            JspCompilationContext clctxt = new JspCompilationContext(jspUri, this, this.context, null, this.rctxt);
            if (this.targetClassName != null && this.targetClassName.length() > 0) {
                clctxt.setServletClassName(this.targetClassName);
                this.targetClassName = null;
            }
            if (this.targetPackage != null) {
                clctxt.setServletPackageName(this.targetPackage);
            }
            originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.loader);
            clctxt.setClassLoader(this.loader);
            clctxt.setClassPath(this.classPath);
            Compiler clc = clctxt.createCompiler();
            if (clc.isOutDated(this.compile)) {
                if (log.isDebugEnabled()) {
                    log.debug(jspUri + " is out dated, compiling...");
                }
                clc.compile(this.compile, true);
            }
            this.generateWebMapping(file, clctxt);
            if (this.showSuccess) {
                log.info("Built File: " + file);
            }
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        catch (JasperException je) {
            Throwable rootCause = je;
            while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                rootCause = rootCause.getRootCause();
            }
            if (rootCause != je) {
                log.error(sm.getString("jspc.error.generalException", file), rootCause);
            }
            if (this.getFailOnError()) {
                throw je;
            }
            log.error(je.getMessage());
        }
        catch (Exception e2) {
            if (e2 instanceof FileNotFoundException && log.isWarnEnabled()) {
                log.warn(sm.getString("jspc.error.fileDoesNotExist", e2.getMessage()));
            }
            throw new JasperException(e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    public void scanFiles(File base) {
        Stack<String> dirs = new Stack<String>();
        dirs.push(base.toString());
        if (this.getExtensions() == null || this.getExtensions().size() < 2) {
            this.addExtension("jsp");
            this.addExtension("jspx");
        }
        while (!dirs.isEmpty()) {
            String s2 = (String)dirs.pop();
            File f2 = new File(s2);
            if (!f2.exists() || !f2.isDirectory()) continue;
            String[] files = f2.list();
            for (int i2 = 0; files != null && i2 < files.length; ++i2) {
                File f22 = new File(s2, files[i2]);
                if (f22.isDirectory()) {
                    dirs.push(f22.getPath());
                    continue;
                }
                String path = f22.getPath();
                String uri = path.substring(this.uriRoot.length());
                String ext = files[i2].substring(files[i2].lastIndexOf(46) + 1);
                if (!this.getExtensions().contains(ext) && !this.getJspConfig().isJspPage(uri)) continue;
                this.pages.add(path);
            }
        }
    }

    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug("execute() starting for " + this.pages.size() + " pages.");
        }
        try {
            if (this.uriRoot == null) {
                if (this.pages.size() == 0) {
                    throw new JasperException(sm.getString("jsp.error.jspc.missingTarget"));
                }
                String firstJsp = this.pages.get(0);
                File firstJspF = new File(firstJsp);
                if (!firstJspF.exists()) {
                    throw new JasperException(sm.getString("jspc.error.fileDoesNotExist", firstJsp));
                }
                this.locateUriRoot(firstJspF);
            }
            if (this.uriRoot == null) {
                throw new JasperException(sm.getString("jsp.error.jspc.no_uriroot"));
            }
            File uriRootF = new File(this.uriRoot);
            if (!uriRootF.isDirectory()) {
                throw new JasperException(sm.getString("jsp.error.jspc.uriroot_not_dir"));
            }
            if (this.loader == null) {
                this.loader = this.initClassLoader();
            }
            if (this.context == null) {
                this.initServletContext(this.loader);
            }
            if (this.pages.size() == 0) {
                this.scanFiles(uriRootF);
            }
            this.initWebXml();
            for (String nextjsp : this.pages) {
                File fjsp = new File(nextjsp);
                if (!fjsp.isAbsolute()) {
                    fjsp = new File(uriRootF, nextjsp);
                }
                if (!fjsp.exists()) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn(sm.getString("jspc.error.fileDoesNotExist", fjsp.toString()));
                    continue;
                }
                String s2 = fjsp.getAbsolutePath();
                if (s2.startsWith(this.uriRoot)) {
                    nextjsp = s2.substring(this.uriRoot.length());
                }
                if (nextjsp.startsWith("." + File.separatorChar)) {
                    nextjsp = nextjsp.substring(2);
                }
                try {
                    this.processFile(nextjsp);
                }
                catch (Throwable throwable) {
                    log.warn("failed to compile jsp", throwable);
                    this.compileFailedThrowables.add(throwable);
                }
            }
            this.completeWebXml();
            if (this.addWebXmlMappings) {
                this.mergeIntoWebXml();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to compile the jsp files.", ioe);
        }
        catch (JasperException je) {
            Throwable rootCause = je;
            while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                rootCause = rootCause.getRootCause();
            }
            if (rootCause != je) {
                rootCause.printStackTrace();
            }
            throw new RuntimeException("Failed to compile the jsp files.", je);
        }
        finally {
            if (this.loader != null) {
                LogFactory.release(this.loader);
            }
        }
    }

    protected void initWebXml() throws JasperException {
        try {
            if (this.webxmlLevel >= 10) {
                this.mapout = this.openWebxmlWriter(new File(this.webxmlFile));
                this.servletout = new CharArrayWriter();
                this.mappingout = new CharArrayWriter();
            } else {
                this.mapout = null;
                this.servletout = null;
                this.mappingout = null;
            }
            if (this.webxmlLevel >= 20) {
                this.mapout.write(sm.getString("jspc.webxml.header", this.webxmlEncoding));
                this.mapout.flush();
            } else if (this.webxmlLevel >= 10 && !this.addWebXmlMappings) {
                this.mapout.write(sm.getString("jspc.webinc.header"));
                this.mapout.flush();
            }
        }
        catch (IOException ioe) {
            this.mapout = null;
            this.servletout = null;
            this.mappingout = null;
            throw new JasperException(ioe);
        }
    }

    protected void completeWebXml() {
        if (this.mapout != null) {
            try {
                this.servletout.writeTo(this.mapout);
                this.mappingout.writeTo(this.mapout);
                if (this.webxmlLevel >= 20) {
                    this.mapout.write(sm.getString("jspc.webxml.footer"));
                } else if (this.webxmlLevel >= 10 && !this.addWebXmlMappings) {
                    this.mapout.write(sm.getString("jspc.webinc.footer"));
                }
                this.mapout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected TldScanner initTldScanner(ServletContext context, ClassLoader classLoader) {
        TldScanner scanner = this.newTldScanner(context, true, this.isValidateTld(), this.isBlockExternal());
        scanner.setClassLoader(classLoader);
        return scanner;
    }

    protected TldScanner newTldScanner(ServletContext context, boolean namespaceAware, boolean validate, boolean blockExternal) {
        return new TldScanner(context, namespaceAware, validate, blockExternal);
    }

    protected void initServletContext(ClassLoader classLoader) throws IOException, JasperException {
        if (this.context == null || this.options == null) {
            PrintWriter log = new PrintWriter(System.out);
            URL resourceBase = new File(this.uriRoot).getCanonicalFile().toURI().toURL();
            this.context = new JspCServletContext(log, resourceBase, classLoader, this.isValidateXml(), this.isBlockExternal());
            TldScanner tldScanner = this.initTldScanner(this.context, classLoader);
            try {
                tldScanner.scan();
            }
            catch (Exception e2) {
                throw new JasperException(e2);
            }
            this.context.setAttribute(TldCache.SERVLET_CONTEXT_ATTRIBUTE_NAME, new TldCache(this.context, tldScanner.getUriTldResourcePathMap(), tldScanner.getTldResourcePathTaglibXmlMap()));
            this.options = new EmbeddedServletOptions(this.createJspCServletConfig(), this.context);
        }
        this.rctxt = new JspRuntimeContext(this.context, this);
    }

    protected ClassLoader initClassLoader() throws IOException {
        if (this.standardContext != null) {
            this.loader = this.standardContext.getLoader().getClassLoader();
            return this.loader;
        }
        this.classPath = this.getClassPath();
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(this.classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            try {
                File libFile = new File(path);
                urls.add(libFile.toURI().toURL());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
        File webappBase = new File(this.uriRoot);
        if (webappBase.exists()) {
            String[] libs;
            File classes = new File(webappBase, "/WEB-INF/classes");
            try {
                if (classes.exists()) {
                    this.classPath = this.classPath + File.pathSeparator + classes.getCanonicalPath();
                    urls.add(classes.getCanonicalFile().toURI().toURL());
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
            File lib = new File(webappBase, "/WEB-INF/lib");
            if (lib.exists() && lib.isDirectory() && (libs = lib.list()) != null) {
                for (int i2 = 0; i2 < libs.length; ++i2) {
                    if (libs[i2].length() < 5) continue;
                    String ext = libs[i2].substring(libs[i2].length() - 4);
                    if (!".jar".equalsIgnoreCase(ext)) {
                        if (!".tld".equalsIgnoreCase(ext)) continue;
                        log.warn("TLD files should not be placed in /WEB-INF/lib");
                        continue;
                    }
                    try {
                        File libFile = new File(lib, libs[i2]);
                        this.classPath = this.classPath + File.pathSeparator + libFile.getAbsolutePath();
                        urls.add(libFile.getAbsoluteFile().toURI().toURL());
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe.toString());
                    }
                }
            }
        }
        URL[] urlsA = new URL[urls.size()];
        urls.toArray(urlsA);
        this.loader = new URLClassLoader(urlsA, this.getClass().getClassLoader());
        return this.loader;
    }

    protected void locateUriRoot(File f2) {
        String tUriBase = this.uriBase;
        if (tUriBase == null) {
            tUriBase = "/";
        }
        try {
            if (f2.exists()) {
                f2 = new File(f2.getAbsolutePath());
                while (true) {
                    String fParent;
                    File g2;
                    if ((g2 = new File(f2, "WEB-INF")).exists() && g2.isDirectory()) {
                        this.uriRoot = f2.getCanonicalPath();
                        this.uriBase = tUriBase;
                        if (!log.isInfoEnabled()) break;
                        log.info(sm.getString("jspc.implicit.uriRoot", this.uriRoot));
                        break;
                    }
                    if (f2.exists() && f2.isDirectory()) {
                        tUriBase = "/" + f2.getName() + "/" + tUriBase;
                    }
                    if ((fParent = f2.getParent()) == null) break;
                    f2 = new File(fParent);
                }
                if (this.uriRoot != null) {
                    File froot = new File(this.uriRoot);
                    this.uriRoot = froot.getCanonicalPath();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected File resolveFile(String s2) {
        File file = new File(s2);
        if (!file.isAbsolute() && this.standardContext != null) {
            File baseDir = new File(this.standardContext.getDocBase());
            file = new File(baseDir, s2);
        }
        return file;
    }

    private Reader openWebxmlReader(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            return this.webxmlEncoding != null ? new InputStreamReader((InputStream)fis, this.webxmlEncoding) : new InputStreamReader(fis);
        }
        catch (IOException ex) {
            fis.close();
            throw ex;
        }
    }

    public void setArgs(String[] arg) throws JasperException {
        String file;
        String tok;
        this.args = arg;
        this.dieLevel = 0;
        while ((tok = this.nextArg()) != null) {
            if (tok.equals(SWITCH_VERBOSE)) {
                this.verbose = true;
                this.showSuccess = true;
                this.listErrors = true;
                continue;
            }
            if (tok.equals(SWITCH_OUTPUT_DIR)) {
                tok = this.nextArg();
                this.setOutputDir(tok);
                continue;
            }
            if (tok.equals(SWITCH_PACKAGE_NAME)) {
                this.targetPackage = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_COMPILE)) {
                this.compile = true;
                continue;
            }
            if (tok.equals(SWITCH_CLASS_NAME)) {
                this.targetClassName = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_BASE)) {
                this.uriBase = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_ROOT)) {
                this.setUriroot(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_FILE_WEBAPP)) {
                this.setUriroot(this.nextArg());
                continue;
            }
            if (tok.equals(SHOW_SUCCESS)) {
                this.showSuccess = true;
                continue;
            }
            if (tok.equals(LIST_ERRORS)) {
                this.listErrors = true;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_INC)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 10;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_XML)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 20;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_XML_ENCODING)) {
                this.setWebXmlEncoding(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_ADD_WEBAPP_XML_MAPPINGS)) {
                this.setAddWebXmlMappings(true);
                continue;
            }
            if (tok.equals(SWITCH_MAPPED)) {
                this.mappedFile = true;
                continue;
            }
            if (tok.equals(SWITCH_XPOWERED_BY)) {
                this.xpoweredBy = true;
                continue;
            }
            if (tok.equals(SWITCH_TRIM_SPACES)) {
                this.setTrimSpaces(true);
                continue;
            }
            if (tok.equals(SWITCH_CACHE)) {
                tok = this.nextArg();
                if ("false".equals(tok)) {
                    this.caching = false;
                    continue;
                }
                this.caching = true;
                continue;
            }
            if (tok.equals(SWITCH_CLASSPATH)) {
                this.setClassPath(this.nextArg());
                continue;
            }
            if (tok.startsWith(SWITCH_DIE)) {
                try {
                    this.dieLevel = Integer.parseInt(tok.substring(SWITCH_DIE.length()));
                }
                catch (NumberFormatException nfe) {
                    this.dieLevel = 1;
                }
                continue;
            }
            if (tok.equals(SWITCH_HELP)) {
                this.helpNeeded = true;
                continue;
            }
            if (tok.equals(SWITCH_POOLING)) {
                tok = this.nextArg();
                if ("false".equals(tok)) {
                    this.poolingEnabled = false;
                    continue;
                }
                this.poolingEnabled = true;
                continue;
            }
            if (tok.equals(SWITCH_ENCODING)) {
                this.setJavaEncoding(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_SOURCE)) {
                this.setCompilerSourceVM(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_TARGET)) {
                this.setCompilerTargetVM(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_SMAP)) {
                this.smapSuppressed = false;
                continue;
            }
            if (tok.equals(SWITCH_DUMP_SMAP)) {
                this.smapDumped = true;
                continue;
            }
            if (tok.equals(SWITCH_VALIDATE_TLD)) {
                this.setValidateTld(true);
                continue;
            }
            if (tok.equals(SWITCH_VALIDATE_XML)) {
                this.setValidateXml(true);
                continue;
            }
            if (tok.equals(SWITCH_NO_BLOCK_EXTERNAL)) {
                this.setBlockExternal(false);
                continue;
            }
            if (tok.equals(SWITCH_NO_STRICT_QUOTE_ESCAPING)) {
                this.setStrictQuoteEscaping(false);
                continue;
            }
            if (tok.equals(SWITCH_QUOTE_ATTRIBUTE_EL)) {
                this.setQuoteAttributeEL(true);
                continue;
            }
            if (tok.equals(SWITCH_NO_QUOTE_ATTRIBUTE_EL)) {
                this.setQuoteAttributeEL(false);
                continue;
            }
            if (tok.startsWith("-")) {
                throw new JasperException("Unrecognized option: " + tok + ".  Use -help for help.");
            }
            if (this.fullstop) break;
            --this.argPos;
            break;
        }
        while ((file = this.nextFile()) != null) {
            this.pages.add(file);
        }
    }

    protected String nextArg() {
        if (this.argPos >= this.args.length || (this.fullstop = SWITCH_FULL_STOP.equals(this.args[this.argPos]))) {
            return null;
        }
        return this.args[this.argPos++];
    }

    protected String nextFile() {
        if (this.fullstop) {
            ++this.argPos;
        }
        if (this.argPos >= this.args.length) {
            return null;
        }
        return this.args[this.argPos++];
    }

    private Writer openWebxmlWriter(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            return this.webxmlEncoding != null ? new OutputStreamWriter((OutputStream)fos, this.webxmlEncoding) : new OutputStreamWriter(fos);
        }
        catch (IOException ex) {
            fos.close();
            throw ex;
        }
    }

    public List<Throwable> getCompileFailedThrowables() {
        return this.compileFailedThrowables;
    }

    static {
        JspFactory.setDefaultFactory(new JspFactoryImpl());
        insertBefore = new HashSet<String>();
        insertBefore.add("</web-app>");
        insertBefore.add("<servlet-mapping>");
        insertBefore.add("<session-config>");
        insertBefore.add("<mime-mapping>");
        insertBefore.add("<welcome-file-list>");
        insertBefore.add("<error-page>");
        insertBefore.add("<taglib>");
        insertBefore.add("<resource-env-ref>");
        insertBefore.add("<resource-ref>");
        insertBefore.add("<security-constraint>");
        insertBefore.add("<login-config>");
        insertBefore.add("<security-role>");
        insertBefore.add("<env-entry>");
        insertBefore.add("<ejb-ref>");
        insertBefore.add("<ejb-local-ref>");
    }
}

