/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.util.jsp;

import com.bes.enterprise.deployment.DeploymentContext;
import com.bes.enterprise.deployment.DeploymentParameters;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Wrapper;
import com.bes.enterprise.webtier.core.DefaultContext;
import com.bes.enterprise.webtier.core.DefaultHost;
import com.bes.enterprise.webtier.util.jsp.BESASJspC;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class JspPreCompiler {
    protected static final StringManager sm = StringManager.getManager(JspPreCompiler.class);
    private static final String JSP_OUTPUT_PACKAGE = "org.apache.jsp";
    private static final String JSP_SERVLET_NAME = "jsp";
    private static final String JSP_SCRATCHDIR_INITPARAM_NAME = "scratchdir";
    private static final Log log = LogFactory.getLog(JspPreCompiler.class);
    private DefaultContext standardContext;
    private DeploymentContext deployContext;

    public JspPreCompiler(DefaultContext standardContext, DeploymentContext deployContext) {
        this.standardContext = standardContext;
        this.deployContext = deployContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() {
        ThreadContextClassLoaderBinder binder = new ThreadContextClassLoaderBinder();
        ClassLoader webappClassLoader = this.standardContext.getLoader().getClassLoader();
        binder.bind(webappClassLoader);
        try {
            BESASJspC jspc = new BESASJspC();
            jspc.setDefaultContext(this.standardContext);
            String uriroot = this.getUriroot(this.standardContext);
            if (uriroot == null) {
                return;
            }
            String outputDir = this.getOutputDir(this.standardContext);
            if (outputDir == null) {
                return;
            }
            DeploymentParameters deployParams = this.deployContext.getDeploymentParameters();
            jspc.setUriroot(uriroot);
            jspc.setOutputDir(outputDir);
            jspc.setPackage(JSP_OUTPUT_PACKAGE);
            jspc.setVerbose(1);
            jspc.setCompile(true);
            jspc.setValidateTld(deployParams.isValidateTld());
            jspc.setValidateXml(deployParams.isValidateXml());
            jspc.execute();
            List<Throwable> compileFailedThrowables = jspc.getCompileFailedThrowables();
            if (!compileFailedThrowables.isEmpty()) {
                for (Throwable t2 : compileFailedThrowables) {
                    this.deployContext.addException(t2);
                }
            }
        }
        catch (Throwable e2) {
            log.warn(sm.getString("jspPreCompiler.compileFailed"), e2);
            this.deployContext.addException(e2);
        }
        finally {
            binder.unbind();
        }
    }

    private String getUriroot(DefaultContext standardContext) {
        String contextDocBase = standardContext.getDocBase();
        File contextDocBaseFile = new File(contextDocBase);
        if (!contextDocBaseFile.isAbsolute()) {
            File hostAppBaseFile = ((DefaultHost)standardContext.getParent()).getAppBaseFile();
            contextDocBaseFile = new File(hostAppBaseFile, contextDocBase);
        }
        try {
            if (!contextDocBaseFile.exists()) {
                return null;
            }
            return contextDocBaseFile.getCanonicalPath();
        }
        catch (IOException e2) {
            log.warn(sm.getString("jspPreCompiler.getURIRootError"), e2);
            return null;
        }
    }

    private String getOutputDir(DefaultContext standardContext) {
        Wrapper jspServlet = (Wrapper)standardContext.findChild(JSP_SERVLET_NAME);
        if (jspServlet != null) {
            String scratchdir = jspServlet.findInitParameter(JSP_SCRATCHDIR_INITPARAM_NAME);
            if (scratchdir != null && !scratchdir.isEmpty()) {
                return this.getCanonicalPath(new File(scratchdir));
            }
            File tempDir = (File)standardContext.getServletContext().getAttribute("javax.servlet.context.tempdir");
            if (tempDir != null) {
                return this.getCanonicalPath(tempDir);
            }
        }
        String workPath = standardContext.getWorkPath();
        return this.getCanonicalPath(new File(workPath));
    }

    private String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e2) {
            throw new RuntimeException("Cannot get the canonical path of working directory of DefaultContext.", e2);
        }
    }

    private class ThreadContextClassLoaderBinder {
        private ClassLoader originalClassLoader;

        public ClassLoader bind(ClassLoader classLoader) {
            if (classLoader == null) {
                throw new IllegalArgumentException("The classLoader to be bound cannot be null.");
            }
            Thread currentThread = Thread.currentThread();
            this.originalClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(classLoader);
            return this.originalClassLoader;
        }

        public ClassLoader unbind() {
            if (this.originalClassLoader == null) {
                throw new IllegalStateException("Current binder hadn't been bound to any threads.");
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader classLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.originalClassLoader);
            return classLoader;
        }
    }
}

