/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.util.mbeanserver;

import com.bes.enterprise.appserver.common.ssl.J2EEKeyManager;
import com.bes.enterprise.appserver.common.ssl.SecuritySupport;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.compat.JreVendor;
import com.bes.enterprise.web.util.net.openssl.ciphers.OpenSSLCipherConfigurationParser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509KeyManager;

public class JMXSslRMISocketFactory
extends RMISocketFactory
implements Serializable {
    private static final Log log = LogFactory.getLog(JMXSslRMISocketFactory.class);
    private static final String TLSv13 = "TLSv1.3";
    private static final String TLSv12 = "TLSv1.2";
    private static final String TLSv11 = "TLSv1.1";
    private static final String TLS = "TLSv1";
    private static final String SSL3 = "SSLv3";
    private static final String SSL2 = "SSLv2";
    private static final String SSL = "SSL";
    private final InetAddress mAddress;
    private static final String ALLOW_ALL_SUPPORTED_CIPHERS = "ALL";
    private boolean rfc5746Supported;
    private String[] defaultServerProtocols;
    private String[] defaultServerCipherSuites;
    private transient SSLContext sslContext;
    private String alias = null;
    private String protocol = null;
    private String clientAuth = null;
    private String[] ciphers = null;
    private String[] enabledProtocols = null;
    private SecuritySupport securitySupport;

    public JMXSslRMISocketFactory(String alias, boolean ssl3Enabled, boolean tlsEnabled, boolean tls11Enabled, boolean tls12Enabled, boolean tls13Enabled, String clientAuthVal, String cipherStr, InetAddress addr, SecuritySupport securitySupport) throws NoSuchAlgorithmException, GeneralSecurityException, IOException {
        this.mAddress = addr;
        String protocalVal = tls13Enabled ? TLSv13 : (tls12Enabled ? TLSv12 : (tls11Enabled ? TLSv11 : (tlsEnabled ? TLS : (ssl3Enabled ? SSL3 : "TLS"))));
        this.protocol = protocalVal;
        this.enabledProtocols = this.calcEnabledProtocols(ssl3Enabled, tlsEnabled, tls11Enabled, tls12Enabled, tls13Enabled);
        this.clientAuth = clientAuthVal;
        this.initDefaultCipherSuite(this.protocol);
        this.securitySupport = securitySupport;
        this.sslContext = this.getSSLContext(alias, this.protocol);
        this.ciphers = this.getEnableableCiphers(this.sslContext, cipherStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDefaultCipherSuite(String sslProtocol) {
        SSLServerSocket socket;
        SSLContext context;
        try {
            context = SSLContext.getInstance(sslProtocol);
            context.init(null, null, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e2) {
            throw new IllegalArgumentException(e2);
        }
        SSLServerSocketFactory ssf = context.getServerSocketFactory();
        String[] supportedCiphers = ssf.getSupportedCipherSuites();
        boolean found = false;
        for (String cipher : supportedCiphers) {
            if (!"TLS_EMPTY_RENEGOTIATION_INFO_SCSV".equals(cipher)) continue;
            found = true;
            break;
        }
        this.rfc5746Supported = found;
        try {
            socket = (SSLServerSocket)ssf.createServerSocket();
        }
        catch (IOException e3) {
            this.defaultServerCipherSuites = new String[0];
            this.defaultServerProtocols = new String[0];
            log.warn("Unable to determine a default for ciphers for jmx connector. Set an explicit value to ensure the connector can start.");
            log.warn("Unable to determine a default for sslEnabledProtocols for jmx connector. Set an explicit value to ensure the connector can start.");
            return;
        }
        try {
            this.defaultServerCipherSuites = socket.getEnabledCipherSuites();
            if (this.defaultServerCipherSuites.length == 0) {
                log.warn("Unable to determine a default for ciphers for jmx connector. Set an explicit value to ensure the connector can start.");
            }
            ArrayList<String> filteredProtocols = new ArrayList<String>();
            for (String protocol : socket.getEnabledProtocols()) {
                if (protocol.toUpperCase(Locale.ENGLISH).contains(SSL)) {
                    log.warn(String.format("The SSL protocol %s which is enabled by default in this JRE was excluded from the defaults used by BES Application Server.", protocol));
                    continue;
                }
                filteredProtocols.add(protocol);
            }
            this.defaultServerProtocols = filteredProtocols.toArray(new String[filteredProtocols.size()]);
            if (this.defaultServerProtocols.length == 0) {
                log.warn("Unable to determine a default for sslEnabledProtocols for jmx connector. Set an explicit value to ensure the connector can start.");
            }
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private SSLContext getSSLContext(String alias, String protocol) throws NoSuchAlgorithmException, GeneralSecurityException, IOException {
        SecuritySupport securitySupportInUse;
        if (protocol == null) {
            protocol = "TLS";
        }
        if ((securitySupportInUse = this.getSecuritySupport()) == null) {
            securitySupportInUse = SecuritySupport.getDefaultSecuritySupport();
        }
        SSLContext cntxt = SSLContext.getInstance(protocol);
        KeyManager[] kMgrs = securitySupportInUse.getKeyManagers(null);
        if (alias != null && alias.length() > 0 && kMgrs != null) {
            for (int i2 = 0; i2 < kMgrs.length; ++i2) {
                kMgrs[i2] = new J2EEKeyManager((X509KeyManager)kMgrs[i2], alias);
            }
        }
        cntxt.init(kMgrs, securitySupportInUse.getTrustManagers(null), null);
        return cntxt;
    }

    private String[] calcEnabledProtocols(boolean ssl3Enabled, boolean tlsEnabled, boolean tls11Enalbed, boolean tls12Enalbed, boolean tls13Enabled) {
        StringBuilder protocolsBuf = new StringBuilder();
        if (ssl3Enabled) {
            protocolsBuf.append("SSLv3,");
        }
        if (tlsEnabled) {
            protocolsBuf.append("TLSv1,");
        }
        if (tls11Enalbed) {
            protocolsBuf.append("TLSv1.1,");
        }
        if (tls12Enalbed) {
            protocolsBuf.append("TLSv1.2,");
        }
        if (tls13Enabled) {
            protocolsBuf.append("TLSv1.3,");
        }
        if (protocolsBuf.length() == 0) {
            return null;
        }
        protocolsBuf.deleteCharAt(protocolsBuf.length() - 1);
        return protocolsBuf.toString().split(",");
    }

    private String[] getEnableableCiphers(SSLContext context, String requestedCiphersStr) {
        List<String> supportedCipherSuiteList;
        if (ALLOW_ALL_SUPPORTED_CIPHERS.equals(requestedCiphersStr)) {
            return context.getSupportedSSLParameters().getCipherSuites();
        }
        if (requestedCiphersStr == null || requestedCiphersStr.trim().length() == 0) {
            return this.defaultServerCipherSuites;
        }
        List<Object> requestedCiphers = new ArrayList();
        if (requestedCiphersStr.indexOf(58) != -1) {
            requestedCiphers = OpenSSLCipherConfigurationParser.parseExpression(requestedCiphersStr);
        } else {
            for (String string : requestedCiphersStr.split(",")) {
                String cipher = string.trim();
                if (cipher.length() <= 0) continue;
                requestedCiphers.add(cipher);
            }
        }
        if (requestedCiphers.isEmpty()) {
            return this.defaultServerCipherSuites;
        }
        ArrayList<Object> ciphers = new ArrayList<Object>(requestedCiphers);
        String[] supportedCipherSuiteArray = context.getSupportedSSLParameters().getCipherSuites();
        if (JreVendor.IS_IBM_JVM) {
            supportedCipherSuiteList = new ArrayList<String>(supportedCipherSuiteArray.length * 2);
            for (String name : supportedCipherSuiteArray) {
                supportedCipherSuiteList.add(name);
                if (!name.startsWith(SSL)) continue;
                supportedCipherSuiteList.add("TLS" + name.substring(3));
            }
        } else {
            supportedCipherSuiteList = Arrays.asList(supportedCipherSuiteArray);
        }
        ciphers.retainAll(supportedCipherSuiteList);
        if (ciphers.isEmpty()) {
            log.warn(String.format("None of the ciphers specified are supported by the SSL engine : %s", requestedCiphersStr));
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("Specified SSL ciphers that are supported and enableable are : %s.", ciphers));
            if (ciphers.size() != requestedCiphers.size()) {
                ArrayList<Object> arrayList = new ArrayList<Object>(requestedCiphers);
                arrayList.removeAll(ciphers);
                log.trace(String.format("Some specified SSL ciphers are not supported by the SSL engine : %s.", arrayList));
            }
        }
        return ciphers.toArray(new String[ciphers.size()]);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.sslContext.getSocketFactory().createSocket(host, port);
        this.configureSSLSocket(sslSocket);
        return sslSocket;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket sslServerSocket = (SSLServerSocket)this.sslContext.getServerSocketFactory().createServerSocket(port, port, this.mAddress);
        this.configureSSLServerSocket(sslServerSocket);
        return sslServerSocket;
    }

    private void configureSSLServerSocket(SSLServerSocket sslServerSocket) {
        if (this.ciphers != null && this.ciphers.length > 0) {
            sslServerSocket.setEnabledCipherSuites(this.ciphers);
        }
        if (this.enabledProtocols != null && this.enabledProtocols.length > 0) {
            sslServerSocket.setEnabledProtocols(this.enabledProtocols);
        }
        if ("true".equalsIgnoreCase(this.clientAuth) || "yes".equalsIgnoreCase(this.clientAuth)) {
            sslServerSocket.setNeedClientAuth(true);
        } else if ("want".equalsIgnoreCase(this.clientAuth)) {
            sslServerSocket.setWantClientAuth(true);
        } else {
            sslServerSocket.setNeedClientAuth(false);
        }
    }

    private void configureSSLSocket(SSLSocket sslSocket) {
        if (this.ciphers != null && this.ciphers.length > 0) {
            sslSocket.setEnabledCipherSuites(this.ciphers);
        }
        if (this.enabledProtocols != null && this.enabledProtocols.length > 0) {
            sslSocket.setEnabledProtocols(this.enabledProtocols);
        }
        if ("true".equalsIgnoreCase(this.clientAuth) || "yes".equalsIgnoreCase(this.clientAuth)) {
            sslSocket.setNeedClientAuth(true);
        } else if ("want".equalsIgnoreCase(this.clientAuth)) {
            sslSocket.setWantClientAuth(true);
        } else {
            sslSocket.setNeedClientAuth(false);
        }
    }

    public SecuritySupport getSecuritySupport() {
        return this.securitySupport;
    }

    public void setSecuritySupport(SecuritySupport securitySupport) {
        this.securitySupport = securitySupport;
    }

    public String getEnabledProtocolsAsString() {
        if (this.enabledProtocols != null && this.enabledProtocols.length > 0) {
            return this.toCommaSeparatedString(this.enabledProtocols);
        }
        return null;
    }

    public String getCiphersAsString() {
        if (this.ciphers != null && this.ciphers.length > 0) {
            return this.toCommaSeparatedString(this.ciphers);
        }
        return null;
    }

    private String toCommaSeparatedString(String[] strArray) {
        StringBuffer strBuf = new StringBuffer(strArray[0]);
        for (int i2 = 1; i2 < strArray.length; ++i2) {
            strBuf.append(",");
            strBuf.append(strArray[i2]);
        }
        return strBuf.toString();
    }

    public void writeObject(ObjectOutputStream oOut) throws IOException {
        oOut.defaultWriteObject();
    }

    public void readObject(ObjectInputStream oIn) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, GeneralSecurityException {
        oIn.defaultReadObject();
        this.sslContext = this.getSSLContext(this.alias, this.protocol);
    }
}

