/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.valves;

import com.bes.enterprise.web.crane.ActionCode;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.web.util.security.Escape;
import com.bes.enterprise.webtier.connector.Request;
import com.bes.enterprise.webtier.connector.Response;
import com.bes.enterprise.webtier.util.ServerInfo;
import com.bes.enterprise.webtier.valves.ValveBase;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;

public class ErrorReportValve
extends ValveBase {
    private boolean showReport = true;
    private boolean showServerInfo = true;

    public ErrorReportValve() {
        super(true);
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        if (response.isCommitted()) {
            if (response.setErrorReported()) {
                try {
                    response.flushBuffer();
                }
                catch (Throwable t2) {
                    ExceptionUtils.handleThrowable(t2);
                }
                response.getCoyoteResponse().action(ActionCode.CLOSE_NOW, request.getAttribute("javax.servlet.error.exception"));
            }
            return;
        }
        Throwable throwable = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (request.isAsync() && !request.isAsyncCompleting()) {
            return;
        }
        if (throwable != null && !response.isError()) {
            response.reset();
            response.sendError(500);
        }
        response.setSuspended(false);
        try {
            this.report(request, response, throwable);
        }
        catch (Throwable tt) {
            ExceptionUtils.handleThrowable(tt);
        }
    }

    protected void report(Request request, Response response, Throwable throwable) {
        int statusCode = response.getStatus();
        if (statusCode < 400 || response.getContentWritten() > 0L || !response.setErrorReported()) {
            return;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        response.getCoyoteResponse().action(ActionCode.IS_IO_ALLOWED, result);
        if (!result.get()) {
            return;
        }
        String message = Escape.htmlElementContent(response.getMessage());
        if (message == null) {
            String exceptionMessage;
            if (throwable != null && (exceptionMessage = throwable.getMessage()) != null && exceptionMessage.length() > 0) {
                message = Escape.htmlElementContent(new Scanner(exceptionMessage).nextLine());
            }
            if (message == null) {
                message = "";
            }
        }
        String reason = null;
        String description = null;
        StringManager smClient = StringManager.getManager("com.bes.enterprise.webtier.valves", request.getLocales());
        response.setLocale(smClient.getLocale());
        try {
            reason = smClient.getString("http." + statusCode + ".reason");
            description = smClient.getString("http." + statusCode + ".desc");
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
        }
        if (reason == null || description == null) {
            if (message.isEmpty()) {
                return;
            }
            reason = smClient.getString("errorReportValve.unknownReason");
            description = smClient.getString("errorReportValve.noDescription");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<!doctype html><html lang=\"");
        sb.append(smClient.getLocale().getLanguage()).append("\">");
        sb.append("<head>");
        sb.append("<title>");
        sb.append(smClient.getString("errorReportValve.statusHeader", String.valueOf(statusCode), reason));
        sb.append("</title>");
        sb.append("<style type=\"text/css\">");
        sb.append("body {font-family:SimSun;} h1, h2, h3, b {color:white;background-color:#525D76;} h1 {font-size:22px;} h2 {font-size:16px;} h3 {font-size:14px;} p {font-size:12px;} a {color:black;} .line {height:1px;background-color:#525D76;border:none;}");
        sb.append("</style>");
        sb.append("</head><body>");
        sb.append("<h1>");
        sb.append(smClient.getString("errorReportValve.statusHeader", String.valueOf(statusCode), reason)).append("</h1>");
        if (this.isShowReport()) {
            sb.append("<hr class=\"line\" />");
            sb.append("<p><b>");
            sb.append(smClient.getString("errorReportValve.type"));
            sb.append("</b> ");
            if (throwable != null) {
                sb.append(smClient.getString("errorReportValve.exceptionReport"));
            } else {
                sb.append(smClient.getString("errorReportValve.statusReport"));
            }
            sb.append("</p>");
            if (!message.isEmpty()) {
                sb.append("<p><b>");
                sb.append(smClient.getString("errorReportValve.message"));
                sb.append("</b> ");
                sb.append(message).append("</p>");
            }
            sb.append("<p><b>");
            sb.append(smClient.getString("errorReportValve.description"));
            sb.append("</b> ");
            sb.append(description);
            sb.append("</p>");
            if (throwable != null) {
                String stackTrace = this.getPartialServletStackTrace(throwable);
                sb.append("<p><b>");
                sb.append(smClient.getString("errorReportValve.exception"));
                sb.append("</b></p><pre>");
                sb.append(Escape.htmlElementContent(stackTrace));
                sb.append("</pre>");
                int loops = 0;
                for (Throwable rootCause = throwable.getCause(); rootCause != null && loops < 10; rootCause = rootCause.getCause(), ++loops) {
                    stackTrace = this.getPartialServletStackTrace(rootCause);
                    sb.append("<p><b>");
                    sb.append(smClient.getString("errorReportValve.rootCause"));
                    sb.append("</b></p><pre>");
                    sb.append(Escape.htmlElementContent(stackTrace));
                    sb.append("</pre>");
                }
                sb.append("<p><b>");
                sb.append(smClient.getString("errorReportValve.note"));
                sb.append("</b> ");
                sb.append(smClient.getString("errorReportValve.rootCauseInLogs"));
                sb.append("</p>");
            }
            sb.append("<hr class=\"line\" />");
        }
        if (this.isShowServerInfo()) {
            sb.append("<h3>").append(ServerInfo.getServerInfo()).append("</h3>");
        }
        sb.append("</body></html>");
        try {
            block22: {
                try {
                    response.setContentType("text/html");
                    response.setCharacterEncoding("utf-8");
                }
                catch (Throwable t3) {
                    ExceptionUtils.handleThrowable(t3);
                    if (!this.container.getLogger().isDebugEnabled()) break block22;
                    this.container.getLogger().debug("status.setContentType", t3);
                }
            }
            PrintWriter writer = response.getReporter();
            if (writer != null) {
                ((Writer)writer).write(sb.toString());
                response.finishResponse();
            }
        }
        catch (IOException iOException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected String getPartialServletStackTrace(Throwable t2) {
        int i2;
        StringBuilder trace = new StringBuilder();
        trace.append(t2.toString()).append(System.lineSeparator());
        StackTraceElement[] elements = t2.getStackTrace();
        int pos = elements.length;
        for (i2 = elements.length - 1; i2 >= 0; --i2) {
            if (!elements[i2].getClassName().startsWith("com.bes.enterprise.webtier.core.ApplicationFilterChain") || !elements[i2].getMethodName().equals("internalDoFilter")) continue;
            pos = i2;
            break;
        }
        for (i2 = 0; i2 < pos; ++i2) {
            if (elements[i2].getClassName().startsWith("com.bes.enterprise.webtier.core.")) continue;
            trace.append('\t').append(elements[i2].toString()).append(System.lineSeparator());
        }
        return trace.toString();
    }

    public void setShowReport(boolean showReport) {
        this.showReport = showReport;
    }

    public boolean isShowReport() {
        return this.showReport;
    }

    public void setShowServerInfo(boolean showServerInfo) {
        this.showServerInfo = showServerInfo;
    }

    public boolean isShowServerInfo() {
        return this.showServerInfo;
    }
}

