/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.valves;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Contained;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.Pipeline;
import com.bes.enterprise.webtier.Valve;
import com.bes.enterprise.webtier.util.LifecycleMBeanBase;

public abstract class ValveBase
extends LifecycleMBeanBase
implements Contained,
Valve {
    protected static final StringManager sm = StringManager.getManager(ValveBase.class);
    protected boolean asyncSupported;
    protected Container container = null;
    protected Log containerLog = null;
    protected Valve next = null;

    public ValveBase() {
        this(false);
    }

    public ValveBase(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    @Override
    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    @Override
    public Valve getNext() {
        return this.next;
    }

    @Override
    public void setNext(Valve valve) {
        this.next = valve;
    }

    @Override
    public void backgroundProcess() {
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.containerLog = this.getContainer().getLogger();
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('[');
        if (this.container == null) {
            sb.append("Container is null");
        } else {
            sb.append(this.container.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getObjectNameKeyProperties() {
        String className;
        int period;
        StringBuilder name = new StringBuilder("type=Valve");
        Container container = this.getContainer();
        name.append(container.getMBeanKeyProperties());
        int seq = 0;
        Pipeline p2 = container.getPipeline();
        if (p2 != null) {
            for (Valve valve : p2.getValves()) {
                if (valve == null) continue;
                if (valve == this) break;
                if (valve.getClass() != this.getClass()) continue;
                ++seq;
            }
        }
        if (seq > 0) {
            name.append(",seq=");
            name.append(seq);
        }
        if ((period = (className = this.getClass().getName()).lastIndexOf(46)) >= 0) {
            className = className.substring(period + 1);
        }
        name.append(",name=");
        name.append(className);
        return name.toString();
    }

    @Override
    public String getDomainInternal() {
        Container c2 = this.getContainer();
        if (c2 == null) {
            return null;
        }
        return c2.getDomain();
    }
}

