/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.webresources;

import com.bes.enterprise.core.web.jade.JadeConfigConfiguration;
import com.bes.enterprise.core.web.jade.Jader;
import com.bes.enterprise.core.web.jade.JaderFactory;
import com.bes.enterprise.core.web.jade.JaderUtil;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.WebResource;
import com.bes.enterprise.webtier.WebResourceRoot;
import com.bes.enterprise.webtier.webresources.Cache;
import com.bes.enterprise.webtier.webresources.EmptyResource;
import com.bes.enterprise.webtier.webresources.PictureTransformer;
import com.bes.enterprise.webtier.webresources.StandardRoot;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.security.Permission;
import java.security.cert.Certificate;
import java.text.Collator;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.GZIPOutputStream;

public class CachedResource
implements WebResource {
    private static final Log log = LogFactory.getLog(CachedResource.class);
    private static final StringManager sm = StringManager.getManager(CachedResource.class);
    private static final long CACHE_ENTRY_SIZE = 500L;
    private final Cache cache;
    private final StandardRoot root;
    private final String webAppPath;
    private final long ttl;
    protected final int objectMaxSizeBytes;
    private final boolean usesClassLoaderResources;
    private volatile WebResource webResource;
    private volatile WebResource[] webResources;
    private volatile long nextCheck;
    private volatile Long cachedLastModified = null;
    private volatile String cachedLastModifiedHttp = null;
    protected volatile byte[] cachedContent = null;
    protected volatile Long cachedContentLength = null;
    private volatile Boolean cachedIsFile = null;
    private volatile Boolean cachedIsDirectory = null;
    private volatile Boolean cachedExists = null;
    private volatile Boolean cachedCanRead = null;
    private volatile Boolean cachedIsVirtual = null;
    protected volatile byte[] cachedGZipContent = null;
    protected volatile Long cachedGZipContentLength = null;
    protected volatile Long cachedActualContentLength = null;
    private boolean preCompresseable = true;
    private JadeConfigConfiguration jadeConfigC = null;
    public static final boolean preCompressedFile = Boolean.parseBoolean(System.getProperty("com.bes.enterprise.web.preCompressedFile", "false"));
    public static List<String> preCompressedSuffixDeny = null;

    public CachedResource(Cache cache, StandardRoot root, String path, long ttl, int objectMaxSizeBytes, boolean usesClassLoaderResources) {
        this.cache = cache;
        this.root = root;
        this.webAppPath = path;
        this.ttl = ttl;
        this.objectMaxSizeBytes = objectMaxSizeBytes;
        this.usesClassLoaderResources = usesClassLoaderResources;
        if (preCompressedFile) {
            String pathSuffix;
            if (path.contains(".") && preCompressedSuffixDeny.contains(pathSuffix = path.substring(path.lastIndexOf(".") + 1, path.length()))) {
                this.preCompresseable = false;
            }
        } else {
            this.preCompresseable = false;
        }
    }

    public void setJadeConfigConfiguration(JadeConfigConfiguration jadeConfig) {
        this.jadeConfigC = jadeConfig;
    }

    public JadeConfigConfiguration getJadeConfigConfiguration() {
        return this.jadeConfigC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateResource(boolean useClassLoaderResources) {
        if (this.usesClassLoaderResources != useClassLoaderResources) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.webResource == null) {
            CachedResource cachedResource = this;
            synchronized (cachedResource) {
                if (this.webResource == null) {
                    this.webResource = this.root.getResourceInternal(this.webAppPath, useClassLoaderResources);
                    this.getLastModified();
                    this.getContentLength();
                    this.nextCheck = this.ttl + now;
                    this.cachedExists = this.webResource instanceof EmptyResource ? Boolean.FALSE : Boolean.TRUE;
                    return true;
                }
            }
        }
        if (now < this.nextCheck) {
            return true;
        }
        if (!this.root.isPackedWarFile()) {
            WebResource webResourceInternal = this.root.getResourceInternal(this.webAppPath, useClassLoaderResources);
            if (!this.webResource.exists() && webResourceInternal.exists()) {
                return false;
            }
            if (this.webResource.getLastModified() != this.getLastModified() || this.webResource.getContentLength() != this.getCachedActualContentLength().longValue()) {
                return false;
            }
            if (this.webResource.getLastModified() != webResourceInternal.getLastModified() || this.webResource.getContentLength() != webResourceInternal.getContentLength()) {
                return false;
            }
        }
        this.nextCheck = this.ttl + now;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateResources(boolean useClassLoaderResources) {
        long now = System.currentTimeMillis();
        if (this.webResources == null) {
            CachedResource cachedResource = this;
            synchronized (cachedResource) {
                if (this.webResources == null) {
                    this.webResources = this.root.getResourcesInternal(this.webAppPath, useClassLoaderResources);
                    this.nextCheck = this.ttl + now;
                    return true;
                }
            }
        }
        if (now < this.nextCheck) {
            return true;
        }
        if (this.root.isPackedWarFile()) {
            this.nextCheck = this.ttl + now;
            return true;
        }
        return false;
    }

    protected long getNextCheck() {
        return this.nextCheck;
    }

    @Override
    public long getLastModified() {
        Long cachedLastModified = this.cachedLastModified;
        if (cachedLastModified == null) {
            this.cachedLastModified = cachedLastModified = Long.valueOf(this.webResource.getLastModified());
        }
        return cachedLastModified;
    }

    @Override
    public String getLastModifiedHttp() {
        String cachedLastModifiedHttp = this.cachedLastModifiedHttp;
        if (cachedLastModifiedHttp == null) {
            this.cachedLastModifiedHttp = cachedLastModifiedHttp = this.webResource.getLastModifiedHttp();
        }
        return cachedLastModifiedHttp;
    }

    @Override
    public boolean exists() {
        Boolean cachedExists = this.cachedExists;
        if (cachedExists == null) {
            this.cachedExists = cachedExists = Boolean.valueOf(this.webResource.exists());
        }
        return cachedExists;
    }

    @Override
    public boolean isVirtual() {
        Boolean cachedIsVirtual = this.cachedIsVirtual;
        if (cachedIsVirtual == null) {
            this.cachedIsVirtual = cachedIsVirtual = Boolean.valueOf(this.webResource.isVirtual());
        }
        return cachedIsVirtual;
    }

    @Override
    public boolean isDirectory() {
        Boolean cachedIsDirectory = this.cachedIsDirectory;
        if (cachedIsDirectory == null) {
            this.cachedIsDirectory = cachedIsDirectory = Boolean.valueOf(this.webResource.isDirectory());
        }
        return cachedIsDirectory;
    }

    @Override
    public boolean isFile() {
        Boolean cachedIsFile = this.cachedIsFile;
        if (cachedIsFile == null) {
            this.cachedIsFile = cachedIsFile = Boolean.valueOf(this.webResource.isFile());
        }
        return cachedIsFile;
    }

    @Override
    public boolean delete() {
        boolean deleteResult = this.webResource.delete();
        if (deleteResult) {
            this.cache.removeCacheEntry(this.webAppPath);
        }
        return deleteResult;
    }

    @Override
    public String getName() {
        return this.webResource.getName();
    }

    @Override
    public long getContentLength() {
        Long cachedContentLength = this.cachedContentLength;
        if (cachedContentLength == null) {
            long result = 0L;
            if (this.webResource != null) {
                result = this.webResource.getContentLength();
                this.cachedContentLength = cachedContentLength = Long.valueOf(result);
            }
            return result;
        }
        return cachedContentLength;
    }

    public Long getCachedActualContentLength() {
        Long cachedActualContentLength = this.cachedActualContentLength;
        if (cachedActualContentLength == null) {
            long result = 0L;
            if (this.webResource != null) {
                result = this.webResource.getContentLength();
                this.cachedContentLength = cachedActualContentLength = Long.valueOf(result);
            }
            return result;
        }
        return (long)cachedActualContentLength;
    }

    @Override
    public String getCanonicalPath() {
        return this.webResource.getCanonicalPath();
    }

    @Override
    public boolean canRead() {
        Boolean varCachedCanRead = this.cachedCanRead;
        if (varCachedCanRead == null) {
            this.cachedCanRead = varCachedCanRead = Boolean.valueOf(this.webResource.canRead());
        }
        return varCachedCanRead;
    }

    @Override
    public String getWebappPath() {
        return this.webAppPath;
    }

    @Override
    public String getETag() {
        return this.webResource.getETag();
    }

    @Override
    public void setMimeType(String mimeType) {
        this.webResource.setMimeType(mimeType);
    }

    @Override
    public String getMimeType() {
        return this.webResource.getMimeType();
    }

    @Override
    public InputStream getInputStream() {
        byte[] content = this.getContent();
        if (content == null) {
            return this.webResource.getInputStream();
        }
        return new ByteArrayInputStream(content);
    }

    @Override
    public byte[] getContent() {
        byte[] cachedContent = this.cachedContent;
        if (cachedContent == null) {
            if (this.getContentLength() > (long)this.objectMaxSizeBytes) {
                return null;
            }
            this.cachedContent = cachedContent = this.webResource.getContent();
            this.preCompress(cachedContent);
        }
        return cachedContent;
    }

    protected void preCompress(byte[] sourceText) {
        try {
            if (!this.preCompresseable || sourceText == null || sourceText.length == 0) {
                return;
            }
            byte[] plainText = sourceText;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (BESGZIPOutputStream gos = new BESGZIPOutputStream(baos);){
                gos.setLevel(9);
                gos.write(plainText);
            }
            byte[] result = baos.toByteArray();
            if (result.length < plainText.length) {
                this.cachedGZipContent = result;
                this.cachedGZipContentLength = result.length;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] getGZipContent() {
        return this.cachedGZipContent;
    }

    public Long getGZipContentLength() {
        return this.cachedGZipContentLength;
    }

    @Override
    public long getCreation() {
        return this.webResource.getCreation();
    }

    @Override
    public URL getURL() {
        URL resourceURL = this.webResource.getURL();
        if (resourceURL == null) {
            return null;
        }
        try {
            CachedResourceURLStreamHandler handler = new CachedResourceURLStreamHandler(resourceURL, this.root, this.webAppPath, this.usesClassLoaderResources);
            URL result = new URL(null, resourceURL.toExternalForm(), handler);
            handler.setAssociatedURL(result);
            return result;
        }
        catch (MalformedURLException e2) {
            log.error(sm.getString("cachedResource.invalidURL", resourceURL.toExternalForm()), e2);
            return null;
        }
    }

    @Override
    public URL getCodeBase() {
        return this.webResource.getCodeBase();
    }

    @Override
    public Certificate[] getCertificates() {
        return this.webResource.getCertificates();
    }

    @Override
    public Manifest getManifest() {
        return this.webResource.getManifest();
    }

    @Override
    public WebResourceRoot getWebResourceRoot() {
        return this.webResource.getWebResourceRoot();
    }

    WebResource getWebResource() {
        return this.webResource;
    }

    WebResource[] getWebResources() {
        return this.webResources;
    }

    long getSize() {
        long result = 500L;
        if (this.getContentLength() <= (long)this.objectMaxSizeBytes) {
            result += this.getContentLength();
        }
        return result;
    }

    private static InputStream buildInputStream(String[] files) {
        Arrays.sort(files, Collator.getInstance(Locale.getDefault()));
        StringBuilder result = new StringBuilder();
        for (String file : files) {
            result.append(file);
            result.append('\n');
        }
        return new ByteArrayInputStream(result.toString().getBytes(Charset.defaultCharset()));
    }

    static {
        if (preCompressedFile) {
            String suffixDeny = System.getProperty("com.bes.enterprise.resource.preCompressedSuffixDeny", "");
            preCompressedSuffixDeny = Arrays.asList(suffixDeny.split(","));
        }
    }

    public static class CompressedCachedResource
    extends CachedResource {
        private JadeConfigConfiguration jadeConfigC;
        private PictureTransformer pictureTransformer;
        private int imageShrinkageDegree = -1;
        private volatile boolean notCached;

        public CompressedCachedResource(Cache cache, StandardRoot root, String path, long ttl, int objectMaxSizeBytes, boolean usesClassLoaderResources, JadeConfigConfiguration jadeConfigC, PictureTransformer pictureTransformer) {
            super(cache, root, path, ttl, objectMaxSizeBytes, usesClassLoaderResources);
            this.imageShrinkageDegree = root.getImageShrinkageDegree();
            this.pictureTransformer = pictureTransformer;
            this.jadeConfigC = jadeConfigC;
        }

        @Override
        public long getContentLength() {
            Long cachedContentLength = this.cachedContentLength;
            Long cachedActualContentLength = null;
            if (cachedContentLength == null) {
                long result = 0L;
                WebResource webResource = super.getWebResource();
                if (webResource != null) {
                    byte[] cachedContent;
                    cachedActualContentLength = webResource.getContentLength();
                    result = cachedActualContentLength;
                    if (cachedActualContentLength >= 0L && (cachedContent = this.getContent()) != null) {
                        result = cachedContent.length;
                    }
                    this.cachedContentLength = cachedContentLength = Long.valueOf(result);
                    this.cachedActualContentLength = cachedActualContentLength;
                }
                return result;
            }
            return cachedContentLength;
        }

        @Override
        public byte[] getContent() {
            byte[] cachedContent = this.cachedContent;
            if (cachedContent == null && !this.notCached) {
                WebResource webResource = super.getWebResource();
                if (!webResource.isFile()) {
                    return null;
                }
                cachedContent = webResource.getContent();
                if (cachedContent.length > 0) {
                    byte[] transformedContent;
                    String fileSuffix;
                    byte[] compressedContent;
                    if (this.jadeConfigC != null && (compressedContent = this.tryCompressEntry(webResource.getContent())) != null) {
                        cachedContent = compressedContent;
                    }
                    if (this.imageShrinkageDegree >= 0 && this.pictureTransformer != null && (fileSuffix = this.getFileSuffix(webResource)) != null && this.pictureTransformer.supportFile(fileSuffix) && (transformedContent = this.pictureTransformer.transform(webResource.getURL(), fileSuffix)) != null && cachedContent.length > transformedContent.length) {
                        cachedContent = transformedContent;
                    }
                }
                if (cachedContent.length > this.objectMaxSizeBytes) {
                    this.notCached = true;
                    return null;
                }
                this.cachedContent = cachedContent;
                this.preCompress(cachedContent);
            }
            return cachedContent;
        }

        private String getFileSuffix(WebResource webResource) {
            String fileName = webResource.getName();
            if (fileName.lastIndexOf(".") != -1) {
                return fileName.substring(fileName.lastIndexOf(".") + 1);
            }
            return null;
        }

        protected byte[] tryCompressEntry(byte[] content) {
            block4: {
                try {
                    String source = JaderUtil.byte2string((byte[])content, (String)this.jadeConfigC.getJadeCharset());
                    Jader compressor = JaderFactory.getInstance().newJader(JaderUtil.getSuffix((String)super.getWebappPath()), this.jadeConfigC.isJadeDynamicJsjava(), this.jadeConfigC.isJadeDynamicTag());
                    if (compressor == null) {
                        return null;
                    }
                    String result = compressor.jade(source, this.jadeConfigC.isJadeLogEnable());
                    byte[] compressContent = JaderUtil.string2byte((String)result, (String)this.jadeConfigC.getJadeCharset());
                    if (compressContent.length != 0) {
                        return compressContent;
                    }
                }
                catch (Throwable e2) {
                    if (!this.jadeConfigC.isJadeLogEnable()) break block4;
                    log.warn("Failed to jade " + super.getWebappPath(), e2);
                }
            }
            return content;
        }
    }

    public static class BESGZIPOutputStream
    extends GZIPOutputStream {
        public BESGZIPOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        public void setLevel(int level) {
            this.def.setLevel(level);
        }
    }

    private static class CachedResourceJarURLConnection
    extends JarURLConnection {
        private final StandardRoot root;
        private final String webAppPath;
        private final boolean usesClassLoaderResources;
        private final URL resourceURL;

        protected CachedResourceJarURLConnection(URL resourceURL, StandardRoot root, String webAppPath, boolean usesClassLoaderResources) throws IOException {
            super(resourceURL);
            this.root = root;
            this.webAppPath = webAppPath;
            this.usesClassLoaderResources = usesClassLoaderResources;
            this.resourceURL = resourceURL;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            WebResource resource = this.getResource();
            if (resource.isDirectory()) {
                return CachedResource.buildInputStream(resource.getWebResourceRoot().list(this.webAppPath));
            }
            return this.getResource().getInputStream();
        }

        @Override
        public Permission getPermission() throws IOException {
            return this.resourceURL.openConnection().getPermission();
        }

        @Override
        public long getLastModified() {
            return this.getResource().getLastModified();
        }

        @Override
        public long getContentLengthLong() {
            return this.getResource().getContentLength();
        }

        private WebResource getResource() {
            return this.root.getResource(this.webAppPath, false, this.usesClassLoaderResources);
        }

        @Override
        public JarFile getJarFile() throws IOException {
            return ((JarURLConnection)this.resourceURL.openConnection()).getJarFile();
        }
    }

    private static class CachedResourceURLConnection
    extends URLConnection {
        private final StandardRoot root;
        private final String webAppPath;
        private final boolean usesClassLoaderResources;
        private final URL resourceURL;

        protected CachedResourceURLConnection(URL resourceURL, StandardRoot root, String webAppPath, boolean usesClassLoaderResources) {
            super(resourceURL);
            this.root = root;
            this.webAppPath = webAppPath;
            this.usesClassLoaderResources = usesClassLoaderResources;
            this.resourceURL = resourceURL;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            WebResource resource = this.getResource();
            if (resource.isDirectory()) {
                return CachedResource.buildInputStream(resource.getWebResourceRoot().list(this.webAppPath));
            }
            return this.getResource().getInputStream();
        }

        @Override
        public Permission getPermission() throws IOException {
            return this.resourceURL.openConnection().getPermission();
        }

        @Override
        public long getLastModified() {
            return this.getResource().getLastModified();
        }

        @Override
        public long getContentLengthLong() {
            return this.getResource().getContentLength();
        }

        private WebResource getResource() {
            return this.root.getResource(this.webAppPath, false, this.usesClassLoaderResources);
        }
    }

    private static class CachedResourceURLStreamHandler
    extends URLStreamHandler {
        private final URL resourceURL;
        private final StandardRoot root;
        private final String webAppPath;
        private final boolean usesClassLoaderResources;
        private URL associatedURL = null;

        public CachedResourceURLStreamHandler(URL resourceURL, StandardRoot root, String webAppPath, boolean usesClassLoaderResources) {
            this.resourceURL = resourceURL;
            this.root = root;
            this.webAppPath = webAppPath;
            this.usesClassLoaderResources = usesClassLoaderResources;
        }

        protected void setAssociatedURL(URL associatedURL) {
            this.associatedURL = associatedURL;
        }

        @Override
        protected URLConnection openConnection(URL u2) throws IOException {
            if (this.associatedURL != null && u2 == this.associatedURL) {
                if ("jar".equals(this.associatedURL.getProtocol())) {
                    return new CachedResourceJarURLConnection(this.resourceURL, this.root, this.webAppPath, this.usesClassLoaderResources);
                }
                return new CachedResourceURLConnection(this.resourceURL, this.root, this.webAppPath, this.usesClassLoaderResources);
            }
            URL constructedURL = new URL(u2.toExternalForm());
            return constructedURL.openConnection();
        }
    }
}

