/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.webresources;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;

public class PictureTransformer {
    private static float DEFAULT_COMPRESSION_QUALITY = 0.85f;
    private ImageWriteParam imageWriteParam;

    public PictureTransformer() {
        this.configImageWriteParam(DEFAULT_COMPRESSION_QUALITY);
    }

    public PictureTransformer(int compressionQualityInt) {
        this.configImageWriteParam(this.calculateCompressQuality(compressionQualityInt));
    }

    public void configImageWriteParam(int compressionQualityInt) {
        this.configImageWriteParam(this.calculateCompressQuality(compressionQualityInt));
    }

    public void configImageWriteParam(float compressionQuality) {
        this.imageWriteParam = new JPEGImageWriteParam(null);
        this.imageWriteParam.setCompressionMode(2);
        this.imageWriteParam.setCompressionQuality(compressionQuality);
        this.imageWriteParam.setProgressiveMode(3);
    }

    private float calculateCompressQuality(int compressQualityInt) {
        float compressionQualityFloat = DEFAULT_COMPRESSION_QUALITY;
        if (compressQualityInt >= 0 && compressQualityInt <= 100) {
            compressionQualityFloat = (float)compressQualityInt / 100.0f;
        }
        return compressionQualityFloat;
    }

    public byte[] transform(URL url, String fileSuffix) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageWriter imageWriter = ImageIO.getImageWritersBySuffix(fileSuffix).next();
            BufferedImage newImage = this.rotateWithAffineTransform(ImageIO.read(url), this.readExifOrientationInfo(url));
            imageWriter.reset();
            imageWriter.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
            imageWriter.write(null, new IIOImage(newImage, null, null), this.imageWriteParam);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (Exception e2) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public boolean supportFile(String fileSuffix) {
        for (String formatName : ImageIO.getWriterFileSuffixes()) {
            if (!formatName.equalsIgnoreCase(fileSuffix)) continue;
            return true;
        }
        return false;
    }

    private AffineTransform readExifOrientationInfo(URL url) {
        try {
            Metadata imageMetadata = ImageMetadataReader.readMetadata((File)new File(url.toURI()));
            ExifIFD0Directory exifDirectory = (ExifIFD0Directory)imageMetadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            JpegDirectory jpegDirectory = (JpegDirectory)imageMetadata.getFirstDirectoryOfType(JpegDirectory.class);
            int orientation = exifDirectory.getInt(274);
            return this.generateAffineTransform(orientation, jpegDirectory.getImageWidth(), jpegDirectory.getImageHeight());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private AffineTransform generateAffineTransform(int orientation, int width, int height) {
        AffineTransform transform = new AffineTransform();
        switch (orientation) {
            case 1: {
                break;
            }
            case 2: {
                transform.scale(-1.0, 1.0);
                transform.translate(width, 0.0);
                break;
            }
            case 3: {
                transform.translate(width, height);
                transform.rotate(Math.PI);
                break;
            }
            case 4: {
                transform.scale(1.0, -1.0);
                transform.translate(0.0, -height);
                break;
            }
            case 5: {
                transform.rotate(-1.5707963267948966);
                transform.scale(-1.0, 1.0);
                break;
            }
            case 6: {
                transform.translate(height, 0.0);
                transform.rotate(1.5707963267948966);
                break;
            }
            case 7: {
                transform.scale(-1.0, 1.0);
                transform.translate(-height, 0.0);
                transform.translate(0.0, width);
                transform.rotate(4.71238898038469);
                break;
            }
            case 8: {
                transform.translate(0.0, width);
                transform.rotate(4.71238898038469);
            }
        }
        return transform;
    }

    private BufferedImage rotateWithAffineTransform(BufferedImage originalImage, AffineTransform affineTransform) {
        if (affineTransform == null) {
            return originalImage;
        }
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        BufferedImage newImage = new BufferedImage(originalImage.getHeight(), originalImage.getWidth(), originalImage.getType());
        affineTransformOp.filter(originalImage, newImage);
        return newImage;
    }
}

