/*
 * Decompiled with CFR 0.152.
 */
package com.bes.gson;

import com.bes.gson.JsonElement;
import com.bes.gson.JsonIOException;
import com.bes.gson.JsonParseException;
import com.bes.gson.JsonSyntaxException;
import com.bes.gson.internal.Streams;
import com.bes.gson.stream.JsonReader;
import com.bes.gson.stream.JsonToken;
import com.bes.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonStreamParser
implements Iterator<JsonElement> {
    private final JsonReader parser;
    private final Object lock;

    public JsonStreamParser(String json) {
        this(new StringReader(json));
    }

    public JsonStreamParser(Reader reader) {
        this.parser = new JsonReader(reader);
        this.parser.setLenient(true);
        this.lock = new Object();
    }

    @Override
    public JsonElement next() throws JsonParseException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return Streams.parse(this.parser);
        }
        catch (StackOverflowError e2) {
            throw new JsonParseException("Failed parsing JSON source to Json", e2);
        }
        catch (OutOfMemoryError e3) {
            throw new JsonParseException("Failed parsing JSON source to Json", e3);
        }
        catch (JsonParseException e4) {
            throw e4.getCause() instanceof EOFException ? new NoSuchElementException() : e4;
        }
    }

    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.parser.peek() != JsonToken.END_DOCUMENT;
            }
            catch (MalformedJsonException e2) {
                throw new JsonSyntaxException(e2);
            }
            catch (IOException e3) {
                throw new JsonIOException(e3);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

