/*
 * Decompiled with CFR 0.152.
 */
package com.bes.jndi;

import com.bes.enterprise.naming.java.javaURLContextFactory;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;

public class LocalCtxFactory
extends javaURLContextFactory
implements InitialContextFactory {
    private static final String JAVA_URL_CONTEXT = "java";

    public static Context getLocalContext() throws NamingException {
        LocalCtxFactory ctxFactory = new LocalCtxFactory();
        Hashtable<Object, Object> properties = new Hashtable<Object, Object>();
        Context ctx = ctxFactory.getInitialContext(properties);
        Context javaUrlCtx = (Context)ctxFactory.getObjectInstance(null, null, null, properties);
        return new LocalInitialContext(ctx, javaUrlCtx, properties);
    }

    public static Context getJavaURLContext() throws NamingException {
        LocalCtxFactory ctxFactory = new LocalCtxFactory();
        Hashtable properties = new Hashtable();
        Context javaUrlCtx = (Context)ctxFactory.getObjectInstance(null, null, null, properties);
        return javaUrlCtx;
    }

    public static class LocalInitialContext
    implements Context {
        protected Hashtable<Object, Object> myProps = null;
        protected Context defaultCtx = null;
        private Context javaURLContext = null;

        public LocalInitialContext(Context defaultInitCtx, Context javaURLContext, Hashtable<Object, Object> myProps) {
            this.myProps = myProps;
            this.defaultCtx = defaultInitCtx;
            this.javaURLContext = javaURLContext;
        }

        protected Context getDefaultCtx() throws NamingException {
            if (this.defaultCtx == null) {
                this.defaultCtx = LocalCtxFactory.getLocalContext();
            }
            return this.defaultCtx;
        }

        protected Context getJavaURLCtx() throws NamingException {
            if (this.javaURLContext == null) {
                this.javaURLContext = LocalCtxFactory.getJavaURLContext();
            }
            return this.javaURLContext;
        }

        protected Context getURLOrDefaultCtx(String name) throws NamingException {
            String scheme = LocalInitialContext.getURLScheme(name);
            if (scheme != null) {
                if (LocalCtxFactory.JAVA_URL_CONTEXT.equals(scheme)) {
                    return this.getJavaURLCtx();
                }
                Context ctx = NamingManager.getURLContext(scheme, this.myProps);
                if (ctx != null) {
                    return ctx;
                }
            }
            return this.getDefaultCtx();
        }

        protected Context getURLOrDefaultCtx(Name name) throws NamingException {
            String first;
            String scheme;
            if (name.size() > 0 && (scheme = LocalInitialContext.getURLScheme(first = name.get(0))) != null) {
                if (LocalCtxFactory.JAVA_URL_CONTEXT.equals(scheme)) {
                    return this.getJavaURLCtx();
                }
                Context ctx = NamingManager.getURLContext(scheme, this.myProps);
                if (ctx != null) {
                    return ctx;
                }
            }
            return this.getDefaultCtx();
        }

        private static String getURLScheme(String str) {
            int colon_posn = str.indexOf(58);
            int slash_posn = str.indexOf(47);
            if (colon_posn > 0 && (slash_posn == -1 || colon_posn < slash_posn)) {
                return str.substring(0, colon_posn);
            }
            return null;
        }

        @Override
        public Object lookup(Name name) throws NamingException {
            return this.getURLOrDefaultCtx(name).lookup(name);
        }

        @Override
        public Object lookup(String name) throws NamingException {
            return this.getURLOrDefaultCtx(name).lookup(name);
        }

        @Override
        public void bind(Name name, Object obj) throws NamingException {
            this.getURLOrDefaultCtx(name).bind(name, obj);
        }

        @Override
        public void bind(String name, Object obj) throws NamingException {
            this.getURLOrDefaultCtx(name).bind(name, obj);
        }

        @Override
        public void rebind(Name name, Object obj) throws NamingException {
            this.getURLOrDefaultCtx(name).rebind(name, obj);
        }

        @Override
        public void rebind(String name, Object obj) throws NamingException {
            this.getURLOrDefaultCtx(name).rebind(name, obj);
        }

        @Override
        public void unbind(Name name) throws NamingException {
            this.getURLOrDefaultCtx(name).unbind(name);
        }

        @Override
        public void unbind(String name) throws NamingException {
            this.getURLOrDefaultCtx(name).unbind(name);
        }

        @Override
        public void rename(Name oldName, Name newName) throws NamingException {
            this.getURLOrDefaultCtx(oldName).rename(oldName, newName);
        }

        @Override
        public void rename(String oldName, String newName) throws NamingException {
            this.getURLOrDefaultCtx(oldName).rename(oldName, newName);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
            return this.getURLOrDefaultCtx(name).list(name);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
            return this.getURLOrDefaultCtx(name).list(name);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
            return this.getURLOrDefaultCtx(name).listBindings(name);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
            return this.getURLOrDefaultCtx(name).listBindings(name);
        }

        @Override
        public void destroySubcontext(Name name) throws NamingException {
            this.getURLOrDefaultCtx(name).destroySubcontext(name);
        }

        @Override
        public void destroySubcontext(String name) throws NamingException {
            this.getURLOrDefaultCtx(name).destroySubcontext(name);
        }

        @Override
        public Context createSubcontext(Name name) throws NamingException {
            return this.getURLOrDefaultCtx(name).createSubcontext(name);
        }

        @Override
        public Context createSubcontext(String name) throws NamingException {
            return this.getURLOrDefaultCtx(name).createSubcontext(name);
        }

        @Override
        public Object lookupLink(Name name) throws NamingException {
            return this.getURLOrDefaultCtx(name).lookupLink(name);
        }

        @Override
        public Object lookupLink(String name) throws NamingException {
            return this.getURLOrDefaultCtx(name).lookupLink(name);
        }

        @Override
        public NameParser getNameParser(Name name) throws NamingException {
            return this.getURLOrDefaultCtx(name).getNameParser(name);
        }

        @Override
        public NameParser getNameParser(String name) throws NamingException {
            return this.getURLOrDefaultCtx(name).getNameParser(name);
        }

        @Override
        public String composeName(String name, String prefix) throws NamingException {
            return name;
        }

        @Override
        public Name composeName(Name name, Name prefix) throws NamingException {
            return (Name)name.clone();
        }

        @Override
        public Object addToEnvironment(String propName, Object propVal) throws NamingException {
            this.myProps.put(propName, propVal);
            return this.getDefaultCtx().addToEnvironment(propName, propVal);
        }

        @Override
        public Object removeFromEnvironment(String propName) throws NamingException {
            this.myProps.remove(propName);
            return this.getDefaultCtx().removeFromEnvironment(propName);
        }

        @Override
        public Hashtable<?, ?> getEnvironment() throws NamingException {
            return this.getDefaultCtx().getEnvironment();
        }

        @Override
        public void close() throws NamingException {
            this.myProps = null;
            if (this.defaultCtx != null) {
                this.defaultCtx.close();
                this.defaultCtx = null;
            }
            if (this.javaURLContext != null) {
                this.javaURLContext.close();
                this.javaURLContext = null;
            }
        }

        @Override
        public String getNameInNamespace() throws NamingException {
            return this.getDefaultCtx().getNameInNamespace();
        }
    }
}

