/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.JreCompat;
import javax.el.MethodNotFoundException;

class Util {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final CacheValue nullTcclFactory = new CacheValue();
    private static final ConcurrentMap<CacheKey, CacheValue> factoryCache = new ConcurrentHashMap<CacheKey, CacheValue>();

    Util() {
    }

    static void handleThrowable(Throwable t2) {
        if (t2 instanceof ThreadDeath) {
            throw (ThreadDeath)t2;
        }
        if (t2 instanceof VirtualMachineError) {
            throw (VirtualMachineError)t2;
        }
    }

    static String message(ELContext context, String name, Object ... props) {
        Locale locale = null;
        if (context != null) {
            locale = context.getLocale();
        }
        if (locale == null && (locale = Locale.getDefault()) == null) {
            return "";
        }
        ResourceBundle bundle = ResourceBundle.getBundle("javax.el.LocalStrings", locale);
        try {
            String template = bundle.getString(name);
            if (props != null) {
                template = MessageFormat.format(template, props);
            }
            return template;
        }
        catch (MissingResourceException e2) {
            return "Missing Resource: '" + name + "' for Locale " + locale.getDisplayName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExpressionFactory getExpressionFactory() {
        ClassLoader tccl = Util.getContextClassLoader();
        CacheValue cacheValue = null;
        ExpressionFactory factory = null;
        if (tccl == null) {
            cacheValue = nullTcclFactory;
        } else {
            CacheValue newCacheValue;
            CacheKey key = new CacheKey(tccl);
            cacheValue = (CacheValue)factoryCache.get(key);
            if (cacheValue == null && (cacheValue = factoryCache.putIfAbsent(key, newCacheValue = new CacheValue())) == null) {
                cacheValue = newCacheValue;
            }
        }
        Lock readLock = cacheValue.getLock().readLock();
        readLock.lock();
        try {
            factory = cacheValue.getExpressionFactory();
        }
        finally {
            readLock.unlock();
        }
        if (factory == null) {
            Lock writeLock = cacheValue.getLock().writeLock();
            writeLock.lock();
            try {
                factory = cacheValue.getExpressionFactory();
                if (factory == null) {
                    factory = ExpressionFactory.newInstance();
                    cacheValue.setExpressionFactory(factory);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        return factory;
    }

    static Method findMethod(Class<?> clazz, Object base, String methodName, Class<?>[] paramTypes, Object[] paramValues) {
        if (clazz == null || methodName == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", clazz, methodName, Util.paramString(paramTypes)));
        }
        if (paramTypes == null) {
            paramTypes = Util.getTypesFromValues(paramValues);
        }
        Method[] methods = clazz.getMethods();
        List wrappers = Wrapper.wrap(methods, methodName);
        Wrapper result = Util.findWrapper(clazz, wrappers, methodName, paramTypes, paramValues);
        return Util.getMethod(clazz, base, (Method)result.unWrap());
    }

    private static <T> Wrapper<T> findWrapper(Class<?> clazz, List<Wrapper<T>> wrappers, String name, Class<?>[] paramTypes, Object[] paramValues) {
        HashMap<Wrapper<T>, MatchResult> candidates = new HashMap<Wrapper<T>, MatchResult>();
        int paramCount = paramTypes.length;
        for (Wrapper<T> w2 : wrappers) {
            Class<?>[] mParamTypes = w2.getParameterTypes();
            int mParamCount = mParamTypes == null ? 0 : mParamTypes.length;
            if (!w2.isVarArgs() && paramCount != mParamCount || w2.isVarArgs() && paramCount < mParamCount - 1 || w2.isVarArgs() && paramCount == mParamCount && paramValues != null && paramValues.length > paramCount && !paramTypes[mParamCount - 1].isArray() || w2.isVarArgs() && paramCount > mParamCount && paramValues != null && paramValues.length != paramCount || !w2.isVarArgs() && paramValues != null && paramCount != paramValues.length) continue;
            int exactMatch = 0;
            int assignableMatch = 0;
            int coercibleMatch = 0;
            boolean noMatch = false;
            block1: for (int i2 = 0; i2 < mParamCount; ++i2) {
                if (w2.isVarArgs() && i2 == mParamCount - 1) {
                    if (i2 == paramCount || paramValues != null && paramValues.length == i2) {
                        ++assignableMatch;
                        break;
                    }
                    Class<?> varType = mParamTypes[i2].getComponentType();
                    for (int j2 = i2; j2 < paramCount; ++j2) {
                        if (Util.isAssignableFrom(paramTypes[j2], varType)) {
                            ++assignableMatch;
                            continue;
                        }
                        if (paramValues == null) {
                            noMatch = true;
                            continue block1;
                        }
                        if (Util.isCoercibleFrom(paramValues[j2], varType)) {
                            ++coercibleMatch;
                            continue;
                        }
                        noMatch = true;
                        continue block1;
                    }
                    continue;
                }
                if (mParamTypes[i2].equals(paramTypes[i2])) {
                    ++exactMatch;
                    continue;
                }
                if (paramTypes[i2] != null && Util.isAssignableFrom(paramTypes[i2], mParamTypes[i2])) {
                    ++assignableMatch;
                    continue;
                }
                if (paramValues == null) {
                    noMatch = true;
                    break;
                }
                if (Util.isCoercibleFrom(paramValues[i2], mParamTypes[i2])) {
                    ++coercibleMatch;
                    continue;
                }
                noMatch = true;
                break;
            }
            if (noMatch) continue;
            if (exactMatch == paramCount) {
                return w2;
            }
            candidates.put(w2, new MatchResult(exactMatch, assignableMatch, coercibleMatch, w2.isBridge()));
        }
        MatchResult bestMatch = new MatchResult(0, 0, 0, false);
        Wrapper match = null;
        boolean multiple = false;
        for (Map.Entry entry : candidates.entrySet()) {
            int cmp = ((MatchResult)entry.getValue()).compareTo(bestMatch);
            if (cmp > 0 || match == null) {
                bestMatch = (MatchResult)entry.getValue();
                match = (Wrapper)entry.getKey();
                multiple = false;
                continue;
            }
            if (cmp != 0) continue;
            multiple = true;
        }
        if (multiple && (match = bestMatch.getExact() == paramCount - 1 ? Util.resolveAmbiguousWrapper(candidates.keySet(), paramTypes) : null) == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.ambiguous", clazz, name, Util.paramString(paramTypes)));
        }
        if (match == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", clazz, name, Util.paramString(paramTypes)));
        }
        return match;
    }

    private static final String paramString(Class<?>[] types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < types.length; ++i2) {
                if (types[i2] == null) {
                    sb.append("null, ");
                    continue;
                }
                sb.append(types[i2].getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }

    private static <T> Wrapper<T> resolveAmbiguousWrapper(Set<Wrapper<T>> candidates, Class<?>[] paramTypes) {
        Wrapper<T> w2 = candidates.iterator().next();
        int nonMatchIndex = 0;
        Class<?> nonMatchClass = null;
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            if (w2.getParameterTypes()[i2] == paramTypes[i2]) continue;
            nonMatchIndex = i2;
            nonMatchClass = paramTypes[i2];
            break;
        }
        if (nonMatchClass == null) {
            return null;
        }
        for (Wrapper<T> c2 : candidates) {
            if (c2.getParameterTypes()[nonMatchIndex] != paramTypes[nonMatchIndex]) continue;
            return null;
        }
        for (Class superClass = nonMatchClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Wrapper wrapper : candidates) {
                if (!wrapper.getParameterTypes()[nonMatchIndex].equals(superClass)) continue;
                return wrapper;
            }
        }
        Wrapper<T> match = null;
        if (Number.class.isAssignableFrom(nonMatchClass)) {
            for (Wrapper<T> c4 : candidates) {
                Class<?> candidateType = c4.getParameterTypes()[nonMatchIndex];
                if (!Number.class.isAssignableFrom(candidateType) && !candidateType.isPrimitive()) continue;
                if (match == null) {
                    match = c4;
                    continue;
                }
                match = null;
                break;
            }
        }
        return match;
    }

    static boolean isAssignableFrom(Class<?> src, Class<?> target) {
        if (src == null) {
            return true;
        }
        Class<Object> targetClass = target.isPrimitive() ? (target == Boolean.TYPE ? Boolean.class : (target == Character.TYPE ? Character.class : (target == Byte.TYPE ? Byte.class : (target == Short.TYPE ? Short.class : (target == Integer.TYPE ? Integer.class : (target == Long.TYPE ? Long.class : (target == Float.TYPE ? Float.class : Double.class))))))) : target;
        return targetClass.isAssignableFrom(src);
    }

    private static boolean isCoercibleFrom(Object src, Class<?> target) {
        try {
            Util.getExpressionFactory().coerceToType(src, target);
        }
        catch (ELException e2) {
            return false;
        }
        return true;
    }

    private static Class<?>[] getTypesFromValues(Object[] values) {
        if (values == null) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] result = new Class[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            result[i2] = values[i2] == null ? null : values[i2].getClass();
        }
        return result;
    }

    static Method getMethod(Class<?> type, Object base, Method m2) {
        JreCompat jreCompat = JreCompat.getInstance();
        if (m2 == null || Modifier.isPublic(type.getModifiers()) && (jreCompat.canAcccess(base, m2) || base != null && jreCompat.canAcccess(null, m2))) {
            return m2;
        }
        Class<?>[] inf = type.getInterfaces();
        Method mp = null;
        for (int i2 = 0; i2 < inf.length; ++i2) {
            try {
                mp = inf[i2].getMethod(m2.getName(), m2.getParameterTypes());
                mp = Util.getMethod(mp.getDeclaringClass(), base, mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m2.getName(), m2.getParameterTypes());
                mp = Util.getMethod(mp.getDeclaringClass(), base, mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    static Constructor<?> findConstructor(Class<?> clazz, Class<?>[] paramTypes, Object[] paramValues) {
        String methodName = "<init>";
        if (clazz == null) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", null, methodName, Util.paramString(paramTypes)));
        }
        if (paramTypes == null) {
            paramTypes = Util.getTypesFromValues(paramValues);
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        List wrappers = Wrapper.wrap(constructors);
        Wrapper wrapper = Util.findWrapper(clazz, wrappers, methodName, paramTypes, paramValues);
        Constructor constructor = (Constructor)wrapper.unWrap();
        JreCompat jreCompat = JreCompat.getInstance();
        if (!Modifier.isPublic(clazz.getModifiers()) || !jreCompat.canAcccess(null, constructor)) {
            throw new MethodNotFoundException(Util.message(null, "util.method.notfound", clazz, methodName, Util.paramString(paramTypes)));
        }
        return constructor;
    }

    static Object[] buildParameters(Class<?>[] parameterTypes, boolean isVarArgs, Object[] params) {
        ExpressionFactory factory = Util.getExpressionFactory();
        Object[] parameters = null;
        if (parameterTypes.length > 0) {
            parameters = new Object[parameterTypes.length];
            if (params == null) {
                params = EMPTY_OBJECT_ARRAY;
            }
            int paramCount = params.length;
            if (isVarArgs) {
                int varArgIndex = parameterTypes.length - 1;
                for (int i2 = 0; i2 < varArgIndex; ++i2) {
                    parameters[i2] = factory.coerceToType(params[i2], parameterTypes[i2]);
                }
                Class<?> varArgClass = parameterTypes[varArgIndex].getComponentType();
                Object varargs = Array.newInstance(varArgClass, paramCount - varArgIndex);
                for (int i3 = varArgIndex; i3 < paramCount; ++i3) {
                    Array.set(varargs, i3 - varArgIndex, factory.coerceToType(params[i3], varArgClass));
                }
                parameters[varArgIndex] = varargs;
            } else {
                parameters = new Object[parameterTypes.length];
                for (int i4 = 0; i4 < parameterTypes.length; ++i4) {
                    parameters[i4] = factory.coerceToType(params[i4], parameterTypes[i4]);
                }
            }
        }
        return parameters;
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader tccl;
        if (System.getSecurityManager() != null) {
            PrivilegedGetTccl pa = new PrivilegedGetTccl();
            tccl = AccessController.doPrivileged(pa);
        } else {
            tccl = Thread.currentThread().getContextClassLoader();
        }
        return tccl;
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static class MatchResult
    implements Comparable<MatchResult> {
        private final int exact;
        private final int assignable;
        private final int coercible;
        private final boolean bridge;

        public MatchResult(int exact, int assignable, int coercible, boolean bridge) {
            this.exact = exact;
            this.assignable = assignable;
            this.coercible = coercible;
            this.bridge = bridge;
        }

        public int getExact() {
            return this.exact;
        }

        public int getAssignable() {
            return this.assignable;
        }

        public int getCoercible() {
            return this.coercible;
        }

        public boolean isBridge() {
            return this.bridge;
        }

        @Override
        public int compareTo(MatchResult o2) {
            int cmp = Integer.compare(this.getExact(), o2.getExact());
            if (cmp == 0 && (cmp = Integer.compare(this.getAssignable(), o2.getAssignable())) == 0 && (cmp = Integer.compare(this.getCoercible(), o2.getCoercible())) == 0) {
                cmp = Boolean.compare(o2.isBridge(), this.isBridge());
            }
            return cmp;
        }

        public boolean equals(Object o2) {
            return o2 == this || null != o2 && this.getClass().equals(o2.getClass()) && ((MatchResult)o2).getExact() == this.getExact() && ((MatchResult)o2).getAssignable() == this.getAssignable() && ((MatchResult)o2).getCoercible() == this.getCoercible() && ((MatchResult)o2).isBridge() == this.isBridge();
        }

        public int hashCode() {
            return (this.isBridge() ? 0x1000000 : 0) ^ this.getExact() << 16 ^ this.getAssignable() << 8 ^ this.getCoercible();
        }
    }

    private static class ConstructorWrapper
    extends Wrapper<Constructor<?>> {
        private final Constructor<?> c;

        public ConstructorWrapper(Constructor<?> c2) {
            this.c = c2;
        }

        @Override
        public Constructor<?> unWrap() {
            return this.c;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.c.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.c.isVarArgs();
        }

        @Override
        public boolean isBridge() {
            return false;
        }
    }

    private static class MethodWrapper
    extends Wrapper<Method> {
        private final Method m;

        public MethodWrapper(Method m2) {
            this.m = m2;
        }

        @Override
        public Method unWrap() {
            return this.m;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.m.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.m.isVarArgs();
        }

        @Override
        public boolean isBridge() {
            return this.m.isBridge();
        }
    }

    private static abstract class Wrapper<T> {
        private Wrapper() {
        }

        public static List<Wrapper<Method>> wrap(Method[] methods, String name) {
            ArrayList<Wrapper<Method>> result = new ArrayList<Wrapper<Method>>();
            for (Method method : methods) {
                if (!method.getName().equals(name)) continue;
                result.add(new MethodWrapper(method));
            }
            return result;
        }

        public static List<Wrapper<Constructor<?>>> wrap(Constructor<?>[] constructors) {
            ArrayList result = new ArrayList();
            for (Constructor<?> constructor : constructors) {
                result.add(new ConstructorWrapper(constructor));
            }
            return result;
        }

        public abstract T unWrap();

        public abstract Class<?>[] getParameterTypes();

        public abstract boolean isVarArgs();

        public abstract boolean isBridge();
    }

    private static class CacheValue {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private WeakReference<ExpressionFactory> ref;

        public ReadWriteLock getLock() {
            return this.lock;
        }

        public ExpressionFactory getExpressionFactory() {
            return this.ref != null ? (ExpressionFactory)this.ref.get() : null;
        }

        public void setExpressionFactory(ExpressionFactory factory) {
            this.ref = new WeakReference<ExpressionFactory>(factory);
        }
    }

    private static class CacheKey {
        private final int hash;
        private final WeakReference<ClassLoader> ref;

        public CacheKey(ClassLoader key) {
            this.hash = key.hashCode();
            this.ref = new WeakReference<ClassLoader>(key);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            ClassLoader thisKey = (ClassLoader)this.ref.get();
            if (thisKey == null) {
                return false;
            }
            return thisKey == ((CacheKey)obj).ref.get();
        }
    }
}

