/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BatchProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.dispatch.ProcessorInfo;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class BatchAnnotationProcessorManager
extends BaseAnnotationProcessorManager {
    private List<Processor> _setProcessors = null;
    private Iterator<Processor> _setProcessorIter = null;
    private List<String> _commandLineProcessors;
    private Iterator<String> _commandLineProcessorIter = null;
    private ServiceLoader<Processor> _serviceLoader = null;
    private Iterator<Processor> _serviceLoaderIter;
    private ClassLoader _procLoader;
    private static final boolean VERBOSE_PROCESSOR_DISCOVERY = true;
    private boolean _printProcessorDiscovery = false;

    @Override
    public void configure(Object batchCompiler, String[] commandLineArguments) {
        if (this._processingEnv != null) {
            throw new IllegalStateException("Calling configure() more than once on an AnnotationProcessorManager is not supported");
        }
        BatchProcessingEnvImpl processingEnv = new BatchProcessingEnvImpl(this, (Main)batchCompiler, commandLineArguments);
        this._processingEnv = processingEnv;
        JavaFileManager fileManager = processingEnv.getFileManager();
        if (fileManager instanceof StandardJavaFileManager) {
            Iterable<? extends File> location = null;
            if (SourceVersion.latest().compareTo(SourceVersion.RELEASE_8) > 0) {
                location = ((StandardJavaFileManager)fileManager).getLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH);
            }
            this._procLoader = location != null ? fileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH) : fileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        } else {
            this._procLoader = fileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        }
        this.parseCommandLine(commandLineArguments);
        this._round = 0;
    }

    private void parseCommandLine(String[] commandLineArguments) {
        ArrayList<String> commandLineProcessors = null;
        int i2 = 0;
        while (i2 < commandLineArguments.length) {
            String option = commandLineArguments[i2];
            if ("-XprintProcessorInfo".equals(option)) {
                this._printProcessorInfo = true;
                this._printProcessorDiscovery = true;
            } else if ("-XprintRounds".equals(option)) {
                this._printRounds = true;
            } else if ("-processor".equals(option)) {
                commandLineProcessors = new ArrayList<String>();
                String procs = commandLineArguments[++i2];
                commandLineProcessors.addAll(Arrays.asList(procs.split(",")));
                break;
            }
            ++i2;
        }
        this._commandLineProcessors = commandLineProcessors;
        if (this._commandLineProcessors != null) {
            this._commandLineProcessorIter = this._commandLineProcessors.iterator();
        }
    }

    @Override
    public ProcessorInfo discoverNextProcessor() {
        if (this._setProcessors != null) {
            if (this._setProcessorIter.hasNext()) {
                Processor p2 = this._setProcessorIter.next();
                p2.init(this._processingEnv);
                ProcessorInfo pi = new ProcessorInfo(p2);
                this._processors.add(pi);
                if (this._printProcessorDiscovery && this._out != null) {
                    this._out.println("API specified processor: " + pi);
                }
                return pi;
            }
            return null;
        }
        if (this._commandLineProcessors != null) {
            if (this._commandLineProcessorIter.hasNext()) {
                String proc = this._commandLineProcessorIter.next();
                try {
                    Class<?> clazz = this._procLoader.loadClass(proc);
                    Object o2 = clazz.newInstance();
                    Processor p3 = (Processor)o2;
                    p3.init(this._processingEnv);
                    ProcessorInfo pi = new ProcessorInfo(p3);
                    this._processors.add(pi);
                    if (this._printProcessorDiscovery && this._out != null) {
                        this._out.println("Command line specified processor: " + pi);
                    }
                    return pi;
                }
                catch (Exception e2) {
                    throw new AbortCompilation(null, (Throwable)e2);
                }
            }
            return null;
        }
        if (this._serviceLoader == null) {
            this._serviceLoader = ServiceLoader.load(Processor.class, this._procLoader);
            this._serviceLoaderIter = this._serviceLoader.iterator();
        }
        try {
            if (this._serviceLoaderIter.hasNext()) {
                Processor p4 = this._serviceLoaderIter.next();
                p4.init(this._processingEnv);
                ProcessorInfo pi = new ProcessorInfo(p4);
                this._processors.add(pi);
                if (this._printProcessorDiscovery && this._out != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Discovered processor service ");
                    sb.append(pi);
                    sb.append("\n  supporting ");
                    sb.append(pi.getSupportedAnnotationTypesAsString());
                    sb.append("\n  in ");
                    sb.append(this.getProcessorLocation(p4));
                    this._out.println(sb.toString());
                }
                return pi;
            }
        }
        catch (ServiceConfigurationError e3) {
            throw new AbortCompilation(null, (Throwable)e3);
        }
        return null;
    }

    private String getProcessorLocation(Processor p2) {
        String location;
        boolean isMember = false;
        Class<?> outerClass = p2.getClass();
        StringBuilder innerName = new StringBuilder();
        while (outerClass.isMemberClass()) {
            innerName.insert(0, outerClass.getSimpleName());
            innerName.insert(0, '$');
            isMember = true;
            outerClass = outerClass.getEnclosingClass();
        }
        String path = outerClass.getName();
        path = path.replace('.', '/');
        if (isMember) {
            path = String.valueOf(path) + innerName;
        }
        if ((location = this._procLoader.getResource(path = String.valueOf(path) + ".class").toString()).endsWith(path)) {
            location = location.substring(0, location.length() - path.length());
        }
        return location;
    }

    @Override
    public void reportProcessorException(Processor p2, Exception e2) {
        throw new AbortCompilation(null, (Throwable)e2);
    }

    @Override
    public void setProcessors(Object[] processors) {
        if (!this._isFirstRound) {
            throw new IllegalStateException("setProcessors() cannot be called after processing has begun");
        }
        this._setProcessors = new ArrayList<Processor>(processors.length);
        Object[] objectArray = processors;
        int n2 = processors.length;
        int n3 = 0;
        while (n3 < n2) {
            Object o2 = objectArray[n3];
            Processor p2 = (Processor)o2;
            this._setProcessors.add(p2);
            ++n3;
        }
        this._setProcessorIter = this._setProcessors.iterator();
        this._commandLineProcessors = null;
        this._commandLineProcessorIter = null;
    }

    @Override
    protected void cleanUp() {
        if (this._procLoader instanceof URLClassLoader) {
            try {
                ((URLClassLoader)this._procLoader).close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }
}

