/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExportsStatement;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.ast.OpensStatement;
import org.eclipse.jdt.internal.compiler.ast.PackageVisibilityStatement;
import org.eclipse.jdt.internal.compiler.ast.ProvidesStatement;
import org.eclipse.jdt.internal.compiler.ast.RequiresStatement;
import org.eclipse.jdt.internal.compiler.ast.UsesStatement;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleScope;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public class ModuleDeclaration
extends ASTNode
implements ReferenceContext {
    public ExportsStatement[] exports;
    public RequiresStatement[] requires;
    public UsesStatement[] uses;
    public ProvidesStatement[] services;
    public OpensStatement[] opens;
    public Annotation[] annotations;
    public int exportsCount;
    public int requiresCount;
    public int usesCount;
    public int servicesCount;
    public int opensCount;
    public SourceModuleBinding binding;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int bodyStart;
    public int bodyEnd;
    public int modifiersSourceStart;
    public ModuleScope scope;
    public char[][] tokens;
    public char[] moduleName;
    public long[] sourcePositions;
    public int modifiers = 0;
    boolean ignoreFurtherInvestigation;
    boolean hasResolvedModuleDirectives;
    boolean hasResolvedPackageDirectives;
    boolean hasResolvedTypeDirectives;
    CompilationResult compilationResult;

    public ModuleDeclaration(CompilationResult compilationResult, char[][] tokens, long[] positions) {
        this.compilationResult = compilationResult;
        this.exportsCount = 0;
        this.requiresCount = 0;
        this.tokens = tokens;
        this.moduleName = CharOperation.concatWith(tokens, '.');
        this.sourcePositions = positions;
        this.sourceEnd = (int)(positions[positions.length - 1] & 0xFFFFFFFFFFFFFFFFL);
        this.sourceStart = (int)(positions[0] >>> 32);
    }

    public ModuleBinding setBinding(SourceModuleBinding sourceModuleBinding) {
        this.binding = sourceModuleBinding;
        return sourceModuleBinding;
    }

    public void checkAndSetModifiers() {
        int effectiveModifiers;
        int realModifiers = this.modifiers & 0xFFFF;
        int expectedModifiers = 4128;
        if ((realModifiers & ~expectedModifiers) != 0) {
            this.scope.problemReporter().illegalModifierForModule(this);
            realModifiers &= expectedModifiers;
        }
        this.modifiers = this.binding.modifiers = (effectiveModifiers = 0x8000 | realModifiers);
    }

    public boolean isOpen() {
        return (this.modifiers & 0x20) != 0;
    }

    public void createScope(Scope parentScope) {
        this.scope = new ModuleScope(parentScope, this);
    }

    public void generateCode() {
        block4: {
            if ((this.bits & 0x2000) != 0) {
                return;
            }
            this.bits |= 0x2000;
            if (this.ignoreFurtherInvestigation) {
                return;
            }
            try {
                LookupEnvironment env = this.scope.environment();
                ClassFile classFile = env.classFilePool.acquireForModule(this.binding, env.globalOptions);
                classFile.initializeForModule(this.binding);
                classFile.addModuleAttributes(this.binding, this.annotations, this.scope.referenceCompilationUnit());
                this.scope.referenceCompilationUnit().compilationResult.record(this.binding.moduleName, classFile);
            }
            catch (AbortType abortType) {
                if (this.binding != null) break block4;
                return;
            }
        }
    }

    public void resolveModuleDirectives(CompilationUnitScope cuScope) {
        ModuleReference moduleReference;
        int n2;
        int n3;
        ModuleReference[] moduleReferenceArray;
        PackageVisibilityStatement[] packageVisibilityStatementArray;
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (this.hasResolvedModuleDirectives) {
            return;
        }
        this.hasResolvedModuleDirectives = true;
        HashSet<ModuleBinding> requiredModules = new HashSet<ModuleBinding>();
        HashSet<ModuleBinding> requiredTransitiveModules = new HashSet<ModuleBinding>();
        int i2 = 0;
        while (i2 < this.requiresCount) {
            RequiresStatement ref = this.requires[i2];
            if (ref != null && ref.resolve(cuScope) != null) {
                Collection<ModuleBinding> deps;
                if (!requiredModules.add(ref.resolvedBinding)) {
                    cuScope.problemReporter().duplicateModuleReference(8389909, ref.module);
                }
                if (ref.isTransitive()) {
                    requiredTransitiveModules.add(ref.resolvedBinding);
                }
                if ((deps = ref.resolvedBinding.dependencyGraphCollector().get()).contains(this.binding)) {
                    cuScope.problemReporter().cyclicModuleDependency(this.binding, ref.module);
                    requiredModules.remove(ref.module.binding);
                }
            }
            ++i2;
        }
        this.binding.setRequires(requiredModules.toArray(new ModuleBinding[requiredModules.size()]), requiredTransitiveModules.toArray(new ModuleBinding[requiredTransitiveModules.size()]));
        if (this.exports != null) {
            packageVisibilityStatementArray = this.exports;
            int n4 = this.exports.length;
            int n5 = 0;
            while (n5 < n4) {
                PackageVisibilityStatement exportsStatement = packageVisibilityStatementArray[n5];
                if (exportsStatement.isQualified()) {
                    moduleReferenceArray = ((ExportsStatement)exportsStatement).targets;
                    n3 = ((ExportsStatement)exportsStatement).targets.length;
                    n2 = 0;
                    while (n2 < n3) {
                        moduleReference = moduleReferenceArray[n2];
                        moduleReference.resolve(cuScope);
                        ++n2;
                    }
                }
                ++n5;
            }
        }
        if (this.opens != null) {
            packageVisibilityStatementArray = this.opens;
            int n6 = this.opens.length;
            int n7 = 0;
            while (n7 < n6) {
                PackageVisibilityStatement opensStatement = packageVisibilityStatementArray[n7];
                if (opensStatement.isQualified()) {
                    moduleReferenceArray = ((OpensStatement)opensStatement).targets;
                    n3 = ((OpensStatement)opensStatement).targets.length;
                    n2 = 0;
                    while (n2 < n3) {
                        moduleReference = moduleReferenceArray[n2];
                        moduleReference.resolve(cuScope);
                        ++n2;
                    }
                }
                ++n7;
            }
        }
    }

    public void resolvePackageDirectives(CompilationUnitScope cuScope) {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (this.hasResolvedPackageDirectives) {
            return;
        }
        this.hasResolvedPackageDirectives = true;
        HashSet<PlainPackageBinding> exportedPkgs = new HashSet<PlainPackageBinding>();
        int i2 = 0;
        while (i2 < this.exportsCount) {
            ExportsStatement ref = this.exports[i2];
            if (ref != null && ref.resolve(cuScope)) {
                if (!exportedPkgs.add(ref.resolvedPackage)) {
                    cuScope.problemReporter().invalidPackageReference(8389910, ref);
                }
                char[][] targets = null;
                if (ref.targets != null) {
                    targets = new char[ref.targets.length][];
                    int j2 = 0;
                    while (j2 < targets.length) {
                        targets[j2] = ref.targets[j2].moduleName;
                        ++j2;
                    }
                }
                this.binding.addResolvedExport(ref.resolvedPackage, targets);
            }
            ++i2;
        }
        HashtableOfObject openedPkgs = new HashtableOfObject();
        int i3 = 0;
        while (i3 < this.opensCount) {
            OpensStatement ref = this.opens[i3];
            if (this.isOpen()) {
                cuScope.problemReporter().invalidOpensStatement(ref, this);
            } else {
                if (openedPkgs.containsKey(ref.pkgName)) {
                    cuScope.problemReporter().invalidPackageReference(8389921, ref);
                } else {
                    openedPkgs.put(ref.pkgName, ref);
                    ref.resolve(cuScope);
                }
                char[][] targets = null;
                if (ref.targets != null) {
                    targets = new char[ref.targets.length][];
                    int j3 = 0;
                    while (j3 < targets.length) {
                        targets[j3] = ref.targets[j3].moduleName;
                        ++j3;
                    }
                }
                this.binding.addResolvedOpens(ref.resolvedPackage, targets);
            }
            ++i3;
        }
    }

    public void resolveTypeDirectives(CompilationUnitScope cuScope) {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (this.hasResolvedTypeDirectives) {
            return;
        }
        this.hasResolvedTypeDirectives = true;
        ASTNode.resolveAnnotations((BlockScope)this.scope, this.annotations, this.binding);
        HashSet<TypeBinding> allTypes = new HashSet<TypeBinding>();
        int i2 = 0;
        while (i2 < this.usesCount) {
            TypeBinding serviceBinding = this.uses[i2].serviceInterface.resolveType(this.scope);
            if (serviceBinding != null && serviceBinding.isValidBinding()) {
                if (!(serviceBinding.isClass() || serviceBinding.isInterface() || serviceBinding.isAnnotationType())) {
                    cuScope.problemReporter().invalidServiceRef(8389924, this.uses[i2].serviceInterface);
                }
                if (!allTypes.add(this.uses[i2].serviceInterface.resolvedType)) {
                    cuScope.problemReporter().duplicateTypeReference(8389911, this.uses[i2].serviceInterface);
                }
            }
            ++i2;
        }
        this.binding.setUses(allTypes.toArray(new TypeBinding[allTypes.size()]));
        HashSet<TypeBinding> interfaces = new HashSet<TypeBinding>();
        int i3 = 0;
        while (i3 < this.servicesCount) {
            this.services[i3].resolve(this.scope);
            TypeBinding infBinding = this.services[i3].serviceInterface.resolvedType;
            if (infBinding != null && infBinding.isValidBinding()) {
                if (!interfaces.add(this.services[i3].serviceInterface.resolvedType)) {
                    cuScope.problemReporter().duplicateTypeReference(8389912, this.services[i3].serviceInterface);
                }
                this.binding.setImplementations(infBinding, this.services[i3].getResolvedImplementations());
            }
            ++i3;
        }
        this.binding.setServices(interfaces.toArray(new TypeBinding[interfaces.size()]));
    }

    public void analyseCode(CompilationUnitScope skope) {
        this.analyseModuleGraph(skope);
        this.analyseReferencedPackages(skope);
    }

    private void analyseReferencedPackages(CompilationUnitScope skope) {
        if (this.exports != null) {
            this.analyseSomeReferencedPackages(this.exports, skope);
        }
        if (this.opens != null) {
            this.analyseSomeReferencedPackages(this.opens, skope);
        }
    }

    private void analyseSomeReferencedPackages(PackageVisibilityStatement[] stats, CompilationUnitScope skope) {
        PackageVisibilityStatement[] packageVisibilityStatementArray = stats;
        int n2 = stats.length;
        int n3 = 0;
        while (n3 < n2) {
            PackageVisibilityStatement stat = packageVisibilityStatementArray[n3];
            PlainPackageBinding pb = stat.resolvedPackage;
            if (pb != null && !pb.hasCompilationUnit(true)) {
                ModuleBinding[] moduleBindingArray = this.binding.getAllRequiredModules();
                int n4 = moduleBindingArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    ModuleBinding req = moduleBindingArray[n5];
                    PlainPackageBinding[] plainPackageBindingArray = req.getExports();
                    int n6 = plainPackageBindingArray.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        PlainPackageBinding exported = plainPackageBindingArray[n7];
                        if (CharOperation.equals(pb.compoundName, exported.compoundName)) {
                            skope.problemReporter().exportingForeignPackage(stat, req);
                            return;
                        }
                        ++n7;
                    }
                    ++n5;
                }
                skope.problemReporter().invalidPackageReference(8389919, stat);
            }
            ++n3;
        }
    }

    public void analyseModuleGraph(CompilationUnitScope skope) {
        if (this.requires != null) {
            int n2;
            HashMap<String, Set<ModuleBinding>> pack2mods = new HashMap<String, Set<ModuleBinding>>();
            Object[] objectArray = this.binding.getAllRequiredModules();
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ModuleBinding requiredModule = objectArray[n4];
                PlainPackageBinding[] plainPackageBindingArray = requiredModule.getExports();
                n2 = plainPackageBindingArray.length;
                int n5 = 0;
                while (n5 < n2) {
                    PlainPackageBinding exportedPackage = plainPackageBindingArray[n5];
                    if (this.binding.canAccess(exportedPackage)) {
                        String packName = String.valueOf(exportedPackage.readableName());
                        HashSet<ModuleBinding> mods = (HashSet<ModuleBinding>)pack2mods.get(packName);
                        if (mods == null) {
                            mods = new HashSet<ModuleBinding>();
                            pack2mods.put(packName, mods);
                        }
                        mods.add(requiredModule);
                    }
                    ++n5;
                }
                ++n4;
            }
            objectArray = this.requires;
            n3 = this.requires.length;
            n4 = 0;
            while (n4 < n3) {
                Object requiresStat = objectArray[n4];
                ModuleBinding requiredModule = ((RequiresStatement)requiresStat).resolvedBinding;
                if (requiredModule != null) {
                    if (requiredModule.isDeprecated()) {
                        skope.problemReporter().deprecatedModule(((RequiresStatement)requiresStat).module, requiredModule);
                    }
                    this.analyseOneDependency((RequiresStatement)requiresStat, requiredModule, skope, pack2mods);
                    if (((RequiresStatement)requiresStat).isTransitive()) {
                        ModuleBinding[] moduleBindingArray = requiredModule.getAllRequiredModules();
                        int n6 = moduleBindingArray.length;
                        n2 = 0;
                        while (n2 < n6) {
                            ModuleBinding secondLevelModule = moduleBindingArray[n2];
                            this.analyseOneDependency((RequiresStatement)requiresStat, secondLevelModule, skope, pack2mods);
                            ++n2;
                        }
                    }
                }
                ++n4;
            }
        }
    }

    private void analyseOneDependency(RequiresStatement requiresStat, ModuleBinding requiredModule, CompilationUnitScope skope, Map<String, Set<ModuleBinding>> pack2mods) {
        PlainPackageBinding[] plainPackageBindingArray = requiredModule.getExports();
        int n2 = plainPackageBindingArray.length;
        int n3 = 0;
        while (n3 < n2) {
            PlainPackageBinding pack = plainPackageBindingArray[n3];
            Set<ModuleBinding> mods = pack2mods.get(String.valueOf(pack.readableName()));
            if (mods != null && mods.size() > 1) {
                CompilerOptions compilerOptions = skope.compilerOptions();
                boolean inJdtDebugCompileMode = compilerOptions.enableJdtDebugCompileMode;
                if (!inJdtDebugCompileMode) {
                    skope.problemReporter().conflictingPackagesFromModules(pack, mods, requiresStat.sourceStart, requiresStat.sourceEnd);
                }
            }
            ++n3;
        }
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope unitScope) {
        visitor.visit(this, unitScope);
    }

    public StringBuffer printHeader(int indent, StringBuffer output) {
        if (this.annotations != null) {
            int i2 = 0;
            while (i2 < this.annotations.length) {
                this.annotations[i2].print(indent, output);
                if (i2 != this.annotations.length - 1) {
                    output.append(" ");
                }
                ++i2;
            }
            output.append('\n');
        }
        if (this.isOpen()) {
            output.append("open ");
        }
        output.append("module ");
        output.append(CharOperation.charToString(this.moduleName));
        return output;
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        int i2;
        output.append(" {");
        if (this.requires != null) {
            i2 = 0;
            while (i2 < this.requiresCount) {
                output.append('\n');
                ModuleDeclaration.printIndent(indent + 1, output);
                this.requires[i2].print(0, output);
                ++i2;
            }
        }
        if (this.exports != null) {
            i2 = 0;
            while (i2 < this.exportsCount) {
                output.append('\n');
                this.exports[i2].print(indent + 1, output);
                ++i2;
            }
        }
        if (this.opens != null) {
            i2 = 0;
            while (i2 < this.opensCount) {
                output.append('\n');
                this.opens[i2].print(indent + 1, output);
                ++i2;
            }
        }
        if (this.uses != null) {
            i2 = 0;
            while (i2 < this.usesCount) {
                output.append('\n');
                this.uses[i2].print(indent + 1, output);
                ++i2;
            }
        }
        if (this.servicesCount != 0) {
            i2 = 0;
            while (i2 < this.servicesCount) {
                output.append('\n');
                this.services[i2].print(indent + 1, output);
                ++i2;
            }
        }
        output.append('\n');
        return ModuleDeclaration.printIndent(indent, output).append('}');
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        ModuleDeclaration.printIndent(indent, output);
        this.printHeader(0, output);
        return this.printBody(indent, output);
    }

    @Override
    public void abort(int abortLevel, CategorizedProblem problem) {
        switch (abortLevel) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, problem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, problem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, problem);
            }
        }
        throw new AbortType(this.compilationResult, problem);
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    @Override
    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        return this.scope.referenceCompilationUnit();
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    @Override
    public void tagAsHavingIgnoredMandatoryErrors(int problemId) {
    }

    public String getModuleVersion() {
        if (this.scope != null) {
            LookupEnvironment env = this.scope.environment().root;
            return env.moduleVersion;
        }
        return null;
    }
}

