/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ExportsStatement;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.ast.ModuleStatement;
import org.eclipse.jdt.internal.compiler.ast.OpensStatement;
import org.eclipse.jdt.internal.compiler.ast.ProvidesStatement;
import org.eclipse.jdt.internal.compiler.ast.RequiresStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UsesStatement;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.eclipse.jdt.internal.compiler.env.ISourceModule;
import org.eclipse.jdt.internal.compiler.env.ModuleReferenceImpl;
import org.eclipse.jdt.internal.compiler.env.PackageExportImpl;

public class BasicModule
implements ISourceModule {
    private boolean isOpen = false;
    char[] name;
    IModule.IModuleReference[] requires;
    IModule.IPackageExport[] exports;
    char[][] uses;
    Service[] provides;
    IModule.IPackageExport[] opens;
    private ICompilationUnit compilationUnit;

    private static PackageExportImpl createPackageExport(ExportsStatement[] refs, int i2) {
        ExportsStatement ref = refs[i2];
        PackageExportImpl exp = new PackageExportImpl();
        exp.pack = ref.pkgName;
        ModuleReference[] imp = ref.targets;
        if (imp != null) {
            exp.exportedTo = new char[imp.length][];
            int j2 = 0;
            while (j2 < imp.length) {
                exp.exportedTo = imp[j2].tokens;
                ++j2;
            }
        }
        return exp;
    }

    private static Service createService(TypeReference service, TypeReference[] with) {
        Service ser = new Service();
        ser.provides = CharOperation.concatWith(service.getTypeName(), '.');
        ser.with = new char[with.length][];
        int i2 = 0;
        while (i2 < with.length) {
            ser.with[i2] = CharOperation.concatWith(with[i2].getTypeName(), '.');
            ++i2;
        }
        return ser;
    }

    private static PackageExportImpl createPackageOpen(OpensStatement ref) {
        PackageExportImpl exp = new PackageExportImpl();
        exp.pack = ref.pkgName;
        ModuleReference[] imp = ref.targets;
        if (imp != null) {
            exp.exportedTo = new char[imp.length][];
            int j2 = 0;
            while (j2 < imp.length) {
                exp.exportedTo = imp[j2].tokens;
                ++j2;
            }
        }
        return exp;
    }

    public BasicModule(ModuleDeclaration descriptor, IModulePathEntry root) {
        PackageExportImpl exp;
        int i2;
        ModuleStatement[] refs;
        this.compilationUnit = descriptor.compilationResult().compilationUnit;
        this.name = descriptor.moduleName;
        if (descriptor.requiresCount > 0) {
            refs = descriptor.requires;
            this.requires = new ModuleReferenceImpl[refs.length];
            i2 = 0;
            while (i2 < refs.length) {
                ModuleReferenceImpl ref = new ModuleReferenceImpl();
                ref.name = CharOperation.concatWith(((RequiresStatement)refs[i2]).module.tokens, '.');
                ref.modifiers = ((RequiresStatement)refs[i2]).modifiers;
                this.requires[i2] = ref;
                ++i2;
            }
        } else {
            this.requires = new ModuleReferenceImpl[0];
        }
        if (descriptor.exportsCount > 0) {
            refs = descriptor.exports;
            this.exports = new PackageExportImpl[refs.length];
            i2 = 0;
            while (i2 < refs.length) {
                exp = BasicModule.createPackageExport((ExportsStatement[])refs, i2);
                this.exports[i2] = exp;
                ++i2;
            }
        } else {
            this.exports = new PackageExportImpl[0];
        }
        if (descriptor.usesCount > 0) {
            UsesStatement[] u2 = descriptor.uses;
            this.uses = new char[u2.length][];
            i2 = 0;
            while (i2 < u2.length) {
                this.uses[i2] = CharOperation.concatWith(u2[i2].serviceInterface.getTypeName(), '.');
                ++i2;
            }
        }
        if (descriptor.servicesCount > 0) {
            ProvidesStatement[] services = descriptor.services;
            this.provides = new Service[descriptor.servicesCount];
            i2 = 0;
            while (i2 < descriptor.servicesCount) {
                this.provides[i2] = BasicModule.createService(services[i2].serviceInterface, services[i2].implementations);
                ++i2;
            }
        }
        if (descriptor.opensCount > 0) {
            refs = descriptor.opens;
            this.opens = new PackageExportImpl[refs.length];
            i2 = 0;
            while (i2 < refs.length) {
                exp = BasicModule.createPackageOpen((OpensStatement)refs[i2]);
                this.opens[i2] = exp;
                ++i2;
            }
        } else {
            this.opens = new PackageExportImpl[0];
        }
        this.isOpen = descriptor.isOpen();
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    @Override
    public char[] name() {
        return this.name;
    }

    @Override
    public IModule.IModuleReference[] requires() {
        return this.requires;
    }

    @Override
    public IModule.IPackageExport[] exports() {
        return this.exports;
    }

    @Override
    public char[][] uses() {
        return this.uses;
    }

    @Override
    public IModule.IService[] provides() {
        return this.provides;
    }

    @Override
    public IModule.IPackageExport[] opens() {
        return this.opens;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof IModule)) {
            return false;
        }
        IModule mod = (IModule)o2;
        if (!CharOperation.equals(this.name, mod.name())) {
            return false;
        }
        return Arrays.equals(this.requires, mod.requires());
    }

    public int hashCode() {
        int result = 17;
        int c2 = CharOperation.hashCode(this.name);
        result = 31 * result + c2;
        c2 = Arrays.hashCode(this.requires);
        result = 31 * result + c2;
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        this.toStringContent(buffer);
        return buffer.toString();
    }

    protected void toStringContent(StringBuffer buffer) {
        int n2;
        int n3;
        Object object;
        int i2;
        buffer.append("\nmodule ");
        buffer.append(this.name).append(' ');
        buffer.append('{').append('\n');
        if (this.requires != null) {
            i2 = 0;
            while (i2 < this.requires.length) {
                buffer.append("\trequires ");
                if (this.requires[i2].isTransitive()) {
                    buffer.append(" public ");
                }
                buffer.append(this.requires[i2].name());
                buffer.append(';').append('\n');
                ++i2;
            }
        }
        if (this.exports != null) {
            buffer.append('\n');
            i2 = 0;
            while (i2 < this.exports.length) {
                buffer.append("\texports ");
                buffer.append(this.exports[i2].toString());
                ++i2;
            }
        }
        if (this.uses != null) {
            buffer.append('\n');
            object = this.uses;
            n3 = this.uses.length;
            n2 = 0;
            while (n2 < n3) {
                char[] cs = object[n2];
                buffer.append(cs);
                buffer.append(';').append('\n');
                ++n2;
            }
        }
        if (this.provides != null) {
            buffer.append('\n');
            object = this.provides;
            n3 = this.provides.length;
            n2 = 0;
            while (n2 < n3) {
                char[] ser = object[n2];
                buffer.append(ser.toString());
                ++n2;
            }
        }
        buffer.append('\n').append('}').toString();
    }

    static class Service
    implements IModule.IService {
        char[] provides;
        char[][] with;

        Service() {
        }

        @Override
        public char[] name() {
            return this.provides;
        }

        @Override
        public char[][] with() {
            return this.with;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("provides");
            buffer.append(this.provides);
            buffer.append(" with ");
            buffer.append(this.with);
            buffer.append(';');
            return buffer.toString();
        }
    }
}

