/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class Sorting {
    public static ReferenceBinding[] sortTypes(ReferenceBinding[] types) {
        int len = types.length;
        ReferenceBinding[] unsorted = new ReferenceBinding[len];
        ReferenceBinding[] sorted = new ReferenceBinding[len];
        System.arraycopy(types, 0, unsorted, 0, len);
        int o2 = 0;
        int i2 = 0;
        while (i2 < len) {
            o2 = Sorting.sort(unsorted, i2, sorted, o2);
            ++i2;
        }
        return sorted;
    }

    private static int sort(ReferenceBinding[] input, int i2, ReferenceBinding[] output, int o2) {
        if (input[i2] == null) {
            return o2;
        }
        ReferenceBinding superclass = input[i2].superclass();
        o2 = Sorting.sortSuper(superclass, input, output, o2);
        ReferenceBinding[] superInterfaces = input[i2].superInterfaces();
        int j2 = 0;
        while (j2 < superInterfaces.length) {
            o2 = Sorting.sortSuper(superInterfaces[j2], input, output, o2);
            ++j2;
        }
        output[o2++] = input[i2];
        input[i2] = null;
        return o2;
    }

    private static int sortSuper(ReferenceBinding superclass, ReferenceBinding[] input, ReferenceBinding[] output, int o2) {
        if (superclass.id != 1) {
            int j2 = 0;
            j2 = 0;
            while (j2 < input.length) {
                if (TypeBinding.equalsEquals(input[j2], superclass)) break;
                ++j2;
            }
            if (j2 < input.length) {
                o2 = Sorting.sort(input, j2, output, o2);
            }
        }
        return o2;
    }

    public static MethodBinding[] concreteFirst(MethodBinding[] methods, int length) {
        if (length == 0 || length > 0 && !methods[0].isAbstract()) {
            return methods;
        }
        MethodBinding[] copy = new MethodBinding[length];
        int idx = 0;
        int i2 = 0;
        while (i2 < length) {
            if (!methods[i2].isAbstract()) {
                copy[idx++] = methods[i2];
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < length) {
            if (methods[i2].isAbstract()) {
                copy[idx++] = methods[i2];
            }
            ++i2;
        }
        return copy;
    }

    public static MethodBinding[] abstractFirst(MethodBinding[] methods, int length) {
        if (length == 0 || length > 0 && methods[0].isAbstract()) {
            return methods;
        }
        MethodBinding[] copy = new MethodBinding[length];
        int idx = 0;
        int i2 = 0;
        while (i2 < length) {
            if (methods[i2].isAbstract()) {
                copy[idx++] = methods[i2];
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < length) {
            if (!methods[i2].isAbstract()) {
                copy[idx++] = methods[i2];
            }
            ++i2;
        }
        return copy;
    }

    public static void sortInferenceVariables(InferenceVariable[] variables) {
        Arrays.sort(variables, new Comparator<InferenceVariable>(){

            @Override
            public int compare(InferenceVariable iv1, InferenceVariable iv2) {
                return iv1.rank - iv2.rank;
            }
        });
    }
}

