/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.tidb.mysql.fabric.jdbc;

import com.kingdee.tidb.mysql.fabric.FabricCommunicationException;
import com.kingdee.tidb.mysql.fabric.jdbc.FabricMySQLConnectionProxy;
import com.kingdee.tidb.mysql.jdbc.Connection;
import com.kingdee.tidb.mysql.jdbc.ConnectionImpl;
import com.kingdee.tidb.mysql.jdbc.ExceptionInterceptor;
import com.kingdee.tidb.mysql.jdbc.MySQLConnection;
import com.kingdee.tidb.mysql.jdbc.SQLError;
import java.sql.SQLException;
import java.util.Properties;

public class ErrorReportingExceptionInterceptor
implements ExceptionInterceptor {
    private String hostname;
    private String port;
    private String fabricHaGroup;

    public SQLException interceptException(SQLException sqlEx, Connection conn) {
        MySQLConnection mysqlConn = (MySQLConnection)conn;
        if (ConnectionImpl.class.isAssignableFrom(mysqlConn.getMultiHostSafeProxy().getClass())) {
            return null;
        }
        FabricMySQLConnectionProxy fabricProxy = (FabricMySQLConnectionProxy)mysqlConn.getMultiHostSafeProxy();
        try {
            return fabricProxy.interceptException(sqlEx, conn, this.fabricHaGroup, this.hostname, this.port);
        }
        catch (FabricCommunicationException ex) {
            return SQLError.createSQLException("Failed to report error to Fabric.", "08S01", ex, null);
        }
    }

    public void init(Connection conn, Properties props) throws SQLException {
        this.hostname = props.getProperty("HOST");
        this.port = props.getProperty("PORT");
        String connectionAttributes = props.getProperty("connectionAttributes");
        this.fabricHaGroup = connectionAttributes.replaceAll("^.*\\bfabricHaGroup:(.+)\\b.*$", "$1");
    }

    public void destroy() {
    }
}

