/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.tidb.mysql.jdbc;

import com.kingdee.tidb.mysql.jdbc.MySQLConnection;
import com.kingdee.tidb.mysql.jdbc.NetworkResources;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AbandonedConnectionCleanupThread
implements Runnable {
    private static final Map<ConnectionFinalizerPhantomReference, ConnectionFinalizerPhantomReference> connectionFinalizerPhantomRefs;
    private static final ReferenceQueue<MySQLConnection> referenceQueue;
    private static final ExecutorService cleanupThreadExcecutorService;
    static Thread threadRef;
    private static Lock threadRefLock;

    private AbandonedConnectionCleanupThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.checkThreadContextClassLoader();
                    Reference<MySQLConnection> reference = referenceQueue.remove(5000L);
                    if (reference == null) continue;
                    AbandonedConnectionCleanupThread.finalizeResource((ConnectionFinalizerPhantomReference)reference);
                }
            }
            catch (InterruptedException e) {
                threadRefLock.lock();
                try {
                    Reference<MySQLConnection> reference;
                    threadRef = null;
                    while ((reference = referenceQueue.poll()) != null) {
                        AbandonedConnectionCleanupThread.finalizeResource((ConnectionFinalizerPhantomReference)reference);
                    }
                    connectionFinalizerPhantomRefs.clear();
                    Object var4_5 = null;
                    threadRefLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    threadRefLock.unlock();
                    throw throwable;
                }
                return;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private void checkThreadContextClassLoader() {
        try {
            threadRef.getContextClassLoader().getResource("");
        }
        catch (Throwable e) {
            AbandonedConnectionCleanupThread.uncheckedShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean consistentClassLoaders() {
        block3: {
            threadRefLock.lock();
            try {
                if (threadRef != null) break block3;
                boolean bl = false;
                Object var4_2 = null;
                threadRefLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                threadRefLock.unlock();
                throw throwable;
            }
        }
        ClassLoader callerCtxClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader threadCtxClassLoader = threadRef.getContextClassLoader();
        boolean bl = callerCtxClassLoader != null && threadCtxClassLoader != null && callerCtxClassLoader == threadCtxClassLoader;
        Object var4_3 = null;
        threadRefLock.unlock();
        return bl;
    }

    private static void shutdown(boolean checked) {
        if (checked && !AbandonedConnectionCleanupThread.consistentClassLoaders()) {
            return;
        }
        cleanupThreadExcecutorService.shutdownNow();
    }

    public static void checkedShutdown() {
        AbandonedConnectionCleanupThread.shutdown(true);
    }

    public static void uncheckedShutdown() {
        AbandonedConnectionCleanupThread.shutdown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAlive() {
        threadRefLock.lock();
        try {
            boolean bl = threadRef != null && threadRef.isAlive();
            Object var2_1 = null;
            threadRefLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            threadRefLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void trackConnection(MySQLConnection conn, NetworkResources io) {
        threadRefLock.lock();
        try {
            if (AbandonedConnectionCleanupThread.isAlive()) {
                ConnectionFinalizerPhantomReference reference = new ConnectionFinalizerPhantomReference(conn, io, referenceQueue);
                connectionFinalizerPhantomRefs.put(reference, reference);
            }
            Object var4_3 = null;
            threadRefLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            threadRefLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finalizeResource(ConnectionFinalizerPhantomReference reference) {
        try {
            reference.finalizeResources();
            reference.clear();
            Object var2_1 = null;
            connectionFinalizerPhantomRefs.remove(reference);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            connectionFinalizerPhantomRefs.remove(reference);
            throw throwable;
        }
    }

    public static Thread getThread() {
        return threadRef;
    }

    static {
        referenceQueue = new ReferenceQueue();
        threadRef = null;
        threadRefLock = new ReentrantLock();
        connectionFinalizerPhantomRefs = new ConcurrentHashMap<ConnectionFinalizerPhantomReference, ConnectionFinalizerPhantomReference>();
        cleanupThreadExcecutorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "mysql-cj-abandoned-connection-cleanup");
                t.setDaemon(true);
                ClassLoader classLoader = AbandonedConnectionCleanupThread.class.getClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                t.setContextClassLoader(classLoader);
                threadRef = t;
                return threadRef;
            }
        });
        cleanupThreadExcecutorService.execute(new AbandonedConnectionCleanupThread());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectionFinalizerPhantomReference
    extends PhantomReference<MySQLConnection> {
        private NetworkResources networkResources;

        ConnectionFinalizerPhantomReference(MySQLConnection conn, NetworkResources networkResources, ReferenceQueue<? super MySQLConnection> refQueue) {
            super(conn, refQueue);
            this.networkResources = networkResources;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finalizeResources() {
            if (this.networkResources != null) {
                try {
                    this.networkResources.forceClose();
                    Object var2_1 = null;
                    this.networkResources = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.networkResources = null;
                    throw throwable;
                }
            }
        }
    }
}

