/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.tidb.mysql.jdbc.authentication;

import com.kingdee.tidb.mysql.jdbc.Buffer;
import com.kingdee.tidb.mysql.jdbc.Connection;
import com.kingdee.tidb.mysql.jdbc.Messages;
import com.kingdee.tidb.mysql.jdbc.MySQLConnection;
import com.kingdee.tidb.mysql.jdbc.SQLError;
import com.kingdee.tidb.mysql.jdbc.Security;
import com.kingdee.tidb.mysql.jdbc.StringUtils;
import com.kingdee.tidb.mysql.jdbc.authentication.Sha256PasswordPlugin;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingSha2PasswordPlugin
extends Sha256PasswordPlugin {
    public static String PLUGIN_NAME = "caching_sha2_password";
    private AuthStage stage = AuthStage.FAST_AUTH_SEND_SCRAMBLE;

    @Override
    public void init(Connection conn, Properties props) throws SQLException {
        super.init(conn, props);
        this.stage = AuthStage.FAST_AUTH_SEND_SCRAMBLE;
    }

    @Override
    public void destroy() {
        this.stage = AuthStage.FAST_AUTH_SEND_SCRAMBLE;
        super.destroy();
    }

    @Override
    public String getProtocolPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean nextAuthenticationStep(Buffer fromServer, List<Buffer> toServer) throws SQLException {
        toServer.clear();
        if (this.password == null || this.password.length() == 0 || fromServer == null) {
            Buffer bresp = new Buffer(new byte[]{0});
            toServer.add(bresp);
        } else {
            if (this.stage == AuthStage.FAST_AUTH_SEND_SCRAMBLE) {
                this.seed = fromServer.readString();
                try {
                    toServer.add(new Buffer(Security.scrambleCachingSha2(StringUtils.getBytes(this.password, this.connection.getPasswordCharacterEncoding()), this.seed.getBytes())));
                }
                catch (DigestException e) {
                    throw SQLError.createSQLException(e.getMessage(), "S1000", e, null);
                }
                catch (UnsupportedEncodingException e) {
                    throw SQLError.createSQLException(e.getMessage(), "S1000", e, null);
                }
                this.stage = AuthStage.FAST_AUTH_READ_RESULT;
                return true;
            }
            if (this.stage == AuthStage.FAST_AUTH_READ_RESULT) {
                byte fastAuthResult = fromServer.getByteBuffer()[0];
                switch (fastAuthResult) {
                    case 3: {
                        this.stage = AuthStage.FAST_AUTH_COMPLETE;
                        return true;
                    }
                    case 4: {
                        this.stage = AuthStage.FULL_AUTH;
                        break;
                    }
                    default: {
                        throw SQLError.createSQLException("Unknown server response after fast auth.", "08001", this.connection.getExceptionInterceptor());
                    }
                }
            }
            if (((MySQLConnection)this.connection).getIO().isSSLEstablished()) {
                Buffer bresp;
                try {
                    bresp = new Buffer(StringUtils.getBytes(this.password, this.connection.getPasswordCharacterEncoding()));
                }
                catch (UnsupportedEncodingException e) {
                    throw SQLError.createSQLException(Messages.getString("Sha256PasswordPlugin.3", new Object[]{this.connection.getPasswordCharacterEncoding()}), "S1000", null);
                }
                bresp.setPosition(bresp.getBufLength());
                int oldBufLength = bresp.getBufLength();
                bresp.writeByte((byte)0);
                bresp.setBufLength(oldBufLength + 1);
                bresp.setPosition(0);
                toServer.add(bresp);
            } else if (this.connection.getServerRSAPublicKeyFile() != null) {
                Buffer bresp = new Buffer(this.encryptPassword());
                toServer.add(bresp);
            } else {
                if (!this.connection.getAllowPublicKeyRetrieval()) {
                    throw SQLError.createSQLException(Messages.getString("Sha256PasswordPlugin.2"), "08001", this.connection.getExceptionInterceptor());
                }
                if (this.publicKeyRequested && fromServer.getBufLength() > 20) {
                    this.publicKeyString = fromServer.readString();
                    Buffer bresp = new Buffer(this.encryptPassword());
                    toServer.add(bresp);
                    this.publicKeyRequested = false;
                } else {
                    Buffer bresp = new Buffer(new byte[]{2});
                    toServer.add(bresp);
                    this.publicKeyRequested = true;
                }
            }
        }
        return true;
    }

    @Override
    protected byte[] encryptPassword() throws SQLException {
        if (this.connection.versionMeetsMinimum(8, 0, 5)) {
            return super.encryptPassword();
        }
        return super.encryptPassword("RSA/ECB/PKCS1Padding");
    }

    @Override
    public void reset() {
        this.stage = AuthStage.FAST_AUTH_SEND_SCRAMBLE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthStage {
        FAST_AUTH_SEND_SCRAMBLE,
        FAST_AUTH_READ_RESULT,
        FAST_AUTH_COMPLETE,
        FULL_AUTH;

    }
}

