/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.tidb.mysql.jdbc.profiler;

import com.kingdee.tidb.mysql.jdbc.Connection;
import com.kingdee.tidb.mysql.jdbc.Constants;
import com.kingdee.tidb.mysql.jdbc.MySQLConnection;
import com.kingdee.tidb.mysql.jdbc.ResultSetInternalMethods;
import com.kingdee.tidb.mysql.jdbc.Statement;
import com.kingdee.tidb.mysql.jdbc.log.Log;
import com.kingdee.tidb.mysql.jdbc.profiler.ProfilerEvent;
import com.kingdee.tidb.mysql.jdbc.profiler.ProfilerEventHandler;
import java.sql.SQLException;
import java.util.Properties;

public class LoggingProfilerEventHandler
implements ProfilerEventHandler {
    private Log log;

    public void consumeEvent(ProfilerEvent evt) {
        switch (evt.getEventType()) {
            case 0: {
                this.log.logWarn(evt);
                break;
            }
            default: {
                this.log.logInfo(evt);
            }
        }
    }

    public void destroy() {
        this.log = null;
    }

    public void init(Connection conn, Properties props) throws SQLException {
        this.log = conn.getLog();
    }

    public void processEvent(byte eventType, MySQLConnection conn, Statement stmt, ResultSetInternalMethods resultSet, long eventDuration, Throwable eventCreationPoint, String message) {
        String catalog = "";
        try {
            if (conn != null) {
                catalog = conn.getCatalog();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        this.consumeEvent(new ProfilerEvent(eventType, conn == null ? "" : conn.getHost(), catalog, conn == null ? -1L : conn.getId(), stmt == null ? -1 : stmt.getId(), resultSet == null ? -1 : resultSet.getId(), eventDuration, conn == null ? Constants.MILLIS_I18N : conn.getQueryTimingUnits(), eventCreationPoint, message));
    }
}

