/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.tidb.mysql.jdbc.profiler;

import com.kingdee.tidb.mysql.jdbc.StringUtils;
import com.kingdee.tidb.mysql.jdbc.log.LogUtils;
import java.util.Date;

public class ProfilerEvent {
    public static final byte TYPE_USAGE = 0;
    public static final byte TYPE_WARN = 0;
    public static final byte TYPE_OBJECT_CREATION = 1;
    public static final byte TYPE_PREPARE = 2;
    public static final byte TYPE_QUERY = 3;
    public static final byte TYPE_EXECUTE = 4;
    public static final byte TYPE_FETCH = 5;
    public static final byte TYPE_SLOW_QUERY = 6;
    public static final byte NA = -1;
    protected byte eventType;
    protected String hostName;
    protected String catalog;
    protected long connectionId;
    protected int statementId;
    protected int resultSetId;
    protected long eventCreationTime;
    protected long eventDuration;
    protected String durationUnits;
    protected String eventCreationPointDesc;
    protected String message;
    public int hostNameIndex;
    public int catalogIndex;
    public int eventCreationPointIndex;

    public ProfilerEvent(byte eventType, String hostName, String catalog, long connectionId, int statementId, int resultSetId, long eventDuration, String durationUnits, Throwable eventCreationPoint, String message) {
        this(eventType, hostName, catalog, connectionId, statementId, resultSetId, System.currentTimeMillis(), eventDuration, durationUnits, LogUtils.findCallingClassAndMethod(eventCreationPoint), message, -1, -1, -1);
    }

    private ProfilerEvent(byte eventType, String hostName, String catalog, long connectionId, int statementId, int resultSetId, long eventCreationTime, long eventDuration, String durationUnits, String eventCreationPointDesc, String message, int hostNameIndex, int catalogIndex, int eventCreationPointIndex) {
        this.eventType = eventType;
        this.hostName = hostName == null ? "" : hostName;
        this.catalog = catalog == null ? "" : catalog;
        this.connectionId = connectionId;
        this.statementId = statementId;
        this.resultSetId = resultSetId;
        this.eventCreationTime = eventCreationTime;
        this.eventDuration = eventDuration;
        this.durationUnits = durationUnits == null ? "" : durationUnits;
        this.eventCreationPointDesc = eventCreationPointDesc == null ? "" : eventCreationPointDesc;
        this.message = message == null ? "" : message;
        this.hostNameIndex = hostNameIndex;
        this.catalogIndex = catalogIndex;
        this.eventCreationPointIndex = eventCreationPointIndex;
    }

    public byte getEventType() {
        return this.eventType;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public int getResultSetId() {
        return this.resultSetId;
    }

    public long getEventCreationTime() {
        return this.eventCreationTime;
    }

    public long getEventDuration() {
        return this.eventDuration;
    }

    public String getDurationUnits() {
        return this.durationUnits;
    }

    public String getEventCreationPointAsString() {
        return this.eventCreationPointDesc;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        switch (this.getEventType()) {
            case 4: {
                buf.append("EXECUTE");
                break;
            }
            case 5: {
                buf.append("FETCH");
                break;
            }
            case 1: {
                buf.append("CONSTRUCT");
                break;
            }
            case 2: {
                buf.append("PREPARE");
                break;
            }
            case 3: {
                buf.append("QUERY");
                break;
            }
            case 0: {
                buf.append("USAGE ADVISOR");
                break;
            }
            case 6: {
                buf.append("SLOW QUERY");
                break;
            }
            default: {
                buf.append("UNKNOWN");
            }
        }
        buf.append("] ");
        buf.append(this.message);
        buf.append(" [Created on: ");
        buf.append(new Date(this.eventCreationTime));
        buf.append(", duration: ");
        buf.append(this.eventDuration);
        buf.append(", connection-id: ");
        buf.append(this.connectionId);
        buf.append(", statement-id: ");
        buf.append(this.statementId);
        buf.append(", resultset-id: ");
        buf.append(this.resultSetId);
        buf.append(",");
        buf.append(this.eventCreationPointDesc);
        buf.append(", hostNameIndex: ");
        buf.append(this.hostNameIndex);
        buf.append(", catalogIndex: ");
        buf.append(this.catalogIndex);
        buf.append(", eventCreationPointIndex: ");
        buf.append(this.eventCreationPointIndex);
        buf.append("]");
        return buf.toString();
    }

    public static ProfilerEvent unpack(byte[] buf) throws Exception {
        int pos = 0;
        byte eventType = buf[pos++];
        byte[] host = ProfilerEvent.readBytes(buf, pos);
        byte[] db = ProfilerEvent.readBytes(buf, pos += 4 + host.length);
        long connectionId = ProfilerEvent.readLong(buf, pos += 4 + db.length);
        int statementId = ProfilerEvent.readInt(buf, pos += 8);
        int resultSetId = ProfilerEvent.readInt(buf, pos += 4);
        long eventCreationTime = ProfilerEvent.readLong(buf, pos += 4);
        long eventDuration = ProfilerEvent.readLong(buf, pos += 8);
        byte[] eventDurationUnits = ProfilerEvent.readBytes(buf, pos += 8);
        byte[] eventCreationAsBytes = ProfilerEvent.readBytes(buf, pos += 4 + eventDurationUnits.length);
        byte[] message = ProfilerEvent.readBytes(buf, pos += 4 + eventCreationAsBytes.length);
        int hostNameIndex = ProfilerEvent.readInt(buf, pos += 4 + message.length);
        int catalogIndex = ProfilerEvent.readInt(buf, pos += 4);
        int eventCreationPointIndex = ProfilerEvent.readInt(buf, pos += 4);
        pos += 4;
        return new ProfilerEvent(eventType, StringUtils.toString(host, "ISO8859_1"), StringUtils.toString(db, "ISO8859_1"), connectionId, statementId, resultSetId, eventCreationTime, eventDuration, StringUtils.toString(eventDurationUnits, "ISO8859_1"), StringUtils.toString(eventCreationAsBytes, "ISO8859_1"), StringUtils.toString(message, "ISO8859_1"), hostNameIndex, catalogIndex, eventCreationPointIndex);
    }

    public byte[] pack() throws Exception {
        byte[] hostNameAsBytes = StringUtils.getBytes(this.hostName, "ISO8859_1");
        byte[] dbAsBytes = StringUtils.getBytes(this.catalog, "ISO8859_1");
        byte[] durationUnitsAsBytes = StringUtils.getBytes(this.durationUnits, "ISO8859_1");
        byte[] eventCreationAsBytes = StringUtils.getBytes(this.eventCreationPointDesc, "ISO8859_1");
        byte[] messageAsBytes = StringUtils.getBytes(this.message, "ISO8859_1");
        int len = 1 + (4 + hostNameAsBytes.length) + (4 + dbAsBytes.length) + 8 + 4 + 4 + 8 + 8 + (4 + durationUnitsAsBytes.length) + (4 + eventCreationAsBytes.length) + (4 + messageAsBytes.length) + 4 + 4 + 4;
        byte[] buf = new byte[len];
        int pos = 0;
        buf[pos++] = this.eventType;
        pos = ProfilerEvent.writeBytes(hostNameAsBytes, buf, pos);
        pos = ProfilerEvent.writeBytes(dbAsBytes, buf, pos);
        pos = ProfilerEvent.writeLong(this.connectionId, buf, pos);
        pos = ProfilerEvent.writeInt(this.statementId, buf, pos);
        pos = ProfilerEvent.writeInt(this.resultSetId, buf, pos);
        pos = ProfilerEvent.writeLong(this.eventCreationTime, buf, pos);
        pos = ProfilerEvent.writeLong(this.eventDuration, buf, pos);
        pos = ProfilerEvent.writeBytes(durationUnitsAsBytes, buf, pos);
        pos = ProfilerEvent.writeBytes(eventCreationAsBytes, buf, pos);
        pos = ProfilerEvent.writeBytes(messageAsBytes, buf, pos);
        pos = ProfilerEvent.writeInt(this.hostNameIndex, buf, pos);
        pos = ProfilerEvent.writeInt(this.catalogIndex, buf, pos);
        pos = ProfilerEvent.writeInt(this.eventCreationPointIndex, buf, pos);
        return buf;
    }

    private static int writeInt(int i, byte[] buf, int pos) {
        buf[pos++] = (byte)(i & 0xFF);
        buf[pos++] = (byte)(i >>> 8);
        buf[pos++] = (byte)(i >>> 16);
        buf[pos++] = (byte)(i >>> 24);
        return pos;
    }

    private static int writeLong(long l, byte[] buf, int pos) {
        buf[pos++] = (byte)(l & 0xFFL);
        buf[pos++] = (byte)(l >>> 8);
        buf[pos++] = (byte)(l >>> 16);
        buf[pos++] = (byte)(l >>> 24);
        buf[pos++] = (byte)(l >>> 32);
        buf[pos++] = (byte)(l >>> 40);
        buf[pos++] = (byte)(l >>> 48);
        buf[pos++] = (byte)(l >>> 56);
        return pos;
    }

    private static int writeBytes(byte[] msg, byte[] buf, int pos) {
        pos = ProfilerEvent.writeInt(msg.length, buf, pos);
        System.arraycopy(msg, 0, buf, pos, msg.length);
        return pos + msg.length;
    }

    private static int readInt(byte[] buf, int pos) {
        return buf[pos++] & 0xFF | (buf[pos++] & 0xFF) << 8 | (buf[pos++] & 0xFF) << 16 | (buf[pos++] & 0xFF) << 24;
    }

    private static long readLong(byte[] buf, int pos) {
        return (long)(buf[pos++] & 0xFF) | (long)(buf[pos++] & 0xFF) << 8 | (long)(buf[pos++] & 0xFF) << 16 | (long)(buf[pos++] & 0xFF) << 24 | (long)(buf[pos++] & 0xFF) << 32 | (long)(buf[pos++] & 0xFF) << 40 | (long)(buf[pos++] & 0xFF) << 48 | (long)(buf[pos++] & 0xFF) << 56;
    }

    private static byte[] readBytes(byte[] buf, int pos) {
        int length = ProfilerEvent.readInt(buf, pos);
        byte[] msg = new byte[length];
        System.arraycopy(buf, pos + 4, msg, 0, length);
        return msg;
    }
}

