/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.core;

import com.huawei.gauss200.jdbc.core.BaseQueryKey;
import com.huawei.gauss200.jdbc.core.CachedQuery;
import com.huawei.gauss200.jdbc.core.CallableQueryKey;
import com.huawei.gauss200.jdbc.core.JdbcCallParseInfo;
import com.huawei.gauss200.jdbc.core.NativeQuery;
import com.huawei.gauss200.jdbc.core.Parser;
import com.huawei.gauss200.jdbc.core.Query;
import com.huawei.gauss200.jdbc.core.QueryExecutor;
import com.huawei.gauss200.jdbc.core.QueryWithReturningColumnsKey;
import com.huawei.gauss200.jdbc.jdbc.PreferQueryMode;
import com.huawei.gauss200.jdbc.util.LruCache;
import java.sql.SQLException;
import java.util.List;

class CachedQueryCreateAction
implements LruCache.CreateAction<Object, CachedQuery> {
    private static final String[] EMPTY_RETURNING = new String[0];
    private final QueryExecutor queryExecutor;

    CachedQueryCreateAction(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @Override
    public CachedQuery create(Object key) throws SQLException {
        boolean isFunction;
        String parsedSql;
        BaseQueryKey queryKey;
        assert (key instanceof String || key instanceof BaseQueryKey) : "Query key should be String or BaseQueryKey. Given " + key.getClass() + ", sql: " + String.valueOf(key);
        if (key instanceof BaseQueryKey) {
            queryKey = (BaseQueryKey)key;
            parsedSql = queryKey.sql;
        } else {
            queryKey = null;
            parsedSql = (String)key;
        }
        if (key instanceof String || queryKey.escapeProcessing) {
            parsedSql = Parser.replaceProcessing(parsedSql, true, this.queryExecutor.getStandardConformingStrings());
        }
        if (key instanceof CallableQueryKey) {
            JdbcCallParseInfo callInfo = Parser.modifyJdbcCall(parsedSql, this.queryExecutor.getStandardConformingStrings(), this.queryExecutor.getServerVersionNum(), this.queryExecutor.getProtocolVersion());
            parsedSql = callInfo.getSql();
            isFunction = callInfo.isFunction();
        } else {
            isFunction = false;
        }
        boolean isParameterized = key instanceof String || queryKey.isParameterized;
        boolean splitStatements = isParameterized || this.queryExecutor.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) >= 0;
        String[] returningColumns = key instanceof QueryWithReturningColumnsKey ? ((QueryWithReturningColumnsKey)key).columnNames : EMPTY_RETURNING;
        List<NativeQuery> queries = Parser.parseJdbcSql(parsedSql, this.queryExecutor.getStandardConformingStrings(), isParameterized, splitStatements, this.queryExecutor.isReWriteBatchedInsertsEnabled(), returningColumns);
        Query query = this.queryExecutor.wrap(queries);
        return new CachedQuery(key, query, isFunction);
    }
}

