/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.core;

import com.huawei.gauss200.jdbc.core.Parser;
import com.huawei.gauss200.jdbc.util.GT;
import com.huawei.gauss200.jdbc.util.PSQLException;
import com.huawei.gauss200.jdbc.util.PSQLState;

public final class CommandCompleteParser {
    private long oid;
    private long rows;
    private long[] rowsArray;

    public long getOid() {
        return this.oid;
    }

    public long[] getRowsArray() {
        return this.rowsArray;
    }

    public long getRows() {
        return this.rows;
    }

    void set(long oid, long rows) {
        this.oid = oid;
        this.rows = rows;
    }

    public void parseMulti(String status) throws PSQLException {
        int leftBracket = status.indexOf(40);
        int rightBracket = status.lastIndexOf(41);
        if (leftBracket == -1 || rightBracket == -1 || leftBracket >= rightBracket) {
            throw new PSQLException(GT.tr("Unable to parse the count in command completion tag: {0}.", status), PSQLState.CONNECTION_FAILURE);
        }
        try {
            String[] rowStrs = status.substring(leftBracket + 1, rightBracket).split(",");
            this.rowsArray = new long[rowStrs.length];
            for (int i = 0; i < rowStrs.length; ++i) {
                this.rowsArray[i] = Long.parseLong(rowStrs[i]);
            }
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("Unable to parse the count in command completion tag: {0}.", status), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    public void parseSingle(String status) throws PSQLException {
        if (!Parser.isDigitAt(status, status.length() - 1)) {
            this.set(0L, 0L);
            return;
        }
        long oidParse = 0L;
        long rowsParse = 0L;
        try {
            int lastSpace = status.lastIndexOf(32);
            if (Parser.isDigitAt(status, lastSpace + 1)) {
                int penultimateSpace;
                rowsParse = Parser.parseLong(status, lastSpace + 1, status.length());
                if (Parser.isDigitAt(status, lastSpace - 1) && Parser.isDigitAt(status, (penultimateSpace = status.lastIndexOf(32, lastSpace - 1)) + 1)) {
                    oidParse = Parser.parseLong(status, penultimateSpace + 1, lastSpace);
                }
            }
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Unable to parse the count in command completion tag: {0}.", status), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        this.set(oidParse, rowsParse);
    }

    public String toString() {
        return "CommandStatus{oid=" + this.oid + ", rows=" + this.rows + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandCompleteParser that = (CommandCompleteParser)o;
        if (this.oid != that.oid) {
            return false;
        }
        return this.rows == that.rows;
    }

    public int hashCode() {
        int result = (int)(this.oid ^ this.oid >>> 32);
        result = 31 * result + (int)(this.rows ^ this.rows >>> 32);
        return result;
    }
}

