/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.core;

import com.huawei.gauss200.jdbc.core.Encoding;
import com.huawei.gauss200.jdbc.util.GT;
import java.io.IOException;

class UTF8Encoding
extends Encoding {
    private static final int MIN_2_BYTES = 128;
    private static final int MIN_3_BYTES = 2048;
    private static final int MIN_4_BYTES = 65536;
    private static final int MAX_CODE_POINT = 0x10FFFF;
    private char[] decoderArray = new char[1024];

    UTF8Encoding(String jvmEncoding) {
        super(jvmEncoding);
    }

    private static void checkByte(int ch, int pos, int len) throws IOException {
        if ((ch & 0xC0) != 128) {
            throw new IOException(GT.tr("Illegal UTF-8 sequence: byte {0} of {1} byte sequence is not 10xxxxxx: {2}", pos, len, ch));
        }
    }

    private static void checkMinimal(int ch, int minValue) throws IOException {
        int expectedLen;
        int actualLen;
        if (ch >= minValue) {
            return;
        }
        switch (minValue) {
            case 128: {
                actualLen = 2;
                break;
            }
            case 2048: {
                actualLen = 3;
                break;
            }
            case 65536: {
                actualLen = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected minValue passed to checkMinimal: " + minValue);
            }
        }
        if (ch < 128) {
            expectedLen = 1;
        } else if (ch < 2048) {
            expectedLen = 2;
        } else if (ch < 65536) {
            expectedLen = 3;
        } else {
            throw new IllegalArgumentException("unexpected ch passed to checkMinimal: " + ch);
        }
        throw new IOException(GT.tr("Illegal UTF-8 sequence: {0} bytes used to encode a {1} byte value: {2}", actualLen, expectedLen, ch));
    }

    @Override
    public synchronized String decode(byte[] data, int offset, int length) throws IOException {
        char[] cdata = this.decoderArray;
        if (cdata.length < length) {
            cdata = this.decoderArray = new char[length];
        }
        int in = offset;
        int out = 0;
        int end = length + offset;
        try {
            while (in < end) {
                int ch;
                if ((ch = data[in++] & 0xFF) >= 128) {
                    if (ch < 192) {
                        throw new IOException(GT.tr("Illegal UTF-8 sequence: initial byte is {0}: {1}", "10xxxxxx", ch));
                    }
                    if (ch < 224) {
                        ch = (ch & 0x1F) << 6;
                        UTF8Encoding.checkByte(data[in], 2, 2);
                        UTF8Encoding.checkMinimal(ch |= data[in++] & 0x3F, 128);
                    } else if (ch < 240) {
                        ch = (ch & 0xF) << 12;
                        UTF8Encoding.checkByte(data[in], 2, 3);
                        ch |= (data[in++] & 0x3F) << 6;
                        UTF8Encoding.checkByte(data[in], 3, 3);
                        UTF8Encoding.checkMinimal(ch |= data[in++] & 0x3F, 2048);
                    } else if (ch < 248) {
                        ch = (ch & 7) << 18;
                        UTF8Encoding.checkByte(data[in], 2, 4);
                        ch |= (data[in++] & 0x3F) << 12;
                        UTF8Encoding.checkByte(data[in], 3, 4);
                        ch |= (data[in++] & 0x3F) << 6;
                        UTF8Encoding.checkByte(data[in], 4, 4);
                        UTF8Encoding.checkMinimal(ch |= data[in++] & 0x3F, 65536);
                    } else {
                        throw new IOException(GT.tr("Illegal UTF-8 sequence: initial byte is {0}: {1}", "11111xxx", ch));
                    }
                }
                if (ch > 0x10FFFF) {
                    throw new IOException(GT.tr("Illegal UTF-8 sequence: final value is out of range: {0}", ch));
                }
                if (ch > 65535) {
                    cdata[out++] = (char)(55296 + ((ch -= 65536) >> 10));
                    cdata[out++] = (char)(56320 + (ch & 0x3FF));
                    continue;
                }
                if (ch >= 55296 && ch < 57344) {
                    throw new IOException(GT.tr("Illegal UTF-8 sequence: final value is a surrogate value: {0}", ch));
                }
                cdata[out++] = (char)ch;
            }
        }
        catch (ArrayIndexOutOfBoundsException a) {
            throw new IOException("Illegal UTF-8 sequence: multibyte sequence was truncated");
        }
        if (in > end) {
            throw new IOException("Illegal UTF-8 sequence: multibyte sequence was truncated");
        }
        return new String(cdata, 0, out);
    }
}

