/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.core.types;

import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class PGClob
implements Clob {
    private char[] buf = new char[0];
    private Clob clob;
    private long len;
    private long origLen;

    @Override
    public long length() throws SQLException {
        return this.len;
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (length == 0) {
            return "";
        }
        this.isValid();
        if (pos < 1L || pos > this.length()) {
            throw new SQLException("Invalid position in SerialClob object set");
        }
        if (pos - 1L + (long)length > this.length()) {
            throw new SQLException("Invalid position and substring length");
        }
        try {
            return new String(this.buf, (int)pos - 1, length);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new SQLException("StringIndexOutOfBoundsException: " + e.getMessage());
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.isValid();
        return new CharArrayReader(this.buf);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.isValid();
        if (this.clob != null) {
            return this.clob.getAsciiStream();
        }
        throw new SQLException("Unsupported operation. SerialClob cannot return a the CLOB value as an ascii stream, unless instantiated with a fully implemented Clob object.");
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        this.isValid();
        if (start < 1L || start > this.len) {
            return -1L;
        }
        char[] pattern = searchstr.toCharArray();
        int pos = (int)start - 1;
        long patlen = pattern.length;
        while ((long)pos < this.len) {
            if (pattern[0] == this.buf[pos]) {
                boolean flag = true;
                int j = 0;
                while ((long)j < patlen) {
                    if (pattern[j] != this.buf[pos + j]) {
                        flag = false;
                    }
                    ++j;
                }
                if (flag) {
                    return pos + 1;
                }
                ++pos;
                continue;
            }
            ++pos;
        }
        return -1L;
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        this.isValid();
        return this.position(searchstr.getSubString(1L, (int)searchstr.length()), start);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        char[] ch = str.toCharArray();
        this.len = ch.length;
        this.buf = new char[(int)this.len];
        int i = 0;
        while ((long)i < this.len) {
            this.buf[i] = ch[i];
            ++i;
        }
        this.origLen = this.len;
        this.clob = null;
        if (this.len == 0L) {
            return 0;
        }
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        int i;
        this.isValid();
        String temp = str.substring(offset);
        char[] cPattern = temp.toCharArray();
        if (offset < 0 || offset > str.length()) {
            throw new SQLException("Invalid offset in byte array set");
        }
        if (pos < 1L || pos > this.length()) {
            throw new SQLException("Invalid position in Clob object set");
        }
        if ((long)len > this.origLen) {
            throw new SQLException("Buffer is not sufficient to hold the value");
        }
        if (len + offset > str.length()) {
            throw new SQLException("Invalid OffSet. Cannot have combined offset  and length that is greater that the Blob buffer");
        }
        --pos;
        for (i = 0; i < len || offset + i + 1 < str.length() - offset; ++i) {
            this.buf[(int)pos + i] = cPattern[offset + i];
        }
        return i;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.isValid();
        if (this.clob != null) {
            return this.clob.setAsciiStream(pos);
        }
        throw new SQLException("Unsupported operation. SerialClob cannot return a writable ascii stream\n unless instantiated with a Clob object that has a setAsciiStream() implementation");
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.isValid();
        if (this.clob != null) {
            return this.clob.setCharacterStream(pos);
        }
        throw new SQLException("Unsupported operation. SerialClob cannot return a writable character stream\n unless instantiated with a Clob object that has a setCharacterStream implementation");
    }

    @Override
    public void truncate(long length) throws SQLException {
        this.isValid();
        if (length > this.len) {
            throw new SQLException("Length more than what can be truncated");
        }
        this.len = length;
        this.buf = this.len == 0L ? new char[0] : this.getSubString(1L, (int)this.len).toCharArray();
    }

    @Override
    public void free() throws SQLException {
        if (this.buf != null) {
            this.buf = null;
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.isValid();
        if (pos < 1L || pos > this.len) {
            throw new SQLException("Invalid position in Clob object set");
        }
        if (pos - 1L + length > this.len) {
            throw new SQLException("Invalid position and substring length");
        }
        if (length <= 0L) {
            throw new SQLException("Invalid length specified");
        }
        return new CharArrayReader(this.buf, (int)pos, (int)length);
    }

    private void isValid() throws SQLException {
        if (this.buf == null) {
            throw new SQLException("Error: You cannot call a method on a SerialClob instance once free() has been called.");
        }
    }

    public Clob getClob() {
        return this.clob;
    }

    public void setClob(Clob clob) {
        this.clob = clob;
    }
}

