/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gauss200.jdbc.util;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionProperties
extends Properties {
    private static final Pattern EXPRESSION = Pattern.compile("\\$\\{([^}]+)\\}");
    private final Properties[] defaults;

    public ExpressionProperties(Properties ... defaults) {
        this.defaults = defaults;
    }

    @Override
    public String getProperty(String key) {
        String value = this.getRawPropertyValue(key);
        return this.replaceProperties(value);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getRawPropertyValue(key);
        if (value == null) {
            value = defaultValue;
        }
        return this.replaceProperties(value);
    }

    public String getRawPropertyValue(String key) {
        String value = super.getProperty(key);
        if (value != null) {
            return value;
        }
        for (Properties properties : this.defaults) {
            value = properties.getProperty(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private String replaceProperties(String value) {
        if (value == null) {
            return null;
        }
        Matcher matcher = EXPRESSION.matcher(value);
        StringBuffer sb = null;
        while (matcher.find()) {
            String propValue;
            if (sb == null) {
                sb = new StringBuffer();
            }
            if ((propValue = this.getProperty(matcher.group(1))) == null) {
                propValue = matcher.group();
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(propValue));
        }
        if (sb == null) {
            return value;
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

