/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.apigateway.sdk.utils;

import com.huawei.shade.com.cloud.apigateway.sdk.utils.AccessService;
import com.huawei.shade.com.cloud.sdk.DefaultRequest;
import com.huawei.shade.com.cloud.sdk.auth.credentials.BasicCredentials;
import com.huawei.shade.com.cloud.sdk.auth.signer.Signer;
import com.huawei.shade.com.cloud.sdk.auth.signer.SignerFactory;
import com.huawei.shade.com.cloud.sdk.http.HttpMethodName;
import com.huawei.shade.org.apache.http.Header;
import com.huawei.shade.org.apache.http.client.methods.HttpDelete;
import com.huawei.shade.org.apache.http.client.methods.HttpGet;
import com.huawei.shade.org.apache.http.client.methods.HttpHead;
import com.huawei.shade.org.apache.http.client.methods.HttpOptions;
import com.huawei.shade.org.apache.http.client.methods.HttpPatch;
import com.huawei.shade.org.apache.http.client.methods.HttpPost;
import com.huawei.shade.org.apache.http.client.methods.HttpPut;
import com.huawei.shade.org.apache.http.client.methods.HttpRequestBase;
import com.huawei.shade.org.apache.http.entity.InputStreamEntity;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;

public class AccessServiceImpl
extends AccessService {
    public AccessServiceImpl(String ak, String sk) {
        super(ak, sk);
    }

    @Override
    public HttpRequestBase access(String url, Map<String, String> headers, InputStream content, Long contentLength, HttpMethodName httpMethod) throws Exception {
        DefaultRequest request = new DefaultRequest();
        String host = "";
        String queryString = "";
        try {
            if (url.contains("?")) {
                host = url.substring(0, url.indexOf("?"));
                queryString = url.substring(url.indexOf("?") + 1);
            } else {
                host = url;
            }
            request.setEndpoint(new URL(host).toURI());
            if (url.contains("?") && null != queryString && !"".equals(queryString)) {
                String[] parameterarray;
                for (String p : parameterarray = queryString.split("&")) {
                    String[] p_split = p.split("=", 2);
                    String key = p_split[0];
                    String value = "";
                    if (p_split.length >= 2) {
                        value = p_split[1];
                    }
                    request.addParameter(URLDecoder.decode(key, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        request.setHttpMethod(httpMethod);
        if (headers != null) {
            request.setHeaders(headers);
        }
        request.setContent(content);
        Signer signer = SignerFactory.getSigner();
        signer.sign(request, new BasicCredentials(this.ak, this.sk));
        HttpRequestBase httpRequestBase = AccessServiceImpl.createRequest(url, null, request.getContent(), contentLength, httpMethod);
        Map<String, String> requestHeaders = request.getHeaders();
        for (String key : requestHeaders.keySet()) {
            if (key.equalsIgnoreCase("Content-Length".toString())) continue;
            String value = requestHeaders.get(key);
            httpRequestBase.addHeader(key, new String(value.getBytes("UTF-8"), "ISO-8859-1"));
        }
        return httpRequestBase;
    }

    private static HttpRequestBase createRequest(String url, Header header, InputStream content, Long contentLength, HttpMethodName httpMethod) {
        HttpRequestBase httpRequest;
        if (httpMethod == HttpMethodName.POST) {
            HttpPost postMethod = new HttpPost(url.toString());
            if (content != null) {
                InputStreamEntity entity = new InputStreamEntity(content, contentLength);
                postMethod.setEntity(entity);
            }
            httpRequest = postMethod;
        } else if (httpMethod == HttpMethodName.PUT) {
            HttpPut putMethod = new HttpPut(url.toString());
            httpRequest = putMethod;
            if (content != null) {
                InputStreamEntity entity = new InputStreamEntity(content, contentLength);
                putMethod.setEntity(entity);
            }
        } else if (httpMethod == HttpMethodName.PATCH) {
            HttpPatch patchMethod = new HttpPatch(url.toString());
            httpRequest = patchMethod;
            if (content != null) {
                InputStreamEntity entity = new InputStreamEntity(content, contentLength);
                patchMethod.setEntity(entity);
            }
        } else if (httpMethod == HttpMethodName.GET) {
            httpRequest = new HttpGet(url.toString());
        } else if (httpMethod == HttpMethodName.DELETE) {
            httpRequest = new HttpDelete(url.toString());
        } else if (httpMethod == HttpMethodName.OPTIONS) {
            httpRequest = new HttpOptions(url.toString());
        } else if (httpMethod == HttpMethodName.HEAD) {
            httpRequest = new HttpHead(url.toString());
        } else {
            throw new RuntimeException("Unknown HTTP method name: " + (Object)((Object)httpMethod));
        }
        httpRequest.addHeader(header);
        return httpRequest;
    }
}

