/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.apigateway.sdk.utils;

import com.huawei.shade.com.cloud.apigateway.sdk.utils.AccessServiceOkhttp;
import com.huawei.shade.com.cloud.sdk.DefaultRequest;
import com.huawei.shade.com.cloud.sdk.auth.credentials.BasicCredentials;
import com.huawei.shade.com.cloud.sdk.auth.signer.Signer;
import com.huawei.shade.com.cloud.sdk.auth.signer.SignerFactory;
import com.huawei.shade.com.cloud.sdk.http.HttpMethodName;
import java.io.ByteArrayInputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class AccessServiceOkhttpImpl
extends AccessServiceOkhttp {
    public AccessServiceOkhttpImpl(String ak, String sk) {
        super(ak, sk);
    }

    @Override
    public Request access(String url, Map<String, String> headers, String entity, HttpMethodName httpMethod) throws Exception {
        DefaultRequest request = new DefaultRequest();
        String host = "";
        String queryString = "";
        try {
            if (url.contains("?")) {
                host = url.substring(0, url.indexOf("?"));
                queryString = url.substring(url.indexOf("?") + 1);
            } else {
                host = url;
            }
            request.setEndpoint(new URL(host).toURI());
            if (url.contains("?") && null != queryString && !"".equals(queryString)) {
                String[] parameterarray;
                for (String p : parameterarray = queryString.split("&")) {
                    String[] p_split = p.split("=", 2);
                    String key = p_split[0];
                    String value = "";
                    if (p_split.length >= 2) {
                        value = p_split[1];
                    }
                    request.addParameter(URLDecoder.decode(key, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        request.setHttpMethod(httpMethod);
        if (headers != null) {
            request.setHeaders(headers);
        }
        if (entity != null) {
            ByteArrayInputStream content = new ByteArrayInputStream(entity.getBytes("UTF-8"));
            request.setContent(content);
        }
        Signer signer = SignerFactory.getSigner();
        signer.sign(request, new BasicCredentials(this.ak, this.sk));
        return AccessServiceOkhttpImpl.createRequest(url, request.getHeaders(), entity, httpMethod);
    }

    private static Request createRequest(String url, Map<String, String> headers, String body, HttpMethodName httpMethod) throws Exception {
        Request httpRequest;
        RequestBody entity = RequestBody.create((MediaType)MediaType.parse((String)""), (byte[])body.getBytes("UTF-8"));
        if (httpMethod == HttpMethodName.POST) {
            httpRequest = new Request.Builder().url(url).post(entity).build();
        } else if (httpMethod == HttpMethodName.PUT) {
            httpRequest = new Request.Builder().url(url).put(entity).build();
        } else if (httpMethod == HttpMethodName.PATCH) {
            httpRequest = new Request.Builder().url(url).patch(entity).build();
        } else if (httpMethod == HttpMethodName.DELETE) {
            httpRequest = new Request.Builder().url(url).delete(entity).build();
        } else if (httpMethod == HttpMethodName.GET) {
            httpRequest = new Request.Builder().url(url).get().build();
        } else if (httpMethod == HttpMethodName.HEAD) {
            httpRequest = new Request.Builder().url(url).head().build();
        } else if (httpMethod == HttpMethodName.OPTIONS) {
            httpRequest = new Request.Builder().url(url).method("OPTIONS", null).build();
        } else {
            throw new RuntimeException("Unknown HTTP method name: " + (Object)((Object)httpMethod));
        }
        for (String key : headers.keySet()) {
            httpRequest = httpRequest.newBuilder().addHeader(key, headers.get(key)).build();
        }
        return httpRequest;
    }
}

