/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.apigateway.sdk.utils;

import com.huawei.shade.com.cloud.apigateway.sdk.utils.AccessService;
import com.huawei.shade.com.cloud.apigateway.sdk.utils.AccessServiceImpl;
import com.huawei.shade.com.cloud.apigateway.sdk.utils.AccessServiceOkhttp;
import com.huawei.shade.com.cloud.apigateway.sdk.utils.AccessServiceOkhttpImpl;
import com.huawei.shade.com.cloud.apigateway.sdk.utils.Request;
import com.huawei.shade.com.cloud.sdk.http.HttpMethodName;
import com.huawei.shade.org.apache.http.client.methods.HttpRequestBase;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class Client {
    public static HttpRequestBase sign(Request request) throws Exception {
        String appKey = request.getKey();
        String appSecrect = request.getSecrect();
        String url = request.getUrl();
        String body = request.getBody();
        Map<String, String> headers = request.getHeaders();
        switch (request.getMethod()) {
            case GET: {
                return Client.get(appKey, appSecrect, url, headers);
            }
            case POST: {
                return Client.post(appKey, appSecrect, url, headers, body);
            }
            case PUT: {
                return Client.put(appKey, appSecrect, url, headers, body);
            }
            case PATCH: {
                return Client.patch(appKey, appSecrect, url, headers, body);
            }
            case DELETE: {
                return Client.delete(appKey, appSecrect, url, headers);
            }
            case HEAD: {
                return Client.head(appKey, appSecrect, url, headers);
            }
            case OPTIONS: {
                return Client.options(appKey, appSecrect, url, headers);
            }
        }
        throw new IllegalArgumentException(String.format("unsupported method:%s", request.getMethod().name()));
    }

    public static HttpRequestBase put(String ak, String sk, String requestUrl, Map<String, String> headers, String putBody) throws Exception {
        AccessServiceImpl accessService = new AccessServiceImpl(ak, sk);
        HttpMethodName httpMethod = HttpMethodName.PUT;
        if (putBody == null) {
            putBody = "";
        }
        byte[] bytes = putBody.getBytes("UTF-8");
        ByteArrayInputStream content = new ByteArrayInputStream(bytes);
        HttpRequestBase request = ((AccessService)accessService).access(requestUrl, headers, content, Long.valueOf(bytes.length), httpMethod);
        return request;
    }

    public static HttpRequestBase patch(String ak, String sk, String requestUrl, Map<String, String> headers, String body) throws Exception {
        AccessServiceImpl accessService = new AccessServiceImpl(ak, sk);
        HttpMethodName httpMethod = HttpMethodName.PATCH;
        if (body == null) {
            body = "";
        }
        byte[] bytes = body.getBytes("UTF-8");
        ByteArrayInputStream content = new ByteArrayInputStream(bytes);
        HttpRequestBase request = ((AccessService)accessService).access(requestUrl, headers, content, Long.valueOf(bytes.length), httpMethod);
        return request;
    }

    public static HttpRequestBase delete(String ak, String sk, String requestUrl, Map<String, String> headers) throws Exception {
        AccessServiceImpl accessService = new AccessServiceImpl(ak, sk);
        HttpMethodName httpMethod = HttpMethodName.DELETE;
        HttpRequestBase request = accessService.access(requestUrl, headers, httpMethod);
        return request;
    }

    public static HttpRequestBase get(String ak, String sk, String requestUrl, Map<String, String> headers) throws Exception {
        AccessServiceImpl accessService = new AccessServiceImpl(ak, sk);
        HttpMethodName httpMethod = HttpMethodName.GET;
        HttpRequestBase request = accessService.access(requestUrl, headers, httpMethod);
        return request;
    }

    public static HttpRequestBase post(String ak, String sk, String requestUrl, Map<String, String> headers, String postbody) throws Exception {
        AccessServiceImpl accessService = new AccessServiceImpl(ak, sk);
        if (postbody == null) {
            postbody = "";
        }
        HttpMethodName httpMethod = HttpMethodName.POST;
        byte[] bytes = postbody.getBytes("UTF-8");
        ByteArrayInputStream content = new ByteArrayInputStream(bytes);
        HttpRequestBase request = ((AccessService)accessService).access(requestUrl, headers, content, Long.valueOf(bytes.length), httpMethod);
        return request;
    }

    public static HttpRequestBase head(String ak, String sk, String requestUrl, Map<String, String> headers) throws Exception {
        AccessServiceImpl accessService = new AccessServiceImpl(ak, sk);
        HttpMethodName httpMethod = HttpMethodName.HEAD;
        HttpRequestBase request = accessService.access(requestUrl, headers, httpMethod);
        return request;
    }

    public static HttpRequestBase options(String ak, String sk, String requestUrl, Map<String, String> headers) throws Exception {
        AccessServiceImpl accessService = new AccessServiceImpl(ak, sk);
        HttpMethodName httpMethod = HttpMethodName.OPTIONS;
        HttpRequestBase request = accessService.access(requestUrl, headers, httpMethod);
        return request;
    }

    public static okhttp3.Request okhttpRequest(HttpMethodName httpMethod, String ak, String sk, String requestUrl, Map<String, String> headers, String body) throws Exception {
        switch (httpMethod) {
            case POST: 
            case PUT: 
            case PATCH: 
            case DELETE: {
                break;
            }
            case GET: 
            case HEAD: 
            case OPTIONS: {
                body = "";
                break;
            }
            default: {
                throw new RuntimeException("Unknown HTTP method name: " + (Object)((Object)httpMethod));
            }
        }
        if (body == null) {
            body = "";
        }
        AccessServiceOkhttpImpl accessService = new AccessServiceOkhttpImpl(ak, sk);
        okhttp3.Request request = ((AccessServiceOkhttp)accessService).access(requestUrl, headers, body, httpMethod);
        return request;
    }

    public static okhttp3.Request signOkhttp(Request request) throws Exception {
        return Client.okhttpRequest(request.getMethod(), request.getKey(), request.getSecrect(), request.getUrl(), request.getHeaders(), request.getBody());
    }
}

