/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.ds;

import com.huawei.opengauss.jdbc.ds.PGPooledConnection;
import com.huawei.opengauss.jdbc.ds.common.BaseDataSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class PGConnectionPoolDataSource
extends BaseDataSource
implements ConnectionPoolDataSource,
Serializable {
    private boolean defaultAutoCommit = true;

    @Override
    public String getDescription() {
        return "ConnectionPoolDataSource from PostgreSQL JDBC Driver /*$mvn.project.property.parsedversion.osgiversion$*/";
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return new PGPooledConnection(this.getConnection(), this.defaultAutoCommit);
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new PGPooledConnection(this.getConnection(user, password), this.defaultAutoCommit);
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeBaseObject(out);
        out.writeBoolean(this.defaultAutoCommit);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readBaseObject(in);
        this.defaultAutoCommit = in.readBoolean();
    }
}

