/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.jdbc;

import com.huawei.opengauss.jdbc.jdbc.PgConnection;
import com.huawei.opengauss.jdbc.log.Log;
import com.huawei.opengauss.jdbc.log.Logger;
import com.huawei.opengauss.jdbc.util.GT;
import com.huawei.opengauss.jdbc.util.PSQLException;
import com.huawei.opengauss.jdbc.util.PSQLState;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TypeNode {
    private static Log LOGGER = Logger.getLogger(TypeNode.class.getName());
    private String name = "";
    private String type = "";
    private String typinput = "";
    private int elemOid = 0;
    private int relOid = 0;
    private int oid = 0;
    private int index = 0;
    private int parentIndex = -1;
    private List<TypeNode> columnList = new ArrayList<TypeNode>();

    public TypeNode() {
    }

    private TypeNode(String name, String type, String typinput, int elem, int relid, int oid, int index, int parentIndex) {
        this.name = name;
        this.type = type;
        this.typinput = typinput;
        this.elemOid = elem;
        this.relOid = relid;
        this.oid = oid;
        this.index = index;
        this.parentIndex = parentIndex;
    }

    public List<TypeNode> getColumnList() {
        return this.columnList;
    }

    private void setColumnList(TypeNode typeNode) {
        this.columnList.add(typeNode);
    }

    private int getIndex() {
        return this.index;
    }

    private int getParentIndex() {
        return this.parentIndex;
    }

    public String getName() {
        return this.name;
    }

    public int getOid() {
        return this.oid;
    }

    private void initTypeFromRs(ResultSet rs, int index, int parentIndex) throws SQLException {
        this.type = rs.getString("typtype");
        this.typinput = rs.getString("typinput");
        this.elemOid = rs.getInt("typelem");
        this.relOid = rs.getInt("typrelid");
        this.oid = rs.getInt("oid");
        this.index = index;
        this.parentIndex = parentIndex;
    }

    private void initTableTypeFromRs(ResultSet rs, int index, int parentIndex) throws SQLException {
        this.name = rs.getString("typname");
        this.initTypeFromRs(rs, index, parentIndex);
    }

    private void initRecordTypeFromRs(ResultSet rs, int index, int parentIndex) throws SQLException {
        this.name = rs.getString("attname");
        this.initTypeFromRs(rs, index, parentIndex);
    }

    public boolean isBaseType() {
        return !this.isRecordType() && !this.isTableType() && !this.isArrayType();
    }

    public boolean isRecordType() {
        return this.elemOid == 0 && this.relOid != 0 && this.type.equals("c");
    }

    public boolean isTableType() {
        return this.relOid == 0 && this.elemOid != 0 && this.type.equals("o");
    }

    public boolean isArrayType() {
        return this.type.equals("b") && (this.typinput.equals("array_in") || this.typinput.equals("nesttable_in"));
    }

    public String toString() {
        return "[" + this.name + ", " + this.type + ", " + this.parentIndex + ", " + this.oid + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeNode getPGobjectStruct(Connection conn, String typeName) throws SQLException {
        if (typeName == null || typeName.equals("null")) {
            return new TypeNode();
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement("select pt.oid as oid  from pg_namespace pn left join pg_type pt on pn.oid=pt.typnamespace where pn.nspname || '.' || pt.typname = ?  union ( select pt.oid as oid  from pg_namespace pn left join pg_type pt on pn.oid=pt.typnamespace where nspname in ('pg_catalog', current_schema()) and typname = ? order by current_schema()=pn.nspname  desc limit 1 ) limit 1;");
            pstmt.setObject(1, typeName);
            pstmt.setObject(2, typeName);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                TypeNode typeNode = TypeNode.getNestedInfo(rs.getInt(1), conn);
                return typeNode;
            }
            TypeNode typeNode = new TypeNode();
            return typeNode;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    public static TypeNode getNestedInfo(Integer oid, Connection conn) throws SQLException {
        Integer nodeOid = oid;
        ArrayList<TypeNode> res = new ArrayList<TypeNode>();
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        Statement stmt = conn.createStatement();
        try {
            pstmt = conn.prepareStatement("select typname, typtype, typelem, typrelid, typinput from pg_type where oid = ?;");
            pstmt.setInt(1, nodeOid);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                TypeNode typeNode = new TypeNode();
                return typeNode;
            }
            String typname = rs.getString("typname");
            String typtype = rs.getString("typtype");
            String typinput = rs.getString("typinput");
            int typelem = rs.getInt("typelem");
            int typrelid = rs.getInt("typrelid");
            int index = 0;
            TypeNode nowLayer = new TypeNode(typname, typtype, typinput, typelem, typrelid, nodeOid, index, -1);
            if (nowLayer.isBaseType()) {
                res.add(nowLayer);
                if (res != null && res.size() > 0) {
                    TypeNode typeNode = (TypeNode)res.get(0);
                    return typeNode;
                }
                TypeNode typeNode = new TypeNode();
                return typeNode;
            }
            LinkedList<TypeNode> typeNodeQueue = new LinkedList<TypeNode>();
            typeNodeQueue.offer(nowLayer);
            res.add(nowLayer);
            ++index;
            PgConnection pgConn = (PgConnection)conn;
            int workingVersionNum = Integer.parseInt(pgConn.getQueryExecutor().getWorkingVersionNum());
            while (!typeNodeQueue.isEmpty()) {
                TypeNode curNode = (TypeNode)typeNodeQueue.poll();
                String sql = "";
                if (curNode.isTableType()) {
                    sql = workingVersionNum < 92820 ? "SELECT oid, typname, typtype, typelem, typrelid, typinput FROM pg_type WHERE oid = (SELECT typelem FROM pg_type WHERE oid = " + curNode.elemOid + ");" : "SELECT oid, typname, typtype, typelem, typrelid, typinput FROM pg_type WHERE oid = " + curNode.elemOid;
                } else if (curNode.isRecordType()) {
                    sql = "SELECT a.oid, a.typname, a.typtype, a.typelem, a.typrelid, a.typinput, b.attname FROM pg_type a join pg_attribute b on a.oid = b.atttypid and b.attrelid = " + curNode.relOid + "order by b.attnum;";
                } else {
                    if (!curNode.isArrayType()) continue;
                    sql = "SELECT oid, typname, typtype, typelem, typrelid, typinput FROM pg_type WHERE oid = " + curNode.elemOid;
                }
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    TypeNode newNode = new TypeNode();
                    if (curNode.isTableType() || curNode.isArrayType()) {
                        newNode.initTableTypeFromRs(rs, index++, curNode.index);
                    } else if (curNode.isRecordType()) {
                        newNode.initRecordTypeFromRs(rs, index++, curNode.index);
                    } else {
                        if (!LOGGER.isWarnEnabled()) continue;
                        LOGGER.warn("The query result is a basic type, which may cause construction failure.");
                        continue;
                    }
                    typeNodeQueue.offer(newNode);
                    res.add(newNode);
                }
            }
            TypeNode.convertToTreeStruct(res);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PSQLException(GT.tr("Type OID:" + nodeOid + ", Type structure query failed.", new Object[0]), PSQLState.DATA_ERROR);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
            stmt.close();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("OID: " + nodeOid + ", Composite type struct:" + res);
        }
        if (res != null && res.size() > 0) {
            return (TypeNode)res.get(0);
        }
        return new TypeNode();
    }

    public static void convertToTreeStruct(List<TypeNode> res) {
        ArrayDeque<TypeNode> queue = new ArrayDeque<TypeNode>();
        queue.add(res.get(0));
        while (!queue.isEmpty()) {
            TypeNode temp = (TypeNode)queue.poll();
            for (int i = temp.getIndex(); i < res.size(); ++i) {
                TypeNode next = res.get(i);
                if (next.getParentIndex() != temp.getIndex()) continue;
                queue.add(next);
                temp.setColumnList(next);
            }
        }
    }

    public static String removeQuotationMarks(String data) {
        if (data == null || data.length() < 2) {
            return data;
        }
        char[] values = data.toCharArray();
        if (values[0] == '\"' && values[values.length - 1] == '\"') {
            StringBuilder result = new StringBuilder();
            for (int i = 1; i < values.length - 1; ++i) {
                if (i + 1 < values.length && values[i] == '\\' && values[i + 1] == '\\') {
                    result.append(values[++i]);
                    continue;
                }
                if (values[i] == '\\') continue;
                result.append(values[i]);
                if (i + 1 >= values.length || values[i] != '\"' || values[i + 1] != '\"') continue;
                ++i;
            }
            return result.toString();
        }
        return data;
    }
}

