/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.jdbc.clientlogic;

import com.huawei.opengauss.jdbc.jdbc.PgConnection;
import com.huawei.opengauss.jdbc.jdbc.PgStatement;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.ClientLogicDecryptResult;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.LimitOffsetMetaData;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.SortColumnMetaData;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.TargetColumnMetaData;
import com.huawei.opengauss.jdbc.util.JdbcBlackHole;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class ClientLogicImpl {
    private long m_handle = 0L;
    private PgConnection m_jdbcConn = null;

    private native Object[] linkClientLogicImplExt(String var1, String var2);

    private native Object[] linkClientLogicImpl(String var1);

    private native Object[] setTokenToClientLogicImpl(long var1, byte[] var3, int var4, byte[] var5, int var6);

    private native Object[] fetchAndDeprocessColumnSettingImpl(long var1);

    private native Object[] setKmsInfoImpl(long var1, String var3, String var4);

    private native Object[] runQueryPreProcessImpl(long var1, String var3);

    private native Object[] runQueryPostProcessImpl(long var1);

    private native Object[] runClientLogicImpl(long var1, byte[] var3, int var4);

    private native Object[] getRecordIDsImpl(long var1, String var3, int var4);

    private native Object[] runClientLogic4RecordImpl(long var1, String var3, int[] var4);

    private native Object[] prepareQueryImpl(long var1, String var3, String var4, int var5);

    private native Object[] replaceStatementParamsImpl(long var1, String var3, String[] var4);

    private native Object[] replaceErrorMessageImpl(long var1, String var3);

    private native int processedQueryPosToDeprocessedImpl(long var1, int var3);

    private native Object[] reloadCacheImpl(long var1);

    private native Object[] reloadCacheIfNeededImpl(long var1);

    private native void destroy(long var1);

    private native boolean getSortingAndAggregationPostRequired(long var1);

    private native int getSortingAndAggregationTargetLengthImpl(long var1);

    private native int getSortingAndAggregationOrderByLengthImpl(long var1);

    private native int getSortingAndAggregationGroupByLengthImpl(long var1);

    private native boolean getSortingAndAggregationDistinctImpl(long var1);

    private native TargetColumnMetaData getSortingAndAggregationTargetAtIndexImpl(long var1, int var3);

    private native SortColumnMetaData getSortingAndAggregationOrderByAtIndexImpl(long var1, int var3);

    private native SortColumnMetaData getSortingAndAggregationGroupByAtIndexImpl(long var1, int var3);

    private native LimitOffsetMetaData getSortingAndAggregationLimitOffsetImpl(long var1);

    private native void resetSortingAndAggregationImpl(long var1);

    private native String divideImpl(long var1, String var3, String var4);

    private native int deprocessDataImpl(long var1, String var3, long var4, String var6, String var7, String var8, String[] var9, String[] var10, long[] var11);

    public int getSortingAndAggregationTargetLength() {
        return this.getSortingAndAggregationTargetLengthImpl(this.m_handle);
    }

    public TargetColumnMetaData getSortingAndAggregationTargetAtIndex(int index) {
        return this.getSortingAndAggregationTargetAtIndexImpl(this.m_handle, index);
    }

    public int getSortingAndAggregationOrderByLength() {
        return this.getSortingAndAggregationOrderByLengthImpl(this.m_handle);
    }

    public SortColumnMetaData getSortingAndAggregationOrderByAtIndex(int index) {
        return this.getSortingAndAggregationOrderByAtIndexImpl(this.m_handle, index);
    }

    public int getSortingAndAggregationGroupByLength() {
        return this.getSortingAndAggregationGroupByLengthImpl(this.m_handle);
    }

    public SortColumnMetaData getSortingAndAggregationGroupByAtIndex(int index) {
        return this.getSortingAndAggregationGroupByAtIndexImpl(this.m_handle, index);
    }

    public LimitOffsetMetaData getSortingAndAggregationLimitOffset() {
        return this.getSortingAndAggregationLimitOffsetImpl(this.m_handle);
    }

    public boolean getSortingAndAggregationPostRequired() {
        return this.getSortingAndAggregationPostRequired(this.m_handle);
    }

    public boolean getSortingAndAggregationDistinct() {
        return this.getSortingAndAggregationDistinctImpl(this.m_handle);
    }

    public void resetSortingAndAggregation() {
        this.resetSortingAndAggregationImpl(this.m_handle);
    }

    public String divide(String nom, String denom) {
        return this.divideImpl(this.m_handle, nom, denom);
    }

    public ClientLogicDecryptResult decryptData(String processedData, long processedDataSize, String schemaname, String tablename, String colname) {
        if (schemaname == null || tablename == null || colname == null) {
            return new ClientLogicDecryptResult("Invalid input for decryption.");
        }
        String[] type = new String[1];
        String[] plaintext = new String[1];
        long[] plaintextSize = new long[1];
        int ret_val = this.deprocessDataImpl(this.m_handle, processedData, processedDataSize, schemaname, tablename, colname, type, plaintext, plaintextSize);
        if (ret_val == 0) {
            this.reloadCache();
            ret_val = this.deprocessDataImpl(this.m_handle, processedData, processedDataSize, schemaname, tablename, colname, type, plaintext, plaintextSize);
        }
        if (ret_val == 0) {
            return new ClientLogicDecryptResult(plaintext[0]);
        }
        return new ClientLogicDecryptResult(type[0], plaintext[0], plaintextSize[0]);
    }

    public Object[] linkClientLogic(String databaseName, String pgClientLogic, PgConnection jdbcConn) {
        if (this.m_handle == 0L && this.m_jdbcConn == null) {
            this.m_jdbcConn = jdbcConn;
            return this.linkClientLogicImplExt(databaseName, pgClientLogic);
        }
        return new Object[0];
    }

    public Object[] fetchAndDecryptCek() {
        return this.fetchAndDeprocessColumnSettingImpl(this.m_handle);
    }

    public Object[] setKeyToClientLogic(byte[] rsaPubKey, int rsaPubKeyLen, byte[] ecdhKey, int ecdhKeyLen) {
        return this.setTokenToClientLogicImpl(this.m_handle, rsaPubKey, rsaPubKeyLen, ecdhKey, ecdhKeyLen);
    }

    public Object[] setKmsInfo(String key, String value) {
        return this.setKmsInfoImpl(this.m_handle, key, value);
    }

    public Object[] runQueryPreProcess(String originalQuery) {
        return this.runQueryPreProcessImpl(this.m_handle, originalQuery);
    }

    public Object[] runClientLogic(byte[] data2Process, int dataType) {
        return this.runClientLogicImpl(this.m_handle, data2Process, dataType);
    }

    public Object[] getRecordIDs(String dataTypeName, int oid) {
        return this.getRecordIDsImpl(this.m_handle, dataTypeName, oid);
    }

    public Object[] runClientLogic4Record(String data2Process, int[] originalOids) {
        return this.runClientLogic4RecordImpl(this.m_handle, data2Process, originalOids);
    }

    public Object[] runQueryPostProcess() {
        return this.runQueryPostProcessImpl(this.m_handle);
    }

    public Object[] prepareQuery(String query, String statement_name, int parameter_count) {
        return this.prepareQueryImpl(this.m_handle, query, statement_name, parameter_count);
    }

    public Object[] replaceStatementParams(String statementName, String[] paramValues) {
        return this.replaceStatementParamsImpl(this.m_handle, statementName, paramValues);
    }

    public Object[] replaceErrorMessage(String originalMessage) {
        return this.replaceErrorMessageImpl(this.m_handle, originalMessage);
    }

    public int processedQueryPosToDeprocessed(int processedPos) {
        return this.processedQueryPosToDeprocessedImpl(this.m_handle, processedPos);
    }

    protected void close() {
        if (this.m_handle > 0L) {
            this.destroy(this.m_handle);
        }
        this.m_handle = 0L;
    }

    protected void finalize() {
        this.close();
    }

    public void setHandle(long handle) {
        this.m_handle = handle;
    }

    public long getHandle() {
        return this.m_handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] fetchDataFromQuery(String query) {
        PgStatement st = null;
        ArrayList<Object> data = new ArrayList<Object>();
        data.add("");
        try {
            st = (PgStatement)this.m_jdbcConn.createStatement();
            ResultSet rs = st.executeQueryWithNoCL(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnsCount = rsmd.getColumnCount();
            ArrayList<String> headers = new ArrayList<String>();
            for (int colIndex = 0; colIndex < columnsCount; ++colIndex) {
                headers.add(rsmd.getColumnName(colIndex + 1));
            }
            data.add(headers.toArray());
            while (rs.next()) {
                ArrayList<String> record = new ArrayList<String>();
                for (int colIndex = 1; colIndex < columnsCount + 1; ++colIndex) {
                    String colValue = rs.getString(colIndex);
                    if (colValue == null) {
                        colValue = "";
                    }
                    record.add(colValue);
                }
                data.add(record.toArray());
            }
            st.close();
        }
        catch (SQLException e) {
            Object[] objectArray;
            try {
                ArrayList<String> errorResponse = new ArrayList<String>();
                errorResponse.add(e.getMessage());
                objectArray = errorResponse.toArray();
            }
            catch (Throwable throwable) {
                JdbcBlackHole.close(st);
                throw throwable;
            }
            JdbcBlackHole.close(st);
            return objectArray;
        }
        JdbcBlackHole.close(st);
        return data.toArray();
    }

    public Object[] reloadCache() {
        return this.reloadCacheImpl(this.m_handle);
    }

    public Object[] reloadCacheIfNeeded() {
        return this.reloadCacheIfNeededImpl(this.m_handle);
    }

    static {
        System.loadLibrary("gauss_cl_jni");
    }
}

