/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.jdbc.clientlogic;

import com.huawei.opengauss.jdbc.core.Field;
import com.huawei.opengauss.jdbc.jdbc.PgResultSet;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.SortColumnMetaData;
import java.sql.SQLException;
import java.util.Comparator;

public class OrderByComparator
implements Comparator<byte[][]> {
    private SortColumnMetaData[] sortList;
    private PgResultSet resultSet;

    public OrderByComparator(SortColumnMetaData[] orderByList, PgResultSet result) {
        this.sortList = orderByList;
        this.resultSet = result;
    }

    @Override
    public int compare(byte[][] p1, byte[][] p2) {
        int cmp = 0;
        if (this.sortList != null) {
            SortColumnMetaData element;
            for (int sortElem = 0; sortElem < this.sortList.length && (cmp = this.compareInner(p1, p2, element = this.sortList[sortElem])) == 0; ++sortElem) {
            }
        }
        return cmp;
    }

    private int compareInner(byte[][] p1, byte[][] p2, SortColumnMetaData element) {
        for (int i = 0; i < this.resultSet.getFields().length; ++i) {
            boolean isSecondNull;
            Field field = this.resultSet.getFields()[i];
            String fieldName = field.getColumnLabel();
            if (!fieldName.equals(element.getColumn()) && !fieldName.equals(element.getAlias())) continue;
            int directionFactor = element.getSortByDir() == 0 || element.getSortByDir() == 1 ? 1 : -1;
            int nullFirstFactor = 1;
            nullFirstFactor = element.getSortByNulls() == 0 ? directionFactor : (element.getSortByNulls() == 1 ? -1 : 1);
            boolean isFirstNull = p1[i] == null || p1[i].length == 0;
            boolean bl = isSecondNull = p2[i] == null || p2[i].length == 0;
            if (isFirstNull && isSecondNull) {
                return 0;
            }
            if (isFirstNull && !isSecondNull) {
                return 1 * nullFirstFactor;
            }
            if (!isFirstNull && isSecondNull) {
                return -1 * nullFirstFactor;
            }
            try {
                return this.resultSet.compareValues(p1[i], p2[i], field, false) * directionFactor;
            }
            catch (SQLException e) {
                return 0;
            }
        }
        return 0;
    }
}

