/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.util;

import com.huawei.opengauss.jdbc.log.Log;
import com.huawei.opengauss.jdbc.log.Logger;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedTimer {
    private static final AtomicInteger timerCount = new AtomicInteger(0);
    private static Log LOGGER = Logger.getLogger(SharedTimer.class.getName());
    private volatile Timer timer = null;
    private final AtomicInteger refCount = new AtomicInteger(0);

    public int getRefCount() {
        return this.refCount.get();
    }

    public synchronized Timer getTimer() {
        if (this.timer == null) {
            int index = timerCount.incrementAndGet();
            ClassLoader prevContextCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(null);
                this.timer = new Timer("PostgreSQL-JDBC-SharedTimer-" + index, true);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevContextCL);
            }
        }
        this.refCount.incrementAndGet();
        return this.timer;
    }

    public synchronized void releaseTimer() {
        int count = this.refCount.decrementAndGet();
        if (count > 0) {
            LOGGER.trace("Outstanding references still exist so not closing shared Timer");
        } else if (count == 0) {
            LOGGER.trace("No outstanding references to shared Timer, will cancel and close it");
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        } else {
            LOGGER.warn("releaseTimer() called too many times; there is probably a bug in the calling code");
            this.refCount.set(0);
        }
    }
}

